/*
 * Decompiled with CFR 0.152.
 */
package net.isger.util.reflect;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import net.isger.util.Asserts;
import net.isger.util.Reflects;

public class TypeToken<T> {
    private Type type;
    private Class<? super T> rawClass;
    private int hashCode;

    protected TypeToken() {
        this.setToken(this.getActualType(this.getClass()));
    }

    private TypeToken(Type type) {
        this.setToken(type);
    }

    private void setToken(Type type) {
        this.type = Reflects.toCanonicalize(Asserts.isNotNull(type));
        this.rawClass = Reflects.getRawClass(this.type);
        this.hashCode = this.type.hashCode();
    }

    private Type getActualType(Class<?> type) {
        Type superType = type.getGenericSuperclass();
        Asserts.isInstance(ParameterizedType.class, superType, "Missing type parameter", new Object[0]);
        ParameterizedType paramType = (ParameterizedType)superType;
        return paramType.getActualTypeArguments()[0];
    }

    public final Class<? super T> getRawClass() {
        return this.rawClass;
    }

    public final Type getType() {
        return this.type;
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final boolean equals(Object o) {
        return o instanceof TypeToken && Reflects.equals(this.type, ((TypeToken)o).type);
    }

    public final String toString() {
        return Reflects.getName(this.type);
    }

    public static TypeToken<?> get(Type type) {
        return new TypeToken(type);
    }

    public static <T> TypeToken<T> get(Class<T> type) {
        return new TypeToken<T>(type);
    }
}

