/*
 * Decompiled with CFR 0.152.
 */
package net.isger.util.reflect.conversion;

import java.lang.reflect.Type;
import net.isger.util.Asserts;
import net.isger.util.Reflects;
import net.isger.util.reflect.ClassAssembler;
import net.isger.util.reflect.conversion.Conversion;

public class ClassConversion
implements Conversion {
    public static final ClassConversion CONVERSION = new ClassConversion();

    private ClassConversion() {
    }

    @Override
    public boolean isSupport(Type type) {
        return Reflects.getRawClass(type).equals(Class.class);
    }

    @Override
    public Object convert(Type type, Object value, ClassAssembler assembler) {
        if (value instanceof String) {
            Class<?> result = Reflects.getClass((String)value);
            if (result != null) {
                return result;
            }
        } else if (value instanceof Type) {
            return Reflects.getRawClass((Type)value);
        }
        throw Asserts.state("Unexpected class conversion for %s", value);
    }

    public String toString() {
        return "class";
    }
}

