/*
 * Decompiled with CFR 0.152.
 */
package net.isger.util.reflect.conversion;

import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import net.isger.util.Reflects;
import net.isger.util.Strings;
import net.isger.util.reflect.ClassAssembler;
import net.isger.util.reflect.Converter;
import net.isger.util.reflect.conversion.Conversion;

public class NumberConversion
implements Conversion {
    public static final NumberConversion CONVERSION = new NumberConversion();

    private NumberConversion() {
    }

    @Override
    public boolean isSupport(Type type) {
        Class<?> rawClass = Reflects.getRawClass(type);
        return Boolean.class.isAssignableFrom(rawClass) || Character.class.isAssignableFrom(rawClass) || Number.class.isAssignableFrom(rawClass) || rawClass.isPrimitive();
    }

    @Override
    public Object convert(Type type, Object value, ClassAssembler assembler) {
        Class<?> rawClass = Reflects.getRawClass(type);
        if (Strings.isEmpty(value)) {
            return Converter.defaultValue(rawClass);
        }
        Number source = value instanceof Number ? (Number)((Number)value) : (Number)(value instanceof Boolean ? (Number)((Boolean)value != false ? 1 : 0) : (Number)(value instanceof byte[] ? (Number)Double.parseDouble(new String((byte[])value)) : (Number)(value instanceof JsonElement ? (Number)((JsonElement)value).getAsNumber() : (Number)Double.parseDouble(value.toString().trim()))));
        if (Boolean.class.isAssignableFrom(rawClass) || Boolean.TYPE.isAssignableFrom(rawClass)) {
            return source.intValue() != 0;
        }
        if (Character.class.isAssignableFrom(rawClass) || Character.TYPE.isAssignableFrom(rawClass)) {
            return Character.valueOf((char)source.byteValue());
        }
        if (Short.class.isAssignableFrom(rawClass) || Short.TYPE.isAssignableFrom(rawClass)) {
            return source.shortValue();
        }
        if (Integer.class.isAssignableFrom(rawClass) || Integer.TYPE.isAssignableFrom(rawClass)) {
            return source.intValue();
        }
        if (Long.class.isAssignableFrom(rawClass) || Long.TYPE.isAssignableFrom(rawClass)) {
            return source.longValue();
        }
        if (Float.class.isAssignableFrom(rawClass) || Float.TYPE.isAssignableFrom(rawClass)) {
            return Float.valueOf(source.floatValue());
        }
        if (Double.class.isAssignableFrom(rawClass) || Double.TYPE.isAssignableFrom(rawClass)) {
            return source.doubleValue();
        }
        return source.intValue();
    }

    public String toString() {
        return "number";
    }
}

