/*
 * Decompiled with CFR 0.152.
 */
package net.isger.util.scan;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.isger.util.scan.AbstractScan;
import net.isger.util.scan.ScanFilter;

public class FileScan
extends AbstractScan {
    private static final String PROTOCOL = "file";

    @Override
    protected String getProtocol() {
        return PROTOCOL;
    }

    @Override
    public List<String> scan(String path, ScanFilter filter) {
        List<String> result = null;
        File root = new File(path);
        if (root.isDirectory()) {
            result = this.scan(root, root, filter);
        }
        return result;
    }

    private List<String> scan(File root, File path, ScanFilter filter) {
        ArrayList<String> result = new ArrayList<String>();
        File[] files = path.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isFile()) {
                    if (!filter.accept(file.getName())) continue;
                    result.add(this.getName(root, file));
                    continue;
                }
                if (!file.isDirectory() || !filter.isDeep(root, file)) continue;
                result.addAll(this.scan(root, file, filter));
            }
        }
        return result;
    }
}

