/*
 * Decompiled with CFR 0.152.
 */
package net.isger.util.scan;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.isger.util.Files;
import net.isger.util.scan.AbstractScan;
import net.isger.util.scan.ScanFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarScan
extends AbstractScan {
    private static final String PROTOCOL = "jar";
    private static final Logger LOG = LoggerFactory.getLogger(JarScan.class);

    @Override
    protected String getProtocol() {
        return PROTOCOL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> scan(String path, ScanFilter filter) {
        File workPath = null;
        int index = path.lastIndexOf("jar!/");
        if (index != -1) {
            workPath = new File(path.substring(index + 5));
            path = path.substring(0, index + 3);
        } else if (!path.endsWith(".jar")) {
            throw new IllegalStateException("Have the ability to give " + path + " of jar");
        }
        ArrayList<String> result = new ArrayList<String>();
        JarInputStream zis = null;
        try {
            zis = Files.openJarIS(path);
            ZipEntry entry = null;
            while ((entry = ((ZipInputStream)zis).getNextEntry()) != null) {
                if (!this.match(workPath, entry, filter)) continue;
                result.add(this.getName(workPath, new File(entry.getName())));
            }
        }
        catch (IOException e) {
            LOG.warn("Error scanning hicher from path {}", (Object)path, (Object)e);
        }
        finally {
            Files.close(zis);
        }
        return result;
    }

    protected boolean match(File path, ZipEntry entry, ScanFilter filter) {
        boolean isMatch = !entry.isDirectory();
        if (isMatch) {
            File sourceFile = new File(entry.getName());
            File parentPath = sourceFile.getParentFile();
            if (parentPath == null) {
                isMatch = path == null;
            } else if (parentPath.getAbsolutePath().startsWith(path.getAbsolutePath())) {
                if (!filter.isDeep(path, parentPath)) {
                    isMatch = parentPath.equals(path);
                }
            } else {
                return false;
            }
            return isMatch && filter.accept(sourceFile.getName());
        }
        return isMatch;
    }
}

