/*
 * Decompiled with CFR 0.152.
 */
package net.isger.util.sql;

import net.isger.util.sql.Pager;
import net.isger.util.sql.SqlEntry;

public class PageSql
extends SqlEntry {
    private Pager page;

    public PageSql(Pager page, String sql, Object ... values) {
        super(sql, values);
        this.page = page;
    }

    public Pager getPage() {
        return this.page;
    }

    @Override
    public final String getSql() {
        return this.getWrapSql(this.sql);
    }

    @Override
    public final String getSql(SqlEntry entry) {
        return this.getWrapSql(entry.sql);
    }

    @Override
    public final Object[] getValues() {
        return this.getWrapValues(this.values);
    }

    @Override
    public final Object[] getValues(SqlEntry entry) {
        return this.getWrapValues(entry.values);
    }

    public String getOriginSql() {
        return this.sql;
    }

    public Object[] getOriginValues() {
        return this.values;
    }

    public String getCountSql() {
        if (this.page.getTotal() > 0) {
            return null;
        }
        SqlEntry lastEntry = (SqlEntry)this.entries.get(this.entries.size() - 1);
        return "SELECT COUNT(1) FROM (" + lastEntry.getSql() + ") t";
    }

    public Object[] getCountValues() {
        SqlEntry lastEntry = (SqlEntry)this.entries.get(this.entries.size() - 1);
        return lastEntry.getValues();
    }

    public String getWrapSql(String sql) {
        return sql + " LIMIT ?, ?";
    }

    public Object[] getWrapValues(Object[] values) {
        int valCount = 2;
        Object[] wrapValues = null;
        if (values != null) {
            wrapValues = new Object[valCount += values.length];
            System.arraycopy(values, 0, wrapValues, 0, values.length);
        } else {
            wrapValues = new Object[valCount];
        }
        wrapValues[valCount - 1] = this.page.getLimit();
        wrapValues[valCount - 2] = (this.page.getStart() - 1) * this.page.getLimit();
        return wrapValues;
    }
}

