/*
 * Decompiled with CFR 0.152.
 */
package net.isger.util.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.isger.util.Helpers;
import net.isger.util.Strings;

public class SqlEntry
implements Iterable<SqlEntry> {
    protected String sql;
    protected Object[] values;
    protected List<SqlEntry> entries;

    public SqlEntry(String sql, Object ... values) {
        this.sql = sql;
        this.values = (Object[])Helpers.coalesce(values, new Object[1]);
        this.entries = this.parse(this.sql, this.values);
    }

    private SqlEntry(String sql, Object[] values, int index, int count) {
        this.sql = sql;
        int size = values.length;
        Object object = this.values = values instanceof Object[][] ? new Object[size][count] : new Object[count];
        if (values instanceof Object[][]) {
            for (int i = 0; i < size; ++i) {
                System.arraycopy(values[i], index, this.values[i], 0, count);
            }
        } else {
            System.arraycopy(values, index, this.values, 0, count);
        }
        this.entries = new ArrayList<SqlEntry>();
        this.entries.add(this);
    }

    @Override
    public Iterator<SqlEntry> iterator() {
        return this.entries.iterator();
    }

    public String getSql() {
        return this.sql;
    }

    public String getSql(SqlEntry entry) {
        return entry.sql;
    }

    public Object[] getValues() {
        return this.values;
    }

    public Object[] getValues(SqlEntry entry) {
        return entry.values;
    }

    public List<SqlEntry> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public void wrap(SqlEntry entry) {
        this.sql = entry.sql;
        this.values = entry.values;
        this.entries = this.parse(this.sql, this.values);
    }

    protected List<SqlEntry> parse(String sql, Object[] values) {
        ArrayList<SqlEntry> statements = new ArrayList<SqlEntry>();
        char[] chars = sql.trim().toCharArray();
        StringBuilder buffer = new StringBuilder();
        int index = 0;
        int count = 0;
        boolean insideQuotes = false;
        boolean insideEscapedQuotes = false;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (insideQuotes) {
                buffer.append(c);
                if (c == '\'' && !insideEscapedQuotes) {
                    insideQuotes = false;
                    continue;
                }
                if (c == '\'' && insideEscapedQuotes) {
                    insideEscapedQuotes = false;
                    continue;
                }
                if (c != '\\' || i + 1 >= chars.length || chars[i + 1] != '\'') continue;
                insideEscapedQuotes = true;
                continue;
            }
            buffer.append(c);
            if (c == ';') {
                String statement = buffer.toString().trim();
                if (statement.length() > 0) {
                    count = Strings.count(statement, "?");
                    statements.add(new SqlEntry(statement, values, index, count));
                    index += count;
                }
                buffer.setLength(0);
                continue;
            }
            if (c != '\'' || i + 1 >= chars.length || chars[i + 1] == '\'') continue;
            insideQuotes = true;
        }
        String statement = buffer.toString().trim();
        if (!statement.isEmpty()) {
            statements.add(new SqlEntry(statement, values, index, Strings.count(statement, "?")));
        }
        return statements;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.sql.length() * 2);
        buffer.append(this.sql);
        if (this.values != null && this.values.length > 0) {
            buffer.append("[").append(this.values[0]);
            for (int i = 1; i < this.values.length; ++i) {
                buffer.append(", ").append(this.values[1]);
            }
            buffer.append("]");
        }
        return buffer.toString();
    }
}

