/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca;

import net.jacobpeterson.alpaca.model.util.apitype.BrokerAPIEndpointType;
import net.jacobpeterson.alpaca.model.util.apitype.MarketDataWebsocketSourceType;
import net.jacobpeterson.alpaca.model.util.apitype.TraderAPIEndpointType;
import net.jacobpeterson.alpaca.rest.broker.AlpacaBrokerAPI;
import net.jacobpeterson.alpaca.rest.marketdata.AlpacaMarketDataAPI;
import net.jacobpeterson.alpaca.rest.trader.AlpacaTraderAPI;
import net.jacobpeterson.alpaca.websocket.marketdata.streams.crypto.CryptoMarketDataWebsocket;
import net.jacobpeterson.alpaca.websocket.marketdata.streams.crypto.CryptoMarketDataWebsocketInterface;
import net.jacobpeterson.alpaca.websocket.marketdata.streams.news.NewsMarketDataWebsocket;
import net.jacobpeterson.alpaca.websocket.marketdata.streams.news.NewsMarketDataWebsocketInterface;
import net.jacobpeterson.alpaca.websocket.marketdata.streams.stock.StockMarketDataWebsocket;
import net.jacobpeterson.alpaca.websocket.marketdata.streams.stock.StockMarketDataWebsocketInterface;
import net.jacobpeterson.alpaca.websocket.updates.UpdatesWebsocket;
import net.jacobpeterson.alpaca.websocket.updates.UpdatesWebsocketInterface;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlpacaAPI {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlpacaAPI.class);
    private final String traderKeyID;
    private final String traderSecretKey;
    private final String traderOAuthToken;
    private final TraderAPIEndpointType traderAPIEndpointType;
    private final MarketDataWebsocketSourceType marketDataWebsocketSourceType;
    private final String brokerAPIKey;
    private final String brokerAPISecret;
    private final BrokerAPIEndpointType brokerAPIEndpointType;
    private final OkHttpClient okHttpClient;
    private AlpacaTraderAPI trader;
    private AlpacaMarketDataAPI marketData;
    private AlpacaBrokerAPI broker;
    private UpdatesWebsocket updatesWebsocket;
    private StockMarketDataWebsocket stockMarketDataWebsocket;
    private CryptoMarketDataWebsocket cryptoMarketDataWebsocket;
    private NewsMarketDataWebsocket newsMarketDataWebsocket;

    public AlpacaAPI(String traderKeyID, String traderSecretKey, TraderAPIEndpointType traderAPIEndpointType, MarketDataWebsocketSourceType marketDataWebsocketSourceType) {
        this(traderKeyID, traderSecretKey, null, traderAPIEndpointType, marketDataWebsocketSourceType, null, null, null, null);
    }

    public AlpacaAPI(String traderKeyID, String traderSecretKey, TraderAPIEndpointType traderAPIEndpointType, MarketDataWebsocketSourceType marketDataWebsocketSourceType, OkHttpClient okHttpClient) {
        this(traderKeyID, traderSecretKey, null, traderAPIEndpointType, marketDataWebsocketSourceType, null, null, null, okHttpClient);
    }

    public AlpacaAPI(String traderOAuthToken, TraderAPIEndpointType traderAPIEndpointType) {
        this(null, null, traderOAuthToken, traderAPIEndpointType, null, null, null, null, null);
    }

    public AlpacaAPI(String traderOAuthToken, TraderAPIEndpointType traderAPIEndpointType, OkHttpClient okHttpClient) {
        this(null, null, traderOAuthToken, traderAPIEndpointType, null, null, null, null, okHttpClient);
    }

    public AlpacaAPI(String brokerAPIKey, String brokerAPISecret, BrokerAPIEndpointType brokerAPIEndpointType) {
        this(null, null, null, null, null, brokerAPIKey, brokerAPISecret, brokerAPIEndpointType, null);
    }

    public AlpacaAPI(String brokerAPIKey, String brokerAPISecret, BrokerAPIEndpointType brokerAPIEndpointType, OkHttpClient okHttpClient) {
        this(null, null, null, null, null, brokerAPIKey, brokerAPISecret, brokerAPIEndpointType, okHttpClient);
    }

    public AlpacaAPI(String traderKeyID, String traderSecretKey, String traderOAuthToken, TraderAPIEndpointType traderAPIEndpointType, MarketDataWebsocketSourceType marketDataWebsocketSourceType, String brokerAPIKey, String brokerAPISecret, BrokerAPIEndpointType brokerAPIEndpointType, OkHttpClient okHttpClient) {
        this.traderKeyID = traderKeyID;
        this.traderSecretKey = traderSecretKey;
        this.traderOAuthToken = traderOAuthToken;
        this.traderAPIEndpointType = traderAPIEndpointType != null ? traderAPIEndpointType : TraderAPIEndpointType.PAPER;
        this.marketDataWebsocketSourceType = marketDataWebsocketSourceType != null ? marketDataWebsocketSourceType : MarketDataWebsocketSourceType.IEX;
        this.brokerAPIKey = brokerAPIKey;
        this.brokerAPISecret = brokerAPISecret;
        BrokerAPIEndpointType brokerAPIEndpointType2 = this.brokerAPIEndpointType = brokerAPIEndpointType != null ? brokerAPIEndpointType : BrokerAPIEndpointType.SANDBOX;
        if (okHttpClient == null) {
            OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
            if (LOGGER.isDebugEnabled()) {
                HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor(arg_0 -> ((Logger)LOGGER).debug(arg_0));
                loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
                clientBuilder.addInterceptor((Interceptor)loggingInterceptor);
            }
            okHttpClient = clientBuilder.build();
        }
        this.okHttpClient = okHttpClient;
    }

    public void closeOkHttpClient() {
        this.okHttpClient.dispatcher().executorService().shutdown();
        this.okHttpClient.connectionPool().evictAll();
    }

    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }

    public synchronized AlpacaTraderAPI trader() {
        if (this.trader == null) {
            this.trader = new AlpacaTraderAPI(this.traderKeyID, this.traderSecretKey, this.traderOAuthToken, this.traderAPIEndpointType, this.okHttpClient);
        }
        return this.trader;
    }

    public synchronized AlpacaMarketDataAPI marketData() {
        if (this.marketData == null) {
            this.marketData = new AlpacaMarketDataAPI(this.traderKeyID, this.traderSecretKey, this.brokerAPIKey, this.brokerAPISecret, this.okHttpClient);
        }
        return this.marketData;
    }

    public synchronized AlpacaBrokerAPI broker() {
        if (this.broker == null) {
            this.broker = new AlpacaBrokerAPI(this.brokerAPIKey, this.brokerAPISecret, this.brokerAPIEndpointType, this.okHttpClient);
        }
        return this.broker;
    }

    public synchronized UpdatesWebsocketInterface updatesStream() {
        if (this.updatesWebsocket == null) {
            this.updatesWebsocket = new UpdatesWebsocket(this.okHttpClient, this.traderAPIEndpointType, this.traderKeyID, this.traderSecretKey, this.traderOAuthToken);
        }
        return this.updatesWebsocket;
    }

    public synchronized StockMarketDataWebsocketInterface stockMarketDataStream() {
        if (this.stockMarketDataWebsocket == null) {
            this.stockMarketDataWebsocket = new StockMarketDataWebsocket(this.okHttpClient, this.traderKeyID, this.traderSecretKey, this.brokerAPIKey, this.brokerAPISecret, this.marketDataWebsocketSourceType);
        }
        return this.stockMarketDataWebsocket;
    }

    public synchronized CryptoMarketDataWebsocketInterface cryptoMarketDataStream() {
        if (this.cryptoMarketDataWebsocket == null) {
            this.cryptoMarketDataWebsocket = new CryptoMarketDataWebsocket(this.okHttpClient, this.traderKeyID, this.traderSecretKey, this.brokerAPIKey, this.brokerAPISecret);
        }
        return this.cryptoMarketDataWebsocket;
    }

    public synchronized NewsMarketDataWebsocketInterface newsMarketDataStream() {
        if (this.newsMarketDataWebsocket == null) {
            this.newsMarketDataWebsocket = new NewsMarketDataWebsocket(this.okHttpClient, this.traderKeyID, this.traderSecretKey, this.brokerAPIKey, this.brokerAPISecret);
        }
        return this.newsMarketDataWebsocket;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String traderKeyID;
        private String traderSecretKey;
        private String traderOAuthToken;
        private TraderAPIEndpointType traderAPIEndpointType;
        private MarketDataWebsocketSourceType marketDataWebsocketSourceType;
        private String brokerAPIKey;
        private String brokerAPISecret;
        private BrokerAPIEndpointType brokerAPIEndpointType;
        private OkHttpClient okHttpClient;

        private Builder() {
        }

        public Builder withTraderKeyID(String traderKeyID) {
            this.traderKeyID = traderKeyID;
            return this;
        }

        public Builder withTraderSecretKey(String traderSecretKey) {
            this.traderSecretKey = traderSecretKey;
            return this;
        }

        public Builder withTraderOAuthToken(String traderOAuthToken) {
            this.traderOAuthToken = traderOAuthToken;
            return this;
        }

        public Builder withTraderAPIEndpointType(TraderAPIEndpointType traderAPIEndpointType) {
            this.traderAPIEndpointType = traderAPIEndpointType;
            return this;
        }

        public Builder withMarketDataWebsocketSourceType(MarketDataWebsocketSourceType marketDataWebsocketSourceType) {
            this.marketDataWebsocketSourceType = marketDataWebsocketSourceType;
            return this;
        }

        public Builder withBrokerAPIKey(String brokerAPIKey) {
            this.brokerAPIKey = brokerAPIKey;
            return this;
        }

        public Builder withBrokerAPISecret(String brokerAPISecret) {
            this.brokerAPISecret = brokerAPISecret;
            return this;
        }

        public Builder withBrokerAPIEndpointType(BrokerAPIEndpointType brokerAPIEndpointType) {
            this.brokerAPIEndpointType = brokerAPIEndpointType;
            return this;
        }

        public Builder withOkHttpClient(OkHttpClient okHttpClient) {
            this.okHttpClient = okHttpClient;
            return this;
        }

        public AlpacaAPI build() {
            return new AlpacaAPI(this.traderKeyID, this.traderSecretKey, this.traderOAuthToken, this.traderAPIEndpointType, this.marketDataWebsocketSourceType, this.brokerAPIKey, this.brokerAPISecret, this.brokerAPIEndpointType, this.okHttpClient);
        }
    }
}

