/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.model.websocket.marketdata.streams.crypto.model;

import java.util.HashMap;
import java.util.Map;

public enum CryptoMarketDataMessageType {
    SUCCESS("success"),
    ERROR("error"),
    SUBSCRIPTION("subscription"),
    TRADES("t"),
    QUOTES("q"),
    MINUTE_BARS("b"),
    DAILY_BARS("d"),
    UPDATED_BARS("u"),
    ORDER_BOOKS("o");

    private final String value;
    private static final Map<String, CryptoMarketDataMessageType> CONSTANTS;

    private CryptoMarketDataMessageType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public String value() {
        return this.value;
    }

    public static CryptoMarketDataMessageType fromValue(String value) {
        CryptoMarketDataMessageType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, CryptoMarketDataMessageType>();
        for (CryptoMarketDataMessageType c : CryptoMarketDataMessageType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

