/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.model.websocket.marketdata.streams.crypto.model.orderbook;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.LinkedHashSet;
import java.util.Set;
import net.jacobpeterson.alpaca.model.websocket.marketdata.streams.crypto.model.CryptoMarketDataMessage;
import net.jacobpeterson.alpaca.model.websocket.marketdata.streams.crypto.model.orderbook.CryptoOrderBookEntry;

public class CryptoOrderBookMessage
extends CryptoMarketDataMessage
implements Serializable {
    @SerializedName(value="S")
    @Expose
    private String symbol;
    @SerializedName(value="a")
    @Expose
    private Set<CryptoOrderBookEntry> asks = new LinkedHashSet<CryptoOrderBookEntry>();
    @SerializedName(value="b")
    @Expose
    private Set<CryptoOrderBookEntry> bids = new LinkedHashSet<CryptoOrderBookEntry>();
    @SerializedName(value="t")
    @Expose
    private OffsetDateTime timestamp;
    @SerializedName(value="r")
    @Expose
    private Boolean reset;
    private static final long serialVersionUID = -2889357455669346519L;

    public CryptoOrderBookMessage() {
    }

    public CryptoOrderBookMessage(CryptoOrderBookMessage source) {
        this.symbol = source.symbol;
        this.asks = source.asks;
        this.bids = source.bids;
        this.timestamp = source.timestamp;
        this.reset = source.reset;
    }

    public CryptoOrderBookMessage(String symbol, Set<CryptoOrderBookEntry> asks, Set<CryptoOrderBookEntry> bids, OffsetDateTime timestamp, Boolean reset) {
        this.symbol = symbol;
        this.asks = asks;
        this.bids = bids;
        this.timestamp = timestamp;
        this.reset = reset;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public CryptoOrderBookMessage withSymbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    public Set<CryptoOrderBookEntry> getAsks() {
        return this.asks;
    }

    public void setAsks(Set<CryptoOrderBookEntry> asks) {
        this.asks = asks;
    }

    public CryptoOrderBookMessage withAsks(Set<CryptoOrderBookEntry> asks) {
        this.asks = asks;
        return this;
    }

    public Set<CryptoOrderBookEntry> getBids() {
        return this.bids;
    }

    public void setBids(Set<CryptoOrderBookEntry> bids) {
        this.bids = bids;
    }

    public CryptoOrderBookMessage withBids(Set<CryptoOrderBookEntry> bids) {
        this.bids = bids;
        return this;
    }

    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public CryptoOrderBookMessage withTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public Boolean getReset() {
        return this.reset;
    }

    public void setReset(Boolean reset) {
        this.reset = reset;
    }

    public CryptoOrderBookMessage withReset(Boolean reset) {
        this.reset = reset;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CryptoOrderBookMessage.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        int baseLength = sb.length();
        String superString = super.toString();
        if (superString != null) {
            int contentStart = superString.indexOf(91);
            int contentEnd = superString.lastIndexOf(93);
            if (contentStart >= 0 && contentEnd > contentStart) {
                sb.append(superString, contentStart + 1, contentEnd);
            } else {
                sb.append(superString);
            }
        }
        if (sb.length() > baseLength) {
            sb.append(',');
        }
        sb.append("symbol");
        sb.append('=');
        sb.append(this.symbol == null ? "<null>" : this.symbol);
        sb.append(',');
        sb.append("asks");
        sb.append('=');
        sb.append(this.asks == null ? "<null>" : this.asks);
        sb.append(',');
        sb.append("bids");
        sb.append('=');
        sb.append(this.bids == null ? "<null>" : this.bids);
        sb.append(',');
        sb.append("timestamp");
        sb.append('=');
        sb.append(this.timestamp == null ? "<null>" : this.timestamp);
        sb.append(',');
        sb.append("reset");
        sb.append('=');
        sb.append(this.reset == null ? "<null>" : this.reset);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.bids == null ? 0 : this.bids.hashCode());
        result = result * 31 + (this.symbol == null ? 0 : this.symbol.hashCode());
        result = result * 31 + (this.reset == null ? 0 : this.reset.hashCode());
        result = result * 31 + (this.asks == null ? 0 : this.asks.hashCode());
        result = result * 31 + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        result = result * 31 + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CryptoOrderBookMessage)) {
            return false;
        }
        CryptoOrderBookMessage rhs = (CryptoOrderBookMessage)other;
        return super.equals(rhs) && (this.bids == rhs.bids || this.bids != null && this.bids.equals(rhs.bids)) && (this.symbol == rhs.symbol || this.symbol != null && this.symbol.equals(rhs.symbol)) && (this.reset == rhs.reset || this.reset != null && this.reset.equals(rhs.reset)) && (this.asks == rhs.asks || this.asks != null && this.asks.equals(rhs.asks)) && (this.timestamp == rhs.timestamp || this.timestamp != null && this.timestamp.equals(rhs.timestamp));
    }
}

