/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.model.websocket.marketdata.streams.crypto.model.trade;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.time.OffsetDateTime;
import net.jacobpeterson.alpaca.model.websocket.marketdata.streams.crypto.model.CryptoMarketDataMessage;
import net.jacobpeterson.alpaca.model.websocket.marketdata.streams.crypto.model.trade.CryptoTradeTakerSide;

public class CryptoTradeMessage
extends CryptoMarketDataMessage
implements Serializable {
    @SerializedName(value="S")
    @Expose
    private String symbol;
    @SerializedName(value="i")
    @Expose
    private Long tradeID;
    @SerializedName(value="p")
    @Expose
    private Double price;
    @SerializedName(value="s")
    @Expose
    private Double size;
    @SerializedName(value="t")
    @Expose
    private OffsetDateTime timestamp;
    @SerializedName(value="tks")
    @Expose
    private CryptoTradeTakerSide takerSide;
    private static final long serialVersionUID = -8557692800315511807L;

    public CryptoTradeMessage() {
    }

    public CryptoTradeMessage(CryptoTradeMessage source) {
        this.symbol = source.symbol;
        this.tradeID = source.tradeID;
        this.price = source.price;
        this.size = source.size;
        this.timestamp = source.timestamp;
        this.takerSide = source.takerSide;
    }

    public CryptoTradeMessage(String symbol, Long tradeID, Double price, Double size, OffsetDateTime timestamp, CryptoTradeTakerSide takerSide) {
        this.symbol = symbol;
        this.tradeID = tradeID;
        this.price = price;
        this.size = size;
        this.timestamp = timestamp;
        this.takerSide = takerSide;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public CryptoTradeMessage withSymbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    public Long getTradeID() {
        return this.tradeID;
    }

    public void setTradeID(Long tradeID) {
        this.tradeID = tradeID;
    }

    public CryptoTradeMessage withTradeID(Long tradeID) {
        this.tradeID = tradeID;
        return this;
    }

    public Double getPrice() {
        return this.price;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public CryptoTradeMessage withPrice(Double price) {
        this.price = price;
        return this;
    }

    public Double getSize() {
        return this.size;
    }

    public void setSize(Double size) {
        this.size = size;
    }

    public CryptoTradeMessage withSize(Double size) {
        this.size = size;
        return this;
    }

    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public CryptoTradeMessage withTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public CryptoTradeTakerSide getTakerSide() {
        return this.takerSide;
    }

    public void setTakerSide(CryptoTradeTakerSide takerSide) {
        this.takerSide = takerSide;
    }

    public CryptoTradeMessage withTakerSide(CryptoTradeTakerSide takerSide) {
        this.takerSide = takerSide;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CryptoTradeMessage.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        int baseLength = sb.length();
        String superString = super.toString();
        if (superString != null) {
            int contentStart = superString.indexOf(91);
            int contentEnd = superString.lastIndexOf(93);
            if (contentStart >= 0 && contentEnd > contentStart) {
                sb.append(superString, contentStart + 1, contentEnd);
            } else {
                sb.append(superString);
            }
        }
        if (sb.length() > baseLength) {
            sb.append(',');
        }
        sb.append("symbol");
        sb.append('=');
        sb.append(this.symbol == null ? "<null>" : this.symbol);
        sb.append(',');
        sb.append("tradeID");
        sb.append('=');
        sb.append(this.tradeID == null ? "<null>" : this.tradeID);
        sb.append(',');
        sb.append("price");
        sb.append('=');
        sb.append(this.price == null ? "<null>" : this.price);
        sb.append(',');
        sb.append("size");
        sb.append('=');
        sb.append(this.size == null ? "<null>" : this.size);
        sb.append(',');
        sb.append("timestamp");
        sb.append('=');
        sb.append(this.timestamp == null ? "<null>" : this.timestamp);
        sb.append(',');
        sb.append("takerSide");
        sb.append('=');
        sb.append(this.takerSide == null ? "<null>" : this.takerSide);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.symbol == null ? 0 : this.symbol.hashCode());
        result = result * 31 + (this.size == null ? 0 : this.size.hashCode());
        result = result * 31 + (this.takerSide == null ? 0 : this.takerSide.hashCode());
        result = result * 31 + (this.tradeID == null ? 0 : this.tradeID.hashCode());
        result = result * 31 + (this.price == null ? 0 : this.price.hashCode());
        result = result * 31 + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        result = result * 31 + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CryptoTradeMessage)) {
            return false;
        }
        CryptoTradeMessage rhs = (CryptoTradeMessage)other;
        return super.equals(rhs) && (this.symbol == rhs.symbol || this.symbol != null && this.symbol.equals(rhs.symbol)) && (this.size == rhs.size || this.size != null && this.size.equals(rhs.size)) && (this.takerSide == rhs.takerSide || this.takerSide != null && this.takerSide.equals((Object)rhs.takerSide)) && (this.tradeID == rhs.tradeID || this.tradeID != null && this.tradeID.equals(rhs.tradeID)) && (this.price == rhs.price || this.price != null && this.price.equals(rhs.price)) && (this.timestamp == rhs.timestamp || this.timestamp != null && this.timestamp.equals(rhs.timestamp));
    }
}

