/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.model.websocket.marketdata.streams.stock.model;

import java.util.HashMap;
import java.util.Map;

public enum StockMarketDataMessageType {
    SUCCESS("success"),
    ERROR("error"),
    SUBSCRIPTION("subscription"),
    TRADES("t"),
    QUOTES("q"),
    MINUTE_BARS("b"),
    DAILY_BARS("d"),
    UPDATED_BARS("u"),
    TRADE_CORRECTIONS("c"),
    TRADE_CANCEL_ERRORS("x"),
    LIMIT_UP_LIMIT_DOWN_BANDS("l"),
    TRADING_STATUSES("s");

    private final String value;
    private static final Map<String, StockMarketDataMessageType> CONSTANTS;

    private StockMarketDataMessageType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public String value() {
        return this.value;
    }

    public static StockMarketDataMessageType fromValue(String value) {
        StockMarketDataMessageType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, StockMarketDataMessageType>();
        for (StockMarketDataMessageType c : StockMarketDataMessageType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

