/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.model.websocket.marketdata.streams.stock.model.quote;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.LinkedHashSet;
import java.util.Set;
import net.jacobpeterson.alpaca.model.websocket.marketdata.streams.stock.model.StockMarketDataMessage;

public class StockQuoteMessage
extends StockMarketDataMessage
implements Serializable {
    @SerializedName(value="S")
    @Expose
    private String symbol;
    @SerializedName(value="ax")
    @Expose
    private String askExchange;
    @SerializedName(value="ap")
    @Expose
    private Double askPrice;
    @SerializedName(value="as")
    @Expose
    private Integer askSize;
    @SerializedName(value="bx")
    @Expose
    private String bidExchange;
    @SerializedName(value="bp")
    @Expose
    private Double bidPrice;
    @SerializedName(value="bs")
    @Expose
    private Integer bidSize;
    @SerializedName(value="c")
    @Expose
    private Set<String> conditions = new LinkedHashSet<String>();
    @SerializedName(value="t")
    @Expose
    private OffsetDateTime timestamp;
    @SerializedName(value="z")
    @Expose
    private String tape;
    private static final long serialVersionUID = 2246749005257786993L;

    public StockQuoteMessage() {
    }

    public StockQuoteMessage(StockQuoteMessage source) {
        this.symbol = source.symbol;
        this.askExchange = source.askExchange;
        this.askPrice = source.askPrice;
        this.askSize = source.askSize;
        this.bidExchange = source.bidExchange;
        this.bidPrice = source.bidPrice;
        this.bidSize = source.bidSize;
        this.conditions = source.conditions;
        this.timestamp = source.timestamp;
        this.tape = source.tape;
    }

    public StockQuoteMessage(String symbol, String askExchange, Double askPrice, Integer askSize, String bidExchange, Double bidPrice, Integer bidSize, Set<String> conditions, OffsetDateTime timestamp, String tape) {
        this.symbol = symbol;
        this.askExchange = askExchange;
        this.askPrice = askPrice;
        this.askSize = askSize;
        this.bidExchange = bidExchange;
        this.bidPrice = bidPrice;
        this.bidSize = bidSize;
        this.conditions = conditions;
        this.timestamp = timestamp;
        this.tape = tape;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public StockQuoteMessage withSymbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    public String getAskExchange() {
        return this.askExchange;
    }

    public void setAskExchange(String askExchange) {
        this.askExchange = askExchange;
    }

    public StockQuoteMessage withAskExchange(String askExchange) {
        this.askExchange = askExchange;
        return this;
    }

    public Double getAskPrice() {
        return this.askPrice;
    }

    public void setAskPrice(Double askPrice) {
        this.askPrice = askPrice;
    }

    public StockQuoteMessage withAskPrice(Double askPrice) {
        this.askPrice = askPrice;
        return this;
    }

    public Integer getAskSize() {
        return this.askSize;
    }

    public void setAskSize(Integer askSize) {
        this.askSize = askSize;
    }

    public StockQuoteMessage withAskSize(Integer askSize) {
        this.askSize = askSize;
        return this;
    }

    public String getBidExchange() {
        return this.bidExchange;
    }

    public void setBidExchange(String bidExchange) {
        this.bidExchange = bidExchange;
    }

    public StockQuoteMessage withBidExchange(String bidExchange) {
        this.bidExchange = bidExchange;
        return this;
    }

    public Double getBidPrice() {
        return this.bidPrice;
    }

    public void setBidPrice(Double bidPrice) {
        this.bidPrice = bidPrice;
    }

    public StockQuoteMessage withBidPrice(Double bidPrice) {
        this.bidPrice = bidPrice;
        return this;
    }

    public Integer getBidSize() {
        return this.bidSize;
    }

    public void setBidSize(Integer bidSize) {
        this.bidSize = bidSize;
    }

    public StockQuoteMessage withBidSize(Integer bidSize) {
        this.bidSize = bidSize;
        return this;
    }

    public Set<String> getConditions() {
        return this.conditions;
    }

    public void setConditions(Set<String> conditions) {
        this.conditions = conditions;
    }

    public StockQuoteMessage withConditions(Set<String> conditions) {
        this.conditions = conditions;
        return this;
    }

    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public StockQuoteMessage withTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public String getTape() {
        return this.tape;
    }

    public void setTape(String tape) {
        this.tape = tape;
    }

    public StockQuoteMessage withTape(String tape) {
        this.tape = tape;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(StockQuoteMessage.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        int baseLength = sb.length();
        String superString = super.toString();
        if (superString != null) {
            int contentStart = superString.indexOf(91);
            int contentEnd = superString.lastIndexOf(93);
            if (contentStart >= 0 && contentEnd > contentStart) {
                sb.append(superString, contentStart + 1, contentEnd);
            } else {
                sb.append(superString);
            }
        }
        if (sb.length() > baseLength) {
            sb.append(',');
        }
        sb.append("symbol");
        sb.append('=');
        sb.append(this.symbol == null ? "<null>" : this.symbol);
        sb.append(',');
        sb.append("askExchange");
        sb.append('=');
        sb.append(this.askExchange == null ? "<null>" : this.askExchange);
        sb.append(',');
        sb.append("askPrice");
        sb.append('=');
        sb.append(this.askPrice == null ? "<null>" : this.askPrice);
        sb.append(',');
        sb.append("askSize");
        sb.append('=');
        sb.append(this.askSize == null ? "<null>" : this.askSize);
        sb.append(',');
        sb.append("bidExchange");
        sb.append('=');
        sb.append(this.bidExchange == null ? "<null>" : this.bidExchange);
        sb.append(',');
        sb.append("bidPrice");
        sb.append('=');
        sb.append(this.bidPrice == null ? "<null>" : this.bidPrice);
        sb.append(',');
        sb.append("bidSize");
        sb.append('=');
        sb.append(this.bidSize == null ? "<null>" : this.bidSize);
        sb.append(',');
        sb.append("conditions");
        sb.append('=');
        sb.append(this.conditions == null ? "<null>" : this.conditions);
        sb.append(',');
        sb.append("timestamp");
        sb.append('=');
        sb.append(this.timestamp == null ? "<null>" : this.timestamp);
        sb.append(',');
        sb.append("tape");
        sb.append('=');
        sb.append(this.tape == null ? "<null>" : this.tape);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.symbol == null ? 0 : this.symbol.hashCode());
        result = result * 31 + (this.askPrice == null ? 0 : this.askPrice.hashCode());
        result = result * 31 + (this.tape == null ? 0 : this.tape.hashCode());
        result = result * 31 + (this.bidSize == null ? 0 : this.bidSize.hashCode());
        result = result * 31 + (this.bidExchange == null ? 0 : this.bidExchange.hashCode());
        result = result * 31 + (this.conditions == null ? 0 : this.conditions.hashCode());
        result = result * 31 + (this.askSize == null ? 0 : this.askSize.hashCode());
        result = result * 31 + (this.bidPrice == null ? 0 : this.bidPrice.hashCode());
        result = result * 31 + (this.askExchange == null ? 0 : this.askExchange.hashCode());
        result = result * 31 + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        result = result * 31 + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof StockQuoteMessage)) {
            return false;
        }
        StockQuoteMessage rhs = (StockQuoteMessage)other;
        return super.equals(rhs) && (this.symbol == rhs.symbol || this.symbol != null && this.symbol.equals(rhs.symbol)) && (this.askPrice == rhs.askPrice || this.askPrice != null && this.askPrice.equals(rhs.askPrice)) && (this.tape == rhs.tape || this.tape != null && this.tape.equals(rhs.tape)) && (this.bidSize == rhs.bidSize || this.bidSize != null && this.bidSize.equals(rhs.bidSize)) && (this.bidExchange == rhs.bidExchange || this.bidExchange != null && this.bidExchange.equals(rhs.bidExchange)) && (this.conditions == rhs.conditions || this.conditions != null && this.conditions.equals(rhs.conditions)) && (this.askSize == rhs.askSize || this.askSize != null && this.askSize.equals(rhs.askSize)) && (this.bidPrice == rhs.bidPrice || this.bidPrice != null && this.bidPrice.equals(rhs.bidPrice)) && (this.askExchange == rhs.askExchange || this.askExchange != null && this.askExchange.equals(rhs.askExchange)) && (this.timestamp == rhs.timestamp || this.timestamp != null && this.timestamp.equals(rhs.timestamp));
    }
}

