/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.model.websocket.marketdata.streams.stock.model.tradecorrection;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.LinkedHashSet;
import java.util.Set;
import net.jacobpeterson.alpaca.model.websocket.marketdata.streams.stock.model.StockMarketDataMessage;

public class StockTradeCorrectionMessage
extends StockMarketDataMessage
implements Serializable {
    @SerializedName(value="S")
    @Expose
    private String symbol;
    @SerializedName(value="x")
    @Expose
    private String exchange;
    @SerializedName(value="oi")
    @Expose
    private Integer originalTradeID;
    @SerializedName(value="op")
    @Expose
    private Double originalPrice;
    @SerializedName(value="os")
    @Expose
    private Integer originalSize;
    @SerializedName(value="oc")
    @Expose
    private Set<String> originalConditions = new LinkedHashSet<String>();
    @SerializedName(value="ci")
    @Expose
    private Integer correctedTradeID;
    @SerializedName(value="cp")
    @Expose
    private Double correctedPrice;
    @SerializedName(value="cs")
    @Expose
    private Integer correctedSize;
    @SerializedName(value="cc")
    @Expose
    private Set<String> correctedConditions = new LinkedHashSet<String>();
    @SerializedName(value="t")
    @Expose
    private OffsetDateTime timestamp;
    @SerializedName(value="z")
    @Expose
    private String tape;
    private static final long serialVersionUID = -7210073670979789876L;

    public StockTradeCorrectionMessage() {
    }

    public StockTradeCorrectionMessage(StockTradeCorrectionMessage source) {
        this.symbol = source.symbol;
        this.exchange = source.exchange;
        this.originalTradeID = source.originalTradeID;
        this.originalPrice = source.originalPrice;
        this.originalSize = source.originalSize;
        this.originalConditions = source.originalConditions;
        this.correctedTradeID = source.correctedTradeID;
        this.correctedPrice = source.correctedPrice;
        this.correctedSize = source.correctedSize;
        this.correctedConditions = source.correctedConditions;
        this.timestamp = source.timestamp;
        this.tape = source.tape;
    }

    public StockTradeCorrectionMessage(String symbol, String exchange, Integer originalTradeID, Double originalPrice, Integer originalSize, Set<String> originalConditions, Integer correctedTradeID, Double correctedPrice, Integer correctedSize, Set<String> correctedConditions, OffsetDateTime timestamp, String tape) {
        this.symbol = symbol;
        this.exchange = exchange;
        this.originalTradeID = originalTradeID;
        this.originalPrice = originalPrice;
        this.originalSize = originalSize;
        this.originalConditions = originalConditions;
        this.correctedTradeID = correctedTradeID;
        this.correctedPrice = correctedPrice;
        this.correctedSize = correctedSize;
        this.correctedConditions = correctedConditions;
        this.timestamp = timestamp;
        this.tape = tape;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public StockTradeCorrectionMessage withSymbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    public String getExchange() {
        return this.exchange;
    }

    public void setExchange(String exchange) {
        this.exchange = exchange;
    }

    public StockTradeCorrectionMessage withExchange(String exchange) {
        this.exchange = exchange;
        return this;
    }

    public Integer getOriginalTradeID() {
        return this.originalTradeID;
    }

    public void setOriginalTradeID(Integer originalTradeID) {
        this.originalTradeID = originalTradeID;
    }

    public StockTradeCorrectionMessage withOriginalTradeID(Integer originalTradeID) {
        this.originalTradeID = originalTradeID;
        return this;
    }

    public Double getOriginalPrice() {
        return this.originalPrice;
    }

    public void setOriginalPrice(Double originalPrice) {
        this.originalPrice = originalPrice;
    }

    public StockTradeCorrectionMessage withOriginalPrice(Double originalPrice) {
        this.originalPrice = originalPrice;
        return this;
    }

    public Integer getOriginalSize() {
        return this.originalSize;
    }

    public void setOriginalSize(Integer originalSize) {
        this.originalSize = originalSize;
    }

    public StockTradeCorrectionMessage withOriginalSize(Integer originalSize) {
        this.originalSize = originalSize;
        return this;
    }

    public Set<String> getOriginalConditions() {
        return this.originalConditions;
    }

    public void setOriginalConditions(Set<String> originalConditions) {
        this.originalConditions = originalConditions;
    }

    public StockTradeCorrectionMessage withOriginalConditions(Set<String> originalConditions) {
        this.originalConditions = originalConditions;
        return this;
    }

    public Integer getCorrectedTradeID() {
        return this.correctedTradeID;
    }

    public void setCorrectedTradeID(Integer correctedTradeID) {
        this.correctedTradeID = correctedTradeID;
    }

    public StockTradeCorrectionMessage withCorrectedTradeID(Integer correctedTradeID) {
        this.correctedTradeID = correctedTradeID;
        return this;
    }

    public Double getCorrectedPrice() {
        return this.correctedPrice;
    }

    public void setCorrectedPrice(Double correctedPrice) {
        this.correctedPrice = correctedPrice;
    }

    public StockTradeCorrectionMessage withCorrectedPrice(Double correctedPrice) {
        this.correctedPrice = correctedPrice;
        return this;
    }

    public Integer getCorrectedSize() {
        return this.correctedSize;
    }

    public void setCorrectedSize(Integer correctedSize) {
        this.correctedSize = correctedSize;
    }

    public StockTradeCorrectionMessage withCorrectedSize(Integer correctedSize) {
        this.correctedSize = correctedSize;
        return this;
    }

    public Set<String> getCorrectedConditions() {
        return this.correctedConditions;
    }

    public void setCorrectedConditions(Set<String> correctedConditions) {
        this.correctedConditions = correctedConditions;
    }

    public StockTradeCorrectionMessage withCorrectedConditions(Set<String> correctedConditions) {
        this.correctedConditions = correctedConditions;
        return this;
    }

    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public StockTradeCorrectionMessage withTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public String getTape() {
        return this.tape;
    }

    public void setTape(String tape) {
        this.tape = tape;
    }

    public StockTradeCorrectionMessage withTape(String tape) {
        this.tape = tape;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(StockTradeCorrectionMessage.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        int baseLength = sb.length();
        String superString = super.toString();
        if (superString != null) {
            int contentStart = superString.indexOf(91);
            int contentEnd = superString.lastIndexOf(93);
            if (contentStart >= 0 && contentEnd > contentStart) {
                sb.append(superString, contentStart + 1, contentEnd);
            } else {
                sb.append(superString);
            }
        }
        if (sb.length() > baseLength) {
            sb.append(',');
        }
        sb.append("symbol");
        sb.append('=');
        sb.append(this.symbol == null ? "<null>" : this.symbol);
        sb.append(',');
        sb.append("exchange");
        sb.append('=');
        sb.append(this.exchange == null ? "<null>" : this.exchange);
        sb.append(',');
        sb.append("originalTradeID");
        sb.append('=');
        sb.append(this.originalTradeID == null ? "<null>" : this.originalTradeID);
        sb.append(',');
        sb.append("originalPrice");
        sb.append('=');
        sb.append(this.originalPrice == null ? "<null>" : this.originalPrice);
        sb.append(',');
        sb.append("originalSize");
        sb.append('=');
        sb.append(this.originalSize == null ? "<null>" : this.originalSize);
        sb.append(',');
        sb.append("originalConditions");
        sb.append('=');
        sb.append(this.originalConditions == null ? "<null>" : this.originalConditions);
        sb.append(',');
        sb.append("correctedTradeID");
        sb.append('=');
        sb.append(this.correctedTradeID == null ? "<null>" : this.correctedTradeID);
        sb.append(',');
        sb.append("correctedPrice");
        sb.append('=');
        sb.append(this.correctedPrice == null ? "<null>" : this.correctedPrice);
        sb.append(',');
        sb.append("correctedSize");
        sb.append('=');
        sb.append(this.correctedSize == null ? "<null>" : this.correctedSize);
        sb.append(',');
        sb.append("correctedConditions");
        sb.append('=');
        sb.append(this.correctedConditions == null ? "<null>" : this.correctedConditions);
        sb.append(',');
        sb.append("timestamp");
        sb.append('=');
        sb.append(this.timestamp == null ? "<null>" : this.timestamp);
        sb.append(',');
        sb.append("tape");
        sb.append('=');
        sb.append(this.tape == null ? "<null>" : this.tape);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.correctedTradeID == null ? 0 : this.correctedTradeID.hashCode());
        result = result * 31 + (this.symbol == null ? 0 : this.symbol.hashCode());
        result = result * 31 + (this.originalPrice == null ? 0 : this.originalPrice.hashCode());
        result = result * 31 + (this.correctedConditions == null ? 0 : this.correctedConditions.hashCode());
        result = result * 31 + (this.tape == null ? 0 : this.tape.hashCode());
        result = result * 31 + (this.correctedPrice == null ? 0 : this.correctedPrice.hashCode());
        result = result * 31 + (this.exchange == null ? 0 : this.exchange.hashCode());
        result = result * 31 + (this.originalSize == null ? 0 : this.originalSize.hashCode());
        result = result * 31 + (this.correctedSize == null ? 0 : this.correctedSize.hashCode());
        result = result * 31 + (this.originalTradeID == null ? 0 : this.originalTradeID.hashCode());
        result = result * 31 + (this.originalConditions == null ? 0 : this.originalConditions.hashCode());
        result = result * 31 + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        result = result * 31 + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof StockTradeCorrectionMessage)) {
            return false;
        }
        StockTradeCorrectionMessage rhs = (StockTradeCorrectionMessage)other;
        return super.equals(rhs) && (this.correctedTradeID == rhs.correctedTradeID || this.correctedTradeID != null && this.correctedTradeID.equals(rhs.correctedTradeID)) && (this.symbol == rhs.symbol || this.symbol != null && this.symbol.equals(rhs.symbol)) && (this.originalPrice == rhs.originalPrice || this.originalPrice != null && this.originalPrice.equals(rhs.originalPrice)) && (this.correctedConditions == rhs.correctedConditions || this.correctedConditions != null && this.correctedConditions.equals(rhs.correctedConditions)) && (this.tape == rhs.tape || this.tape != null && this.tape.equals(rhs.tape)) && (this.correctedPrice == rhs.correctedPrice || this.correctedPrice != null && this.correctedPrice.equals(rhs.correctedPrice)) && (this.exchange == rhs.exchange || this.exchange != null && this.exchange.equals(rhs.exchange)) && (this.originalSize == rhs.originalSize || this.originalSize != null && this.originalSize.equals(rhs.originalSize)) && (this.correctedSize == rhs.correctedSize || this.correctedSize != null && this.correctedSize.equals(rhs.correctedSize)) && (this.originalTradeID == rhs.originalTradeID || this.originalTradeID != null && this.originalTradeID.equals(rhs.originalTradeID)) && (this.originalConditions == rhs.originalConditions || this.originalConditions != null && this.originalConditions.equals(rhs.originalConditions)) && (this.timestamp == rhs.timestamp || this.timestamp != null && this.timestamp.equals(rhs.timestamp));
    }
}

