/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.model.websocket.updates.model.tradeupdate;

import java.util.HashMap;
import java.util.Map;

public enum TradeUpdateEvent {
    NEW("new"),
    FILL("fill"),
    PARTIAL_FILL("partial_fill"),
    CANCELED("canceled"),
    EXPIRED("expired"),
    DONE_FOR_DAY("done_for_day"),
    REPLACED("replaced"),
    REJECTED("rejected"),
    PENDING_NEW("pending_new"),
    STOPPED("stopped"),
    PENDING_CANCEL("pending_cancel"),
    PENDING_REPLACE("pending_replace"),
    CALCULATED("calculated"),
    SUSPENDED("suspended"),
    ORDER_REPLACE_REJECTED("order_replace_rejected"),
    ORDER_CANCEL_REJECTED("order_cancel_rejected");

    private final String value;
    private static final Map<String, TradeUpdateEvent> CONSTANTS;

    private TradeUpdateEvent(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public String value() {
        return this.value;
    }

    public static TradeUpdateEvent fromValue(String value) {
        TradeUpdateEvent constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, TradeUpdateEvent>();
        for (TradeUpdateEvent c : TradeUpdateEvent.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

