/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.jacobpeterson.alpaca.openapi.broker.ApiCallback;
import net.jacobpeterson.alpaca.openapi.broker.ApiClient;
import net.jacobpeterson.alpaca.openapi.broker.ApiException;
import net.jacobpeterson.alpaca.openapi.broker.ApiResponse;
import net.jacobpeterson.alpaca.openapi.broker.Configuration;
import net.jacobpeterson.alpaca.openapi.broker.Pair;
import net.jacobpeterson.alpaca.openapi.broker.model.Account;
import net.jacobpeterson.alpaca.openapi.broker.model.AccountCreationRequest;
import net.jacobpeterson.alpaca.openapi.broker.model.AccountExtended;
import net.jacobpeterson.alpaca.openapi.broker.model.AccountUpdateRequest;
import net.jacobpeterson.alpaca.openapi.broker.model.Activity;
import net.jacobpeterson.alpaca.openapi.broker.model.Bank;
import net.jacobpeterson.alpaca.openapi.broker.model.CreateBankRequest;
import net.jacobpeterson.alpaca.openapi.broker.model.CreateTransferRequest;
import net.jacobpeterson.alpaca.openapi.broker.model.OptionsApprovalRequest;
import net.jacobpeterson.alpaca.openapi.broker.model.OptionsApprovalResponse;
import net.jacobpeterson.alpaca.openapi.broker.model.PDTRemoval;
import net.jacobpeterson.alpaca.openapi.broker.model.PDTStatus;
import net.jacobpeterson.alpaca.openapi.broker.model.TradeAccount;
import net.jacobpeterson.alpaca.openapi.broker.model.Transfer;
import okhttp3.Call;

public class AccountsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AccountsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AccountsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    protected Call createAccountCall(AccountCreationRequest accountCreationRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AccountCreationRequest localVarPostBody = accountCreationRequest;
        String localVarPath = "/v1/accounts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createAccountValidateBeforeCall(AccountCreationRequest accountCreationRequest, ApiCallback _callback) throws ApiException {
        if (accountCreationRequest == null) {
            throw new ApiException("Missing the required parameter 'accountCreationRequest' when calling createAccount(Async)");
        }
        return this.createAccountCall(accountCreationRequest, _callback);
    }

    public Account createAccount(AccountCreationRequest accountCreationRequest) throws ApiException {
        ApiResponse<Account> localVarResp = this.createAccountWithHttpInfo(accountCreationRequest);
        return localVarResp.getData();
    }

    protected ApiResponse<Account> createAccountWithHttpInfo(AccountCreationRequest accountCreationRequest) throws ApiException {
        Call localVarCall = this.createAccountValidateBeforeCall(accountCreationRequest, null);
        Type localVarReturnType = new TypeToken<Account>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call createAccountAsync(AccountCreationRequest accountCreationRequest, ApiCallback<Account> _callback) throws ApiException {
        Call localVarCall = this.createAccountValidateBeforeCall(accountCreationRequest, _callback);
        Type localVarReturnType = new TypeToken<Account>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call createRecipientBankCall(UUID accountId, CreateBankRequest createBankRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateBankRequest localVarPostBody = createBankRequest;
        String localVarPath = "/v1/accounts/{account_id}/recipient_banks".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createRecipientBankValidateBeforeCall(UUID accountId, CreateBankRequest createBankRequest, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling createRecipientBank(Async)");
        }
        if (createBankRequest == null) {
            throw new ApiException("Missing the required parameter 'createBankRequest' when calling createRecipientBank(Async)");
        }
        return this.createRecipientBankCall(accountId, createBankRequest, _callback);
    }

    public Bank createRecipientBank(UUID accountId, CreateBankRequest createBankRequest) throws ApiException {
        ApiResponse<Bank> localVarResp = this.createRecipientBankWithHttpInfo(accountId, createBankRequest);
        return localVarResp.getData();
    }

    protected ApiResponse<Bank> createRecipientBankWithHttpInfo(UUID accountId, CreateBankRequest createBankRequest) throws ApiException {
        Call localVarCall = this.createRecipientBankValidateBeforeCall(accountId, createBankRequest, null);
        Type localVarReturnType = new TypeToken<Bank>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call createRecipientBankAsync(UUID accountId, CreateBankRequest createBankRequest, ApiCallback<Bank> _callback) throws ApiException {
        Call localVarCall = this.createRecipientBankValidateBeforeCall(accountId, createBankRequest, _callback);
        Type localVarReturnType = new TypeToken<Bank>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call createTransferForAccountCall(UUID accountId, CreateTransferRequest createTransferRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateTransferRequest localVarPostBody = createTransferRequest;
        String localVarPath = "/v1/accounts/{account_id}/transfers".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createTransferForAccountValidateBeforeCall(UUID accountId, CreateTransferRequest createTransferRequest, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling createTransferForAccount(Async)");
        }
        if (createTransferRequest == null) {
            throw new ApiException("Missing the required parameter 'createTransferRequest' when calling createTransferForAccount(Async)");
        }
        return this.createTransferForAccountCall(accountId, createTransferRequest, _callback);
    }

    public Transfer createTransferForAccount(UUID accountId, CreateTransferRequest createTransferRequest) throws ApiException {
        ApiResponse<Transfer> localVarResp = this.createTransferForAccountWithHttpInfo(accountId, createTransferRequest);
        return localVarResp.getData();
    }

    protected ApiResponse<Transfer> createTransferForAccountWithHttpInfo(UUID accountId, CreateTransferRequest createTransferRequest) throws ApiException {
        Call localVarCall = this.createTransferForAccountValidateBeforeCall(accountId, createTransferRequest, null);
        Type localVarReturnType = new TypeToken<Transfer>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call createTransferForAccountAsync(UUID accountId, CreateTransferRequest createTransferRequest, ApiCallback<Transfer> _callback) throws ApiException {
        Call localVarCall = this.createTransferForAccountValidateBeforeCall(accountId, createTransferRequest, _callback);
        Type localVarReturnType = new TypeToken<Transfer>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call getAccountCall(UUID accountId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/accounts/{account_id}".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAccountValidateBeforeCall(UUID accountId, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getAccount(Async)");
        }
        return this.getAccountCall(accountId, _callback);
    }

    public AccountExtended getAccount(UUID accountId) throws ApiException {
        ApiResponse<AccountExtended> localVarResp = this.getAccountWithHttpInfo(accountId);
        return localVarResp.getData();
    }

    protected ApiResponse<AccountExtended> getAccountWithHttpInfo(UUID accountId) throws ApiException {
        Call localVarCall = this.getAccountValidateBeforeCall(accountId, null);
        Type localVarReturnType = new TypeToken<AccountExtended>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getAccountAsync(UUID accountId, ApiCallback<AccountExtended> _callback) throws ApiException {
        Call localVarCall = this.getAccountValidateBeforeCall(accountId, _callback);
        Type localVarReturnType = new TypeToken<AccountExtended>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call getAccountActivitiesCall(UUID accountId, String date, String until, String after, String direction, Integer pageSize, String pageToken, String category, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/accounts/activities";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("account_id", accountId));
        }
        if (date != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("date", date));
        }
        if (until != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("until", until));
        }
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (direction != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("direction", direction));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (pageToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_token", pageToken));
        }
        if (category != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("category", category));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAccountActivitiesValidateBeforeCall(UUID accountId, String date, String until, String after, String direction, Integer pageSize, String pageToken, String category, ApiCallback _callback) throws ApiException {
        return this.getAccountActivitiesCall(accountId, date, until, after, direction, pageSize, pageToken, category, _callback);
    }

    public List<Activity> getAccountActivities(UUID accountId, String date, String until, String after, String direction, Integer pageSize, String pageToken, String category) throws ApiException {
        ApiResponse<List<Activity>> localVarResp = this.getAccountActivitiesWithHttpInfo(accountId, date, until, after, direction, pageSize, pageToken, category);
        return localVarResp.getData();
    }

    protected ApiResponse<List<Activity>> getAccountActivitiesWithHttpInfo(UUID accountId, String date, String until, String after, String direction, Integer pageSize, String pageToken, String category) throws ApiException {
        Call localVarCall = this.getAccountActivitiesValidateBeforeCall(accountId, date, until, after, direction, pageSize, pageToken, category, null);
        Type localVarReturnType = new TypeToken<List<Activity>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getAccountActivitiesAsync(UUID accountId, String date, String until, String after, String direction, Integer pageSize, String pageToken, String category, ApiCallback<List<Activity>> _callback) throws ApiException {
        Call localVarCall = this.getAccountActivitiesValidateBeforeCall(accountId, date, until, after, direction, pageSize, pageToken, category, _callback);
        Type localVarReturnType = new TypeToken<List<Activity>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call getAccountActivitiesByTypeCall(String activityType, UUID accountId, OffsetDateTime date, OffsetDateTime until, OffsetDateTime after, String direction, Integer pageSize, String pageToken, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/accounts/activities/{activity_type}".replace("{activity_type}", this.localVarApiClient.escapeString(activityType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("account_id", accountId));
        }
        if (date != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("date", date));
        }
        if (until != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("until", until));
        }
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (direction != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("direction", direction));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (pageToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_token", pageToken));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAccountActivitiesByTypeValidateBeforeCall(String activityType, UUID accountId, OffsetDateTime date, OffsetDateTime until, OffsetDateTime after, String direction, Integer pageSize, String pageToken, ApiCallback _callback) throws ApiException {
        if (activityType == null) {
            throw new ApiException("Missing the required parameter 'activityType' when calling getAccountActivitiesByType(Async)");
        }
        return this.getAccountActivitiesByTypeCall(activityType, accountId, date, until, after, direction, pageSize, pageToken, _callback);
    }

    public List<Activity> getAccountActivitiesByType(String activityType, UUID accountId, OffsetDateTime date, OffsetDateTime until, OffsetDateTime after, String direction, Integer pageSize, String pageToken) throws ApiException {
        ApiResponse<List<Activity>> localVarResp = this.getAccountActivitiesByTypeWithHttpInfo(activityType, accountId, date, until, after, direction, pageSize, pageToken);
        return localVarResp.getData();
    }

    protected ApiResponse<List<Activity>> getAccountActivitiesByTypeWithHttpInfo(String activityType, UUID accountId, OffsetDateTime date, OffsetDateTime until, OffsetDateTime after, String direction, Integer pageSize, String pageToken) throws ApiException {
        Call localVarCall = this.getAccountActivitiesByTypeValidateBeforeCall(activityType, accountId, date, until, after, direction, pageSize, pageToken, null);
        Type localVarReturnType = new TypeToken<List<Activity>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getAccountActivitiesByTypeAsync(String activityType, UUID accountId, OffsetDateTime date, OffsetDateTime until, OffsetDateTime after, String direction, Integer pageSize, String pageToken, ApiCallback<List<Activity>> _callback) throws ApiException {
        Call localVarCall = this.getAccountActivitiesByTypeValidateBeforeCall(activityType, accountId, date, until, after, direction, pageSize, pageToken, _callback);
        Type localVarReturnType = new TypeToken<List<Activity>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call getAllAccountsCall(String query, OffsetDateTime createdAfter, OffsetDateTime createdBefore, String status, String sort, String entities, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/accounts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (query != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query", query));
        }
        if (createdAfter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("created_after", createdAfter));
        }
        if (createdBefore != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("created_before", createdBefore));
        }
        if (status != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("status", status));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (entities != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("entities", entities));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAllAccountsValidateBeforeCall(String query, OffsetDateTime createdAfter, OffsetDateTime createdBefore, String status, String sort, String entities, ApiCallback _callback) throws ApiException {
        return this.getAllAccountsCall(query, createdAfter, createdBefore, status, sort, entities, _callback);
    }

    public List<Account> getAllAccounts(String query, OffsetDateTime createdAfter, OffsetDateTime createdBefore, String status, String sort, String entities) throws ApiException {
        ApiResponse<List<Account>> localVarResp = this.getAllAccountsWithHttpInfo(query, createdAfter, createdBefore, status, sort, entities);
        return localVarResp.getData();
    }

    protected ApiResponse<List<Account>> getAllAccountsWithHttpInfo(String query, OffsetDateTime createdAfter, OffsetDateTime createdBefore, String status, String sort, String entities) throws ApiException {
        Call localVarCall = this.getAllAccountsValidateBeforeCall(query, createdAfter, createdBefore, status, sort, entities, null);
        Type localVarReturnType = new TypeToken<List<Account>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getAllAccountsAsync(String query, OffsetDateTime createdAfter, OffsetDateTime createdBefore, String status, String sort, String entities, ApiCallback<List<Account>> _callback) throws ApiException {
        Call localVarCall = this.getAllAccountsValidateBeforeCall(query, createdAfter, createdBefore, status, sort, entities, _callback);
        Type localVarReturnType = new TypeToken<List<Account>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call getRecipientBanksCall(UUID accountId, String status, String bankName, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/accounts/{account_id}/recipient_banks".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (status != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("status", status));
        }
        if (bankName != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("bank_name", bankName));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getRecipientBanksValidateBeforeCall(UUID accountId, String status, String bankName, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getRecipientBanks(Async)");
        }
        return this.getRecipientBanksCall(accountId, status, bankName, _callback);
    }

    public List<Bank> getRecipientBanks(UUID accountId, String status, String bankName) throws ApiException {
        ApiResponse<List<Bank>> localVarResp = this.getRecipientBanksWithHttpInfo(accountId, status, bankName);
        return localVarResp.getData();
    }

    protected ApiResponse<List<Bank>> getRecipientBanksWithHttpInfo(UUID accountId, String status, String bankName) throws ApiException {
        Call localVarCall = this.getRecipientBanksValidateBeforeCall(accountId, status, bankName, null);
        Type localVarReturnType = new TypeToken<List<Bank>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getRecipientBanksAsync(UUID accountId, String status, String bankName, ApiCallback<List<Bank>> _callback) throws ApiException {
        Call localVarCall = this.getRecipientBanksValidateBeforeCall(accountId, status, bankName, _callback);
        Type localVarReturnType = new TypeToken<List<Bank>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call getTradingAccountCall(UUID accountId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/trading/accounts/{account_id}/account".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTradingAccountValidateBeforeCall(UUID accountId, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getTradingAccount(Async)");
        }
        return this.getTradingAccountCall(accountId, _callback);
    }

    public TradeAccount getTradingAccount(UUID accountId) throws ApiException {
        ApiResponse<TradeAccount> localVarResp = this.getTradingAccountWithHttpInfo(accountId);
        return localVarResp.getData();
    }

    protected ApiResponse<TradeAccount> getTradingAccountWithHttpInfo(UUID accountId) throws ApiException {
        Call localVarCall = this.getTradingAccountValidateBeforeCall(accountId, null);
        Type localVarReturnType = new TypeToken<TradeAccount>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getTradingAccountAsync(UUID accountId, ApiCallback<TradeAccount> _callback) throws ApiException {
        Call localVarCall = this.getTradingAccountValidateBeforeCall(accountId, _callback);
        Type localVarReturnType = new TypeToken<TradeAccount>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call patchAccountCall(UUID accountId, AccountUpdateRequest accountUpdateRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AccountUpdateRequest localVarPostBody = accountUpdateRequest;
        String localVarPath = "/v1/accounts/{account_id}".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchAccountValidateBeforeCall(UUID accountId, AccountUpdateRequest accountUpdateRequest, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling patchAccount(Async)");
        }
        if (accountUpdateRequest == null) {
            throw new ApiException("Missing the required parameter 'accountUpdateRequest' when calling patchAccount(Async)");
        }
        return this.patchAccountCall(accountId, accountUpdateRequest, _callback);
    }

    public AccountExtended patchAccount(UUID accountId, AccountUpdateRequest accountUpdateRequest) throws ApiException {
        ApiResponse<AccountExtended> localVarResp = this.patchAccountWithHttpInfo(accountId, accountUpdateRequest);
        return localVarResp.getData();
    }

    protected ApiResponse<AccountExtended> patchAccountWithHttpInfo(UUID accountId, AccountUpdateRequest accountUpdateRequest) throws ApiException {
        Call localVarCall = this.patchAccountValidateBeforeCall(accountId, accountUpdateRequest, null);
        Type localVarReturnType = new TypeToken<AccountExtended>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call patchAccountAsync(UUID accountId, AccountUpdateRequest accountUpdateRequest, ApiCallback<AccountExtended> _callback) throws ApiException {
        Call localVarCall = this.patchAccountValidateBeforeCall(accountId, accountUpdateRequest, _callback);
        Type localVarReturnType = new TypeToken<AccountExtended>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call pdtGetStatusCall(UUID accountId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/trading/accounts/{account_id}/account/pdt/status".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call pdtGetStatusValidateBeforeCall(UUID accountId, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling pdtGetStatus(Async)");
        }
        return this.pdtGetStatusCall(accountId, _callback);
    }

    public PDTStatus pdtGetStatus(UUID accountId) throws ApiException {
        ApiResponse<PDTStatus> localVarResp = this.pdtGetStatusWithHttpInfo(accountId);
        return localVarResp.getData();
    }

    protected ApiResponse<PDTStatus> pdtGetStatusWithHttpInfo(UUID accountId) throws ApiException {
        Call localVarCall = this.pdtGetStatusValidateBeforeCall(accountId, null);
        Type localVarReturnType = new TypeToken<PDTStatus>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call pdtGetStatusAsync(UUID accountId, ApiCallback<PDTStatus> _callback) throws ApiException {
        Call localVarCall = this.pdtGetStatusValidateBeforeCall(accountId, _callback);
        Type localVarReturnType = new TypeToken<PDTStatus>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call pdtOneTimeRemovalCall(UUID accountId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/trading/accounts/{account_id}/account/pdt/one-time-removal".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call pdtOneTimeRemovalValidateBeforeCall(UUID accountId, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling pdtOneTimeRemoval(Async)");
        }
        return this.pdtOneTimeRemovalCall(accountId, _callback);
    }

    public PDTRemoval pdtOneTimeRemoval(UUID accountId) throws ApiException {
        ApiResponse<PDTRemoval> localVarResp = this.pdtOneTimeRemovalWithHttpInfo(accountId);
        return localVarResp.getData();
    }

    protected ApiResponse<PDTRemoval> pdtOneTimeRemovalWithHttpInfo(UUID accountId) throws ApiException {
        Call localVarCall = this.pdtOneTimeRemovalValidateBeforeCall(accountId, null);
        Type localVarReturnType = new TypeToken<PDTRemoval>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call pdtOneTimeRemovalAsync(UUID accountId, ApiCallback<PDTRemoval> _callback) throws ApiException {
        Call localVarCall = this.pdtOneTimeRemovalValidateBeforeCall(accountId, _callback);
        Type localVarReturnType = new TypeToken<PDTRemoval>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call postPOSTV1AccountsAccountIdActionsReopenCall(UUID accountId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/accounts/{account_id}/actions/reopen".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postPOSTV1AccountsAccountIdActionsReopenValidateBeforeCall(UUID accountId, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling postPOSTV1AccountsAccountIdActionsReopen(Async)");
        }
        return this.postPOSTV1AccountsAccountIdActionsReopenCall(accountId, _callback);
    }

    public void postPOSTV1AccountsAccountIdActionsReopen(UUID accountId) throws ApiException {
        this.postPOSTV1AccountsAccountIdActionsReopenWithHttpInfo(accountId);
    }

    protected ApiResponse<Void> postPOSTV1AccountsAccountIdActionsReopenWithHttpInfo(UUID accountId) throws ApiException {
        Call localVarCall = this.postPOSTV1AccountsAccountIdActionsReopenValidateBeforeCall(accountId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    protected Call postPOSTV1AccountsAccountIdActionsReopenAsync(UUID accountId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.postPOSTV1AccountsAccountIdActionsReopenValidateBeforeCall(accountId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    protected Call postV1AccountsAccountIdActionsCloseCall(String accountId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/accounts/{account_id}/actions/close".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postV1AccountsAccountIdActionsCloseValidateBeforeCall(String accountId, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling postV1AccountsAccountIdActionsClose(Async)");
        }
        return this.postV1AccountsAccountIdActionsCloseCall(accountId, _callback);
    }

    public void postV1AccountsAccountIdActionsClose(String accountId) throws ApiException {
        this.postV1AccountsAccountIdActionsCloseWithHttpInfo(accountId);
    }

    protected ApiResponse<Void> postV1AccountsAccountIdActionsCloseWithHttpInfo(String accountId) throws ApiException {
        Call localVarCall = this.postV1AccountsAccountIdActionsCloseValidateBeforeCall(accountId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    protected Call postV1AccountsAccountIdActionsCloseAsync(String accountId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.postV1AccountsAccountIdActionsCloseValidateBeforeCall(accountId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    protected Call requestOptionsForAccountCall(UUID accountId, OptionsApprovalRequest optionsApprovalRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        OptionsApprovalRequest localVarPostBody = optionsApprovalRequest;
        String localVarPath = "/v1/accounts/{account_id}/options/approval".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call requestOptionsForAccountValidateBeforeCall(UUID accountId, OptionsApprovalRequest optionsApprovalRequest, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling requestOptionsForAccount(Async)");
        }
        if (optionsApprovalRequest == null) {
            throw new ApiException("Missing the required parameter 'optionsApprovalRequest' when calling requestOptionsForAccount(Async)");
        }
        return this.requestOptionsForAccountCall(accountId, optionsApprovalRequest, _callback);
    }

    public OptionsApprovalResponse requestOptionsForAccount(UUID accountId, OptionsApprovalRequest optionsApprovalRequest) throws ApiException {
        ApiResponse<OptionsApprovalResponse> localVarResp = this.requestOptionsForAccountWithHttpInfo(accountId, optionsApprovalRequest);
        return localVarResp.getData();
    }

    protected ApiResponse<OptionsApprovalResponse> requestOptionsForAccountWithHttpInfo(UUID accountId, OptionsApprovalRequest optionsApprovalRequest) throws ApiException {
        Call localVarCall = this.requestOptionsForAccountValidateBeforeCall(accountId, optionsApprovalRequest, null);
        Type localVarReturnType = new TypeToken<OptionsApprovalResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call requestOptionsForAccountAsync(UUID accountId, OptionsApprovalRequest optionsApprovalRequest, ApiCallback<OptionsApprovalResponse> _callback) throws ApiException {
        Call localVarCall = this.requestOptionsForAccountValidateBeforeCall(accountId, optionsApprovalRequest, _callback);
        Type localVarReturnType = new TypeToken<OptionsApprovalResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

