/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.jacobpeterson.alpaca.openapi.broker.ApiCallback;
import net.jacobpeterson.alpaca.openapi.broker.ApiClient;
import net.jacobpeterson.alpaca.openapi.broker.ApiException;
import net.jacobpeterson.alpaca.openapi.broker.ApiResponse;
import net.jacobpeterson.alpaca.openapi.broker.Configuration;
import net.jacobpeterson.alpaca.openapi.broker.Pair;
import net.jacobpeterson.alpaca.openapi.broker.model.Announcement;
import okhttp3.Call;

public class CorporateActionsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public CorporateActionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CorporateActionsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    protected Call getCorporateAnnouncementsCall(String caTypes, LocalDate since, LocalDate until, String symbol, String cusip, String dateType, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/corporate_actions/announcements";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (caTypes != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ca_types", caTypes));
        }
        if (since != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("since", since));
        }
        if (until != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("until", until));
        }
        if (symbol != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbol", symbol));
        }
        if (cusip != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cusip", cusip));
        }
        if (dateType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("date_type", dateType));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCorporateAnnouncementsValidateBeforeCall(String caTypes, LocalDate since, LocalDate until, String symbol, String cusip, String dateType, ApiCallback _callback) throws ApiException {
        if (caTypes == null) {
            throw new ApiException("Missing the required parameter 'caTypes' when calling getCorporateAnnouncements(Async)");
        }
        if (since == null) {
            throw new ApiException("Missing the required parameter 'since' when calling getCorporateAnnouncements(Async)");
        }
        if (until == null) {
            throw new ApiException("Missing the required parameter 'until' when calling getCorporateAnnouncements(Async)");
        }
        return this.getCorporateAnnouncementsCall(caTypes, since, until, symbol, cusip, dateType, _callback);
    }

    public List<Announcement> getCorporateAnnouncements(String caTypes, LocalDate since, LocalDate until, String symbol, String cusip, String dateType) throws ApiException {
        ApiResponse<List<Announcement>> localVarResp = this.getCorporateAnnouncementsWithHttpInfo(caTypes, since, until, symbol, cusip, dateType);
        return localVarResp.getData();
    }

    protected ApiResponse<List<Announcement>> getCorporateAnnouncementsWithHttpInfo(String caTypes, LocalDate since, LocalDate until, String symbol, String cusip, String dateType) throws ApiException {
        Call localVarCall = this.getCorporateAnnouncementsValidateBeforeCall(caTypes, since, until, symbol, cusip, dateType, null);
        Type localVarReturnType = new TypeToken<List<Announcement>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getCorporateAnnouncementsAsync(String caTypes, LocalDate since, LocalDate until, String symbol, String cusip, String dateType, ApiCallback<List<Announcement>> _callback) throws ApiException {
        Call localVarCall = this.getCorporateAnnouncementsValidateBeforeCall(caTypes, since, until, symbol, cusip, dateType, _callback);
        Type localVarReturnType = new TypeToken<List<Announcement>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call getGETV1CorporateActionsAnnouncementsIdCall(String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/corporate_actions/announcements/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getGETV1CorporateActionsAnnouncementsIdValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getGETV1CorporateActionsAnnouncementsId(Async)");
        }
        return this.getGETV1CorporateActionsAnnouncementsIdCall(id, _callback);
    }

    public void getGETV1CorporateActionsAnnouncementsId(String id) throws ApiException {
        this.getGETV1CorporateActionsAnnouncementsIdWithHttpInfo(id);
    }

    protected ApiResponse<Void> getGETV1CorporateActionsAnnouncementsIdWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.getGETV1CorporateActionsAnnouncementsIdValidateBeforeCall(id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    protected Call getGETV1CorporateActionsAnnouncementsIdAsync(String id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.getGETV1CorporateActionsAnnouncementsIdValidateBeforeCall(id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

