/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.jacobpeterson.alpaca.openapi.broker.ApiCallback;
import net.jacobpeterson.alpaca.openapi.broker.ApiClient;
import net.jacobpeterson.alpaca.openapi.broker.ApiException;
import net.jacobpeterson.alpaca.openapi.broker.ApiResponse;
import net.jacobpeterson.alpaca.openapi.broker.Configuration;
import net.jacobpeterson.alpaca.openapi.broker.Pair;
import net.jacobpeterson.alpaca.openapi.broker.model.CreateCryptoTransferRequest;
import net.jacobpeterson.alpaca.openapi.broker.model.CreateWhitelistedAddressRequest;
import net.jacobpeterson.alpaca.openapi.broker.model.CryptoTransfer;
import net.jacobpeterson.alpaca.openapi.broker.model.CryptoWallet;
import net.jacobpeterson.alpaca.openapi.broker.model.GetCryptoTransferEstimate200Response;
import net.jacobpeterson.alpaca.openapi.broker.model.WhitelistedAddress;
import okhttp3.Call;

public class CryptoFundingApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public CryptoFundingApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CryptoFundingApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    protected Call createCryptoTransferForAccountCall(UUID accountId, CreateCryptoTransferRequest createCryptoTransferRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateCryptoTransferRequest localVarPostBody = createCryptoTransferRequest;
        String localVarPath = "/v1/accounts/{account_id}/wallets/transfers".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createCryptoTransferForAccountValidateBeforeCall(UUID accountId, CreateCryptoTransferRequest createCryptoTransferRequest, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling createCryptoTransferForAccount(Async)");
        }
        if (createCryptoTransferRequest == null) {
            throw new ApiException("Missing the required parameter 'createCryptoTransferRequest' when calling createCryptoTransferForAccount(Async)");
        }
        return this.createCryptoTransferForAccountCall(accountId, createCryptoTransferRequest, _callback);
    }

    public CryptoTransfer createCryptoTransferForAccount(UUID accountId, CreateCryptoTransferRequest createCryptoTransferRequest) throws ApiException {
        ApiResponse<CryptoTransfer> localVarResp = this.createCryptoTransferForAccountWithHttpInfo(accountId, createCryptoTransferRequest);
        return localVarResp.getData();
    }

    protected ApiResponse<CryptoTransfer> createCryptoTransferForAccountWithHttpInfo(UUID accountId, CreateCryptoTransferRequest createCryptoTransferRequest) throws ApiException {
        Call localVarCall = this.createCryptoTransferForAccountValidateBeforeCall(accountId, createCryptoTransferRequest, null);
        Type localVarReturnType = new TypeToken<CryptoTransfer>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call createCryptoTransferForAccountAsync(UUID accountId, CreateCryptoTransferRequest createCryptoTransferRequest, ApiCallback<CryptoTransfer> _callback) throws ApiException {
        Call localVarCall = this.createCryptoTransferForAccountValidateBeforeCall(accountId, createCryptoTransferRequest, _callback);
        Type localVarReturnType = new TypeToken<CryptoTransfer>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call createWhitelistedAddressCall(UUID accountId, CreateWhitelistedAddressRequest createWhitelistedAddressRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateWhitelistedAddressRequest localVarPostBody = createWhitelistedAddressRequest;
        String localVarPath = "/v1/accounts/{account_id}/wallets/whitelists".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createWhitelistedAddressValidateBeforeCall(UUID accountId, CreateWhitelistedAddressRequest createWhitelistedAddressRequest, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling createWhitelistedAddress(Async)");
        }
        if (createWhitelistedAddressRequest == null) {
            throw new ApiException("Missing the required parameter 'createWhitelistedAddressRequest' when calling createWhitelistedAddress(Async)");
        }
        return this.createWhitelistedAddressCall(accountId, createWhitelistedAddressRequest, _callback);
    }

    public WhitelistedAddress createWhitelistedAddress(UUID accountId, CreateWhitelistedAddressRequest createWhitelistedAddressRequest) throws ApiException {
        ApiResponse<WhitelistedAddress> localVarResp = this.createWhitelistedAddressWithHttpInfo(accountId, createWhitelistedAddressRequest);
        return localVarResp.getData();
    }

    protected ApiResponse<WhitelistedAddress> createWhitelistedAddressWithHttpInfo(UUID accountId, CreateWhitelistedAddressRequest createWhitelistedAddressRequest) throws ApiException {
        Call localVarCall = this.createWhitelistedAddressValidateBeforeCall(accountId, createWhitelistedAddressRequest, null);
        Type localVarReturnType = new TypeToken<WhitelistedAddress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call createWhitelistedAddressAsync(UUID accountId, CreateWhitelistedAddressRequest createWhitelistedAddressRequest, ApiCallback<WhitelistedAddress> _callback) throws ApiException {
        Call localVarCall = this.createWhitelistedAddressValidateBeforeCall(accountId, createWhitelistedAddressRequest, _callback);
        Type localVarReturnType = new TypeToken<WhitelistedAddress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call deleteWhitelistedAddressCall(UUID accountId, String whitelistedAddressId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/accounts/{account_id}/wallets/whitelists/{whitelisted_address_id}".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString())).replace("{whitelisted_address_id}", this.localVarApiClient.escapeString(whitelistedAddressId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteWhitelistedAddressValidateBeforeCall(UUID accountId, String whitelistedAddressId, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling deleteWhitelistedAddress(Async)");
        }
        if (whitelistedAddressId == null) {
            throw new ApiException("Missing the required parameter 'whitelistedAddressId' when calling deleteWhitelistedAddress(Async)");
        }
        return this.deleteWhitelistedAddressCall(accountId, whitelistedAddressId, _callback);
    }

    public void deleteWhitelistedAddress(UUID accountId, String whitelistedAddressId) throws ApiException {
        this.deleteWhitelistedAddressWithHttpInfo(accountId, whitelistedAddressId);
    }

    protected ApiResponse<Void> deleteWhitelistedAddressWithHttpInfo(UUID accountId, String whitelistedAddressId) throws ApiException {
        Call localVarCall = this.deleteWhitelistedAddressValidateBeforeCall(accountId, whitelistedAddressId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    protected Call deleteWhitelistedAddressAsync(UUID accountId, String whitelistedAddressId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteWhitelistedAddressValidateBeforeCall(accountId, whitelistedAddressId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    protected Call getCryptoFundingTransferCall(UUID accountId, String transferId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/accounts/{account_id}/wallets/transfers/{transfer_id}".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString())).replace("{transfer_id}", this.localVarApiClient.escapeString(transferId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCryptoFundingTransferValidateBeforeCall(UUID accountId, String transferId, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getCryptoFundingTransfer(Async)");
        }
        if (transferId == null) {
            throw new ApiException("Missing the required parameter 'transferId' when calling getCryptoFundingTransfer(Async)");
        }
        return this.getCryptoFundingTransferCall(accountId, transferId, _callback);
    }

    public CryptoTransfer getCryptoFundingTransfer(UUID accountId, String transferId) throws ApiException {
        ApiResponse<CryptoTransfer> localVarResp = this.getCryptoFundingTransferWithHttpInfo(accountId, transferId);
        return localVarResp.getData();
    }

    protected ApiResponse<CryptoTransfer> getCryptoFundingTransferWithHttpInfo(UUID accountId, String transferId) throws ApiException {
        Call localVarCall = this.getCryptoFundingTransferValidateBeforeCall(accountId, transferId, null);
        Type localVarReturnType = new TypeToken<CryptoTransfer>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getCryptoFundingTransferAsync(UUID accountId, String transferId, ApiCallback<CryptoTransfer> _callback) throws ApiException {
        Call localVarCall = this.getCryptoFundingTransferValidateBeforeCall(accountId, transferId, _callback);
        Type localVarReturnType = new TypeToken<CryptoTransfer>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call getCryptoTransferEstimateCall(String asset, String fromAddress, String toAddress, String amount, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/wallets/fees/estimate";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (asset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("asset", asset));
        }
        if (fromAddress != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from_address", fromAddress));
        }
        if (toAddress != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to_address", toAddress));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCryptoTransferEstimateValidateBeforeCall(String asset, String fromAddress, String toAddress, String amount, ApiCallback _callback) throws ApiException {
        return this.getCryptoTransferEstimateCall(asset, fromAddress, toAddress, amount, _callback);
    }

    public GetCryptoTransferEstimate200Response getCryptoTransferEstimate(String asset, String fromAddress, String toAddress, String amount) throws ApiException {
        ApiResponse<GetCryptoTransferEstimate200Response> localVarResp = this.getCryptoTransferEstimateWithHttpInfo(asset, fromAddress, toAddress, amount);
        return localVarResp.getData();
    }

    protected ApiResponse<GetCryptoTransferEstimate200Response> getCryptoTransferEstimateWithHttpInfo(String asset, String fromAddress, String toAddress, String amount) throws ApiException {
        Call localVarCall = this.getCryptoTransferEstimateValidateBeforeCall(asset, fromAddress, toAddress, amount, null);
        Type localVarReturnType = new TypeToken<GetCryptoTransferEstimate200Response>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getCryptoTransferEstimateAsync(String asset, String fromAddress, String toAddress, String amount, ApiCallback<GetCryptoTransferEstimate200Response> _callback) throws ApiException {
        Call localVarCall = this.getCryptoTransferEstimateValidateBeforeCall(asset, fromAddress, toAddress, amount, _callback);
        Type localVarReturnType = new TypeToken<GetCryptoTransferEstimate200Response>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call listCryptoFundingTransfersCall(UUID accountId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/accounts/{account_id}/wallets/transfers".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listCryptoFundingTransfersValidateBeforeCall(UUID accountId, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling listCryptoFundingTransfers(Async)");
        }
        return this.listCryptoFundingTransfersCall(accountId, _callback);
    }

    public CryptoTransfer listCryptoFundingTransfers(UUID accountId) throws ApiException {
        ApiResponse<CryptoTransfer> localVarResp = this.listCryptoFundingTransfersWithHttpInfo(accountId);
        return localVarResp.getData();
    }

    protected ApiResponse<CryptoTransfer> listCryptoFundingTransfersWithHttpInfo(UUID accountId) throws ApiException {
        Call localVarCall = this.listCryptoFundingTransfersValidateBeforeCall(accountId, null);
        Type localVarReturnType = new TypeToken<CryptoTransfer>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call listCryptoFundingTransfersAsync(UUID accountId, ApiCallback<CryptoTransfer> _callback) throws ApiException {
        Call localVarCall = this.listCryptoFundingTransfersValidateBeforeCall(accountId, _callback);
        Type localVarReturnType = new TypeToken<CryptoTransfer>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call listCryptoFundingWalletsCall(UUID accountId, String asset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/accounts/{account_id}/wallets".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (asset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("asset", asset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listCryptoFundingWalletsValidateBeforeCall(UUID accountId, String asset, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling listCryptoFundingWallets(Async)");
        }
        return this.listCryptoFundingWalletsCall(accountId, asset, _callback);
    }

    public CryptoWallet listCryptoFundingWallets(UUID accountId, String asset) throws ApiException {
        ApiResponse<CryptoWallet> localVarResp = this.listCryptoFundingWalletsWithHttpInfo(accountId, asset);
        return localVarResp.getData();
    }

    protected ApiResponse<CryptoWallet> listCryptoFundingWalletsWithHttpInfo(UUID accountId, String asset) throws ApiException {
        Call localVarCall = this.listCryptoFundingWalletsValidateBeforeCall(accountId, asset, null);
        Type localVarReturnType = new TypeToken<CryptoWallet>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call listCryptoFundingWalletsAsync(UUID accountId, String asset, ApiCallback<CryptoWallet> _callback) throws ApiException {
        Call localVarCall = this.listCryptoFundingWalletsValidateBeforeCall(accountId, asset, _callback);
        Type localVarReturnType = new TypeToken<CryptoWallet>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call listWhitelistedAddressCall(UUID accountId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/accounts/{account_id}/wallets/whitelists".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listWhitelistedAddressValidateBeforeCall(UUID accountId, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling listWhitelistedAddress(Async)");
        }
        return this.listWhitelistedAddressCall(accountId, _callback);
    }

    public WhitelistedAddress listWhitelistedAddress(UUID accountId) throws ApiException {
        ApiResponse<WhitelistedAddress> localVarResp = this.listWhitelistedAddressWithHttpInfo(accountId);
        return localVarResp.getData();
    }

    protected ApiResponse<WhitelistedAddress> listWhitelistedAddressWithHttpInfo(UUID accountId) throws ApiException {
        Call localVarCall = this.listWhitelistedAddressValidateBeforeCall(accountId, null);
        Type localVarReturnType = new TypeToken<WhitelistedAddress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call listWhitelistedAddressAsync(UUID accountId, ApiCallback<WhitelistedAddress> _callback) throws ApiException {
        Call localVarCall = this.listWhitelistedAddressValidateBeforeCall(accountId, _callback);
        Type localVarReturnType = new TypeToken<WhitelistedAddress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

