/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.jacobpeterson.alpaca.openapi.broker.ApiCallback;
import net.jacobpeterson.alpaca.openapi.broker.ApiClient;
import net.jacobpeterson.alpaca.openapi.broker.ApiException;
import net.jacobpeterson.alpaca.openapi.broker.ApiResponse;
import net.jacobpeterson.alpaca.openapi.broker.Configuration;
import net.jacobpeterson.alpaca.openapi.broker.Pair;
import net.jacobpeterson.alpaca.openapi.broker.model.DocumentInner;
import net.jacobpeterson.alpaca.openapi.broker.model.DocumentUploadRequest;
import okhttp3.Call;

public class DocumentsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public DocumentsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DocumentsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    protected Call downloadDocFromAccountCall(UUID accountId, UUID documentId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/accounts/{account_id}/documents/{document_id}/download".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString())).replace("{document_id}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call downloadDocFromAccountValidateBeforeCall(UUID accountId, UUID documentId, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling downloadDocFromAccount(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling downloadDocFromAccount(Async)");
        }
        return this.downloadDocFromAccountCall(accountId, documentId, _callback);
    }

    public void downloadDocFromAccount(UUID accountId, UUID documentId) throws ApiException {
        this.downloadDocFromAccountWithHttpInfo(accountId, documentId);
    }

    protected ApiResponse<Void> downloadDocFromAccountWithHttpInfo(UUID accountId, UUID documentId) throws ApiException {
        Call localVarCall = this.downloadDocFromAccountValidateBeforeCall(accountId, documentId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    protected Call downloadDocFromAccountAsync(UUID accountId, UUID documentId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.downloadDocFromAccountValidateBeforeCall(accountId, documentId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    protected Call downloadDocumentByIdCall(UUID documentId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/documents/{document_id}".replace("{document_id}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call downloadDocumentByIdValidateBeforeCall(UUID documentId, ApiCallback _callback) throws ApiException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling downloadDocumentById(Async)");
        }
        return this.downloadDocumentByIdCall(documentId, _callback);
    }

    public void downloadDocumentById(UUID documentId) throws ApiException {
        this.downloadDocumentByIdWithHttpInfo(documentId);
    }

    protected ApiResponse<Void> downloadDocumentByIdWithHttpInfo(UUID documentId) throws ApiException {
        Call localVarCall = this.downloadDocumentByIdValidateBeforeCall(documentId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    protected Call downloadDocumentByIdAsync(UUID documentId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.downloadDocumentByIdValidateBeforeCall(documentId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    protected Call getDocsForAccountCall(UUID accountId, LocalDate start, LocalDate end, String type, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/accounts/{account_id}/documents".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (start != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start", start));
        }
        if (end != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end", end));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDocsForAccountValidateBeforeCall(UUID accountId, LocalDate start, LocalDate end, String type, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getDocsForAccount(Async)");
        }
        return this.getDocsForAccountCall(accountId, start, end, type, _callback);
    }

    public List<Set<DocumentInner>> getDocsForAccount(UUID accountId, LocalDate start, LocalDate end, String type) throws ApiException {
        ApiResponse<List<Set<DocumentInner>>> localVarResp = this.getDocsForAccountWithHttpInfo(accountId, start, end, type);
        return localVarResp.getData();
    }

    protected ApiResponse<List<Set<DocumentInner>>> getDocsForAccountWithHttpInfo(UUID accountId, LocalDate start, LocalDate end, String type) throws ApiException {
        Call localVarCall = this.getDocsForAccountValidateBeforeCall(accountId, start, end, type, null);
        Type localVarReturnType = new TypeToken<List<Set<DocumentInner>>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getDocsForAccountAsync(UUID accountId, LocalDate start, LocalDate end, String type, ApiCallback<List<Set<DocumentInner>>> _callback) throws ApiException {
        Call localVarCall = this.getDocsForAccountValidateBeforeCall(accountId, start, end, type, _callback);
        Type localVarReturnType = new TypeToken<List<Set<DocumentInner>>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call getV1AccountsAccountIdDocumentsW8benDocumentIdDownloadCall(String accountId, String documentId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/accounts/{account_id}/documents/w8ben/{document_id}/download".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString())).replace("{document_id}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getV1AccountsAccountIdDocumentsW8benDocumentIdDownloadValidateBeforeCall(String accountId, String documentId, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getV1AccountsAccountIdDocumentsW8benDocumentIdDownload(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling getV1AccountsAccountIdDocumentsW8benDocumentIdDownload(Async)");
        }
        return this.getV1AccountsAccountIdDocumentsW8benDocumentIdDownloadCall(accountId, documentId, _callback);
    }

    public void getV1AccountsAccountIdDocumentsW8benDocumentIdDownload(String accountId, String documentId) throws ApiException {
        this.getV1AccountsAccountIdDocumentsW8benDocumentIdDownloadWithHttpInfo(accountId, documentId);
    }

    protected ApiResponse<Void> getV1AccountsAccountIdDocumentsW8benDocumentIdDownloadWithHttpInfo(String accountId, String documentId) throws ApiException {
        Call localVarCall = this.getV1AccountsAccountIdDocumentsW8benDocumentIdDownloadValidateBeforeCall(accountId, documentId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    protected Call getV1AccountsAccountIdDocumentsW8benDocumentIdDownloadAsync(String accountId, String documentId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.getV1AccountsAccountIdDocumentsW8benDocumentIdDownloadValidateBeforeCall(accountId, documentId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    protected Call uploadDocToAccountCall(UUID accountId, DocumentUploadRequest documentUploadRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        DocumentUploadRequest localVarPostBody = documentUploadRequest;
        String localVarPath = "/v1/accounts/{account_id}/documents/upload".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call uploadDocToAccountValidateBeforeCall(UUID accountId, DocumentUploadRequest documentUploadRequest, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling uploadDocToAccount(Async)");
        }
        if (documentUploadRequest == null) {
            throw new ApiException("Missing the required parameter 'documentUploadRequest' when calling uploadDocToAccount(Async)");
        }
        return this.uploadDocToAccountCall(accountId, documentUploadRequest, _callback);
    }

    public void uploadDocToAccount(UUID accountId, DocumentUploadRequest documentUploadRequest) throws ApiException {
        this.uploadDocToAccountWithHttpInfo(accountId, documentUploadRequest);
    }

    protected ApiResponse<Void> uploadDocToAccountWithHttpInfo(UUID accountId, DocumentUploadRequest documentUploadRequest) throws ApiException {
        Call localVarCall = this.uploadDocToAccountValidateBeforeCall(accountId, documentUploadRequest, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    protected Call uploadDocToAccountAsync(UUID accountId, DocumentUploadRequest documentUploadRequest, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.uploadDocToAccountValidateBeforeCall(accountId, documentUploadRequest, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

