/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.jacobpeterson.alpaca.openapi.broker.ApiCallback;
import net.jacobpeterson.alpaca.openapi.broker.ApiClient;
import net.jacobpeterson.alpaca.openapi.broker.ApiException;
import net.jacobpeterson.alpaca.openapi.broker.ApiResponse;
import net.jacobpeterson.alpaca.openapi.broker.Configuration;
import net.jacobpeterson.alpaca.openapi.broker.Pair;
import net.jacobpeterson.alpaca.openapi.broker.model.ACHRelationship;
import net.jacobpeterson.alpaca.openapi.broker.model.Bank;
import net.jacobpeterson.alpaca.openapi.broker.model.CreateACHRelationshipRequest;
import net.jacobpeterson.alpaca.openapi.broker.model.CreateBankRequest;
import net.jacobpeterson.alpaca.openapi.broker.model.CreateTransferRequest;
import net.jacobpeterson.alpaca.openapi.broker.model.DailyTradingLimit;
import net.jacobpeterson.alpaca.openapi.broker.model.GetV1TransfersJitLedgerIdBalances200Response;
import net.jacobpeterson.alpaca.openapi.broker.model.JITLedgerAccount;
import net.jacobpeterson.alpaca.openapi.broker.model.JITReport;
import net.jacobpeterson.alpaca.openapi.broker.model.Transfer;
import okhttp3.Call;

public class FundingApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public FundingApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FundingApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    protected Call createACHRelationshipForAccountCall(UUID accountId, CreateACHRelationshipRequest createACHRelationshipRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateACHRelationshipRequest localVarPostBody = createACHRelationshipRequest;
        String localVarPath = "/v1/accounts/{account_id}/ach_relationships".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createACHRelationshipForAccountValidateBeforeCall(UUID accountId, CreateACHRelationshipRequest createACHRelationshipRequest, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling createACHRelationshipForAccount(Async)");
        }
        if (createACHRelationshipRequest == null) {
            throw new ApiException("Missing the required parameter 'createACHRelationshipRequest' when calling createACHRelationshipForAccount(Async)");
        }
        return this.createACHRelationshipForAccountCall(accountId, createACHRelationshipRequest, _callback);
    }

    public ACHRelationship createACHRelationshipForAccount(UUID accountId, CreateACHRelationshipRequest createACHRelationshipRequest) throws ApiException {
        ApiResponse<ACHRelationship> localVarResp = this.createACHRelationshipForAccountWithHttpInfo(accountId, createACHRelationshipRequest);
        return localVarResp.getData();
    }

    protected ApiResponse<ACHRelationship> createACHRelationshipForAccountWithHttpInfo(UUID accountId, CreateACHRelationshipRequest createACHRelationshipRequest) throws ApiException {
        Call localVarCall = this.createACHRelationshipForAccountValidateBeforeCall(accountId, createACHRelationshipRequest, null);
        Type localVarReturnType = new TypeToken<ACHRelationship>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call createACHRelationshipForAccountAsync(UUID accountId, CreateACHRelationshipRequest createACHRelationshipRequest, ApiCallback<ACHRelationship> _callback) throws ApiException {
        Call localVarCall = this.createACHRelationshipForAccountValidateBeforeCall(accountId, createACHRelationshipRequest, _callback);
        Type localVarReturnType = new TypeToken<ACHRelationship>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call createRecipientBankCall(UUID accountId, CreateBankRequest createBankRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateBankRequest localVarPostBody = createBankRequest;
        String localVarPath = "/v1/accounts/{account_id}/recipient_banks".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createRecipientBankValidateBeforeCall(UUID accountId, CreateBankRequest createBankRequest, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling createRecipientBank(Async)");
        }
        if (createBankRequest == null) {
            throw new ApiException("Missing the required parameter 'createBankRequest' when calling createRecipientBank(Async)");
        }
        return this.createRecipientBankCall(accountId, createBankRequest, _callback);
    }

    public Bank createRecipientBank(UUID accountId, CreateBankRequest createBankRequest) throws ApiException {
        ApiResponse<Bank> localVarResp = this.createRecipientBankWithHttpInfo(accountId, createBankRequest);
        return localVarResp.getData();
    }

    protected ApiResponse<Bank> createRecipientBankWithHttpInfo(UUID accountId, CreateBankRequest createBankRequest) throws ApiException {
        Call localVarCall = this.createRecipientBankValidateBeforeCall(accountId, createBankRequest, null);
        Type localVarReturnType = new TypeToken<Bank>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call createRecipientBankAsync(UUID accountId, CreateBankRequest createBankRequest, ApiCallback<Bank> _callback) throws ApiException {
        Call localVarCall = this.createRecipientBankValidateBeforeCall(accountId, createBankRequest, _callback);
        Type localVarReturnType = new TypeToken<Bank>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call createTransferForAccountCall(UUID accountId, CreateTransferRequest createTransferRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateTransferRequest localVarPostBody = createTransferRequest;
        String localVarPath = "/v1/accounts/{account_id}/transfers".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createTransferForAccountValidateBeforeCall(UUID accountId, CreateTransferRequest createTransferRequest, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling createTransferForAccount(Async)");
        }
        if (createTransferRequest == null) {
            throw new ApiException("Missing the required parameter 'createTransferRequest' when calling createTransferForAccount(Async)");
        }
        return this.createTransferForAccountCall(accountId, createTransferRequest, _callback);
    }

    public Transfer createTransferForAccount(UUID accountId, CreateTransferRequest createTransferRequest) throws ApiException {
        ApiResponse<Transfer> localVarResp = this.createTransferForAccountWithHttpInfo(accountId, createTransferRequest);
        return localVarResp.getData();
    }

    protected ApiResponse<Transfer> createTransferForAccountWithHttpInfo(UUID accountId, CreateTransferRequest createTransferRequest) throws ApiException {
        Call localVarCall = this.createTransferForAccountValidateBeforeCall(accountId, createTransferRequest, null);
        Type localVarReturnType = new TypeToken<Transfer>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call createTransferForAccountAsync(UUID accountId, CreateTransferRequest createTransferRequest, ApiCallback<Transfer> _callback) throws ApiException {
        Call localVarCall = this.createTransferForAccountValidateBeforeCall(accountId, createTransferRequest, _callback);
        Type localVarReturnType = new TypeToken<Transfer>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call deleteACHRelationshipFromAccountCall(UUID accountId, UUID achRelationshipId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/accounts/{account_id}/ach_relationships/{ach_relationship_id}".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString())).replace("{ach_relationship_id}", this.localVarApiClient.escapeString(achRelationshipId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteACHRelationshipFromAccountValidateBeforeCall(UUID accountId, UUID achRelationshipId, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling deleteACHRelationshipFromAccount(Async)");
        }
        if (achRelationshipId == null) {
            throw new ApiException("Missing the required parameter 'achRelationshipId' when calling deleteACHRelationshipFromAccount(Async)");
        }
        return this.deleteACHRelationshipFromAccountCall(accountId, achRelationshipId, _callback);
    }

    public void deleteACHRelationshipFromAccount(UUID accountId, UUID achRelationshipId) throws ApiException {
        this.deleteACHRelationshipFromAccountWithHttpInfo(accountId, achRelationshipId);
    }

    protected ApiResponse<Void> deleteACHRelationshipFromAccountWithHttpInfo(UUID accountId, UUID achRelationshipId) throws ApiException {
        Call localVarCall = this.deleteACHRelationshipFromAccountValidateBeforeCall(accountId, achRelationshipId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    protected Call deleteACHRelationshipFromAccountAsync(UUID accountId, UUID achRelationshipId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteACHRelationshipFromAccountValidateBeforeCall(accountId, achRelationshipId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    protected Call deleteRecipientBankCall(UUID accountId, UUID bankId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/accounts/{account_id}/recipient_banks/{bank_id}".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString())).replace("{bank_id}", this.localVarApiClient.escapeString(bankId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteRecipientBankValidateBeforeCall(UUID accountId, UUID bankId, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling deleteRecipientBank(Async)");
        }
        if (bankId == null) {
            throw new ApiException("Missing the required parameter 'bankId' when calling deleteRecipientBank(Async)");
        }
        return this.deleteRecipientBankCall(accountId, bankId, _callback);
    }

    public void deleteRecipientBank(UUID accountId, UUID bankId) throws ApiException {
        this.deleteRecipientBankWithHttpInfo(accountId, bankId);
    }

    protected ApiResponse<Void> deleteRecipientBankWithHttpInfo(UUID accountId, UUID bankId) throws ApiException {
        Call localVarCall = this.deleteRecipientBankValidateBeforeCall(accountId, bankId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    protected Call deleteRecipientBankAsync(UUID accountId, UUID bankId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteRecipientBankValidateBeforeCall(accountId, bankId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    protected Call deleteTransferCall(UUID accountId, UUID transferId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/accounts/{account_id}/transfers/{transfer_id}".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString())).replace("{transfer_id}", this.localVarApiClient.escapeString(transferId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteTransferValidateBeforeCall(UUID accountId, UUID transferId, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling deleteTransfer(Async)");
        }
        if (transferId == null) {
            throw new ApiException("Missing the required parameter 'transferId' when calling deleteTransfer(Async)");
        }
        return this.deleteTransferCall(accountId, transferId, _callback);
    }

    public void deleteTransfer(UUID accountId, UUID transferId) throws ApiException {
        this.deleteTransferWithHttpInfo(accountId, transferId);
    }

    protected ApiResponse<Void> deleteTransferWithHttpInfo(UUID accountId, UUID transferId) throws ApiException {
        Call localVarCall = this.deleteTransferValidateBeforeCall(accountId, transferId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    protected Call deleteTransferAsync(UUID accountId, UUID transferId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteTransferValidateBeforeCall(accountId, transferId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    protected Call getAccountACHRelationshipsCall(UUID accountId, String statuses, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/accounts/{account_id}/ach_relationships".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (statuses != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("statuses", statuses));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAccountACHRelationshipsValidateBeforeCall(UUID accountId, String statuses, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getAccountACHRelationships(Async)");
        }
        return this.getAccountACHRelationshipsCall(accountId, statuses, _callback);
    }

    public List<ACHRelationship> getAccountACHRelationships(UUID accountId, String statuses) throws ApiException {
        ApiResponse<List<ACHRelationship>> localVarResp = this.getAccountACHRelationshipsWithHttpInfo(accountId, statuses);
        return localVarResp.getData();
    }

    protected ApiResponse<List<ACHRelationship>> getAccountACHRelationshipsWithHttpInfo(UUID accountId, String statuses) throws ApiException {
        Call localVarCall = this.getAccountACHRelationshipsValidateBeforeCall(accountId, statuses, null);
        Type localVarReturnType = new TypeToken<List<ACHRelationship>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getAccountACHRelationshipsAsync(UUID accountId, String statuses, ApiCallback<List<ACHRelationship>> _callback) throws ApiException {
        Call localVarCall = this.getAccountACHRelationshipsValidateBeforeCall(accountId, statuses, _callback);
        Type localVarReturnType = new TypeToken<List<ACHRelationship>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call getRecipientBanksCall(UUID accountId, String status, String bankName, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/accounts/{account_id}/recipient_banks".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (status != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("status", status));
        }
        if (bankName != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("bank_name", bankName));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getRecipientBanksValidateBeforeCall(UUID accountId, String status, String bankName, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getRecipientBanks(Async)");
        }
        return this.getRecipientBanksCall(accountId, status, bankName, _callback);
    }

    public List<Bank> getRecipientBanks(UUID accountId, String status, String bankName) throws ApiException {
        ApiResponse<List<Bank>> localVarResp = this.getRecipientBanksWithHttpInfo(accountId, status, bankName);
        return localVarResp.getData();
    }

    protected ApiResponse<List<Bank>> getRecipientBanksWithHttpInfo(UUID accountId, String status, String bankName) throws ApiException {
        Call localVarCall = this.getRecipientBanksValidateBeforeCall(accountId, status, bankName, null);
        Type localVarReturnType = new TypeToken<List<Bank>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getRecipientBanksAsync(UUID accountId, String status, String bankName, ApiCallback<List<Bank>> _callback) throws ApiException {
        Call localVarCall = this.getRecipientBanksValidateBeforeCall(accountId, status, bankName, _callback);
        Type localVarReturnType = new TypeToken<List<Bank>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call getTransfersForAccountCall(UUID accountId, String direction, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/accounts/{account_id}/transfers".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (direction != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("direction", direction));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTransfersForAccountValidateBeforeCall(UUID accountId, String direction, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getTransfersForAccount(Async)");
        }
        return this.getTransfersForAccountCall(accountId, direction, limit, offset, _callback);
    }

    public List<Transfer> getTransfersForAccount(UUID accountId, String direction, Integer limit, Integer offset) throws ApiException {
        ApiResponse<List<Transfer>> localVarResp = this.getTransfersForAccountWithHttpInfo(accountId, direction, limit, offset);
        return localVarResp.getData();
    }

    protected ApiResponse<List<Transfer>> getTransfersForAccountWithHttpInfo(UUID accountId, String direction, Integer limit, Integer offset) throws ApiException {
        Call localVarCall = this.getTransfersForAccountValidateBeforeCall(accountId, direction, limit, offset, null);
        Type localVarReturnType = new TypeToken<List<Transfer>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getTransfersForAccountAsync(UUID accountId, String direction, Integer limit, Integer offset, ApiCallback<List<Transfer>> _callback) throws ApiException {
        Call localVarCall = this.getTransfersForAccountValidateBeforeCall(accountId, direction, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<List<Transfer>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call getV1TransfersJitLedgerIdBalancesCall(String ledgerId, LocalDate startDate, LocalDate endDate, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/transfers/jit/{ledger_id}/balances".replace("{ledger_id}", this.localVarApiClient.escapeString(ledgerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (startDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start_date", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end_date", endDate));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getV1TransfersJitLedgerIdBalancesValidateBeforeCall(String ledgerId, LocalDate startDate, LocalDate endDate, ApiCallback _callback) throws ApiException {
        if (ledgerId == null) {
            throw new ApiException("Missing the required parameter 'ledgerId' when calling getV1TransfersJitLedgerIdBalances(Async)");
        }
        return this.getV1TransfersJitLedgerIdBalancesCall(ledgerId, startDate, endDate, _callback);
    }

    public GetV1TransfersJitLedgerIdBalances200Response getV1TransfersJitLedgerIdBalances(String ledgerId, LocalDate startDate, LocalDate endDate) throws ApiException {
        ApiResponse<GetV1TransfersJitLedgerIdBalances200Response> localVarResp = this.getV1TransfersJitLedgerIdBalancesWithHttpInfo(ledgerId, startDate, endDate);
        return localVarResp.getData();
    }

    protected ApiResponse<GetV1TransfersJitLedgerIdBalances200Response> getV1TransfersJitLedgerIdBalancesWithHttpInfo(String ledgerId, LocalDate startDate, LocalDate endDate) throws ApiException {
        Call localVarCall = this.getV1TransfersJitLedgerIdBalancesValidateBeforeCall(ledgerId, startDate, endDate, null);
        Type localVarReturnType = new TypeToken<GetV1TransfersJitLedgerIdBalances200Response>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getV1TransfersJitLedgerIdBalancesAsync(String ledgerId, LocalDate startDate, LocalDate endDate, ApiCallback<GetV1TransfersJitLedgerIdBalances200Response> _callback) throws ApiException {
        Call localVarCall = this.getV1TransfersJitLedgerIdBalancesValidateBeforeCall(ledgerId, startDate, endDate, _callback);
        Type localVarReturnType = new TypeToken<GetV1TransfersJitLedgerIdBalances200Response>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call getV1TransfersJitLedgersCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/transfers/jit/ledgers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getV1TransfersJitLedgersValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.getV1TransfersJitLedgersCall(_callback);
    }

    public List<JITLedgerAccount> getV1TransfersJitLedgers() throws ApiException {
        ApiResponse<List<JITLedgerAccount>> localVarResp = this.getV1TransfersJitLedgersWithHttpInfo();
        return localVarResp.getData();
    }

    protected ApiResponse<List<JITLedgerAccount>> getV1TransfersJitLedgersWithHttpInfo() throws ApiException {
        Call localVarCall = this.getV1TransfersJitLedgersValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<JITLedgerAccount>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getV1TransfersJitLedgersAsync(ApiCallback<List<JITLedgerAccount>> _callback) throws ApiException {
        Call localVarCall = this.getV1TransfersJitLedgersValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<JITLedgerAccount>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call getV1TransfersJitLimitsCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/transfers/jit/limits";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getV1TransfersJitLimitsValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.getV1TransfersJitLimitsCall(_callback);
    }

    public DailyTradingLimit getV1TransfersJitLimits() throws ApiException {
        ApiResponse<DailyTradingLimit> localVarResp = this.getV1TransfersJitLimitsWithHttpInfo();
        return localVarResp.getData();
    }

    protected ApiResponse<DailyTradingLimit> getV1TransfersJitLimitsWithHttpInfo() throws ApiException {
        Call localVarCall = this.getV1TransfersJitLimitsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<DailyTradingLimit>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getV1TransfersJitLimitsAsync(ApiCallback<DailyTradingLimit> _callback) throws ApiException {
        Call localVarCall = this.getV1TransfersJitLimitsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<DailyTradingLimit>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call getV1TransfersJitReportsCall(String reportType, LocalDate systemDate, String assetClass, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/transfers/jit/reports";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (reportType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("report_type", reportType));
        }
        if (systemDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("system_date", systemDate));
        }
        if (assetClass != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("asset_class", assetClass));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getV1TransfersJitReportsValidateBeforeCall(String reportType, LocalDate systemDate, String assetClass, ApiCallback _callback) throws ApiException {
        if (reportType == null) {
            throw new ApiException("Missing the required parameter 'reportType' when calling getV1TransfersJitReports(Async)");
        }
        if (systemDate == null) {
            throw new ApiException("Missing the required parameter 'systemDate' when calling getV1TransfersJitReports(Async)");
        }
        return this.getV1TransfersJitReportsCall(reportType, systemDate, assetClass, _callback);
    }

    public JITReport getV1TransfersJitReports(String reportType, LocalDate systemDate, String assetClass) throws ApiException {
        ApiResponse<JITReport> localVarResp = this.getV1TransfersJitReportsWithHttpInfo(reportType, systemDate, assetClass);
        return localVarResp.getData();
    }

    protected ApiResponse<JITReport> getV1TransfersJitReportsWithHttpInfo(String reportType, LocalDate systemDate, String assetClass) throws ApiException {
        Call localVarCall = this.getV1TransfersJitReportsValidateBeforeCall(reportType, systemDate, assetClass, null);
        Type localVarReturnType = new TypeToken<JITReport>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getV1TransfersJitReportsAsync(String reportType, LocalDate systemDate, String assetClass, ApiCallback<JITReport> _callback) throws ApiException {
        Call localVarCall = this.getV1TransfersJitReportsValidateBeforeCall(reportType, systemDate, assetClass, _callback);
        Type localVarReturnType = new TypeToken<JITReport>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

