/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.jacobpeterson.alpaca.openapi.broker.ApiCallback;
import net.jacobpeterson.alpaca.openapi.broker.ApiClient;
import net.jacobpeterson.alpaca.openapi.broker.ApiException;
import net.jacobpeterson.alpaca.openapi.broker.ApiResponse;
import net.jacobpeterson.alpaca.openapi.broker.Configuration;
import net.jacobpeterson.alpaca.openapi.broker.Pair;
import net.jacobpeterson.alpaca.openapi.broker.model.BatchCreateFundingWalletRequest;
import net.jacobpeterson.alpaca.openapi.broker.model.BatchCreateFundingWalletResponse;
import net.jacobpeterson.alpaca.openapi.broker.model.CreateFundingWalletWithdrawalRequest;
import net.jacobpeterson.alpaca.openapi.broker.model.DemoFundingTransfer;
import net.jacobpeterson.alpaca.openapi.broker.model.FundingDetailPaymentType;
import net.jacobpeterson.alpaca.openapi.broker.model.FundingWallet;
import net.jacobpeterson.alpaca.openapi.broker.model.FundingWalletRecipientBank;
import net.jacobpeterson.alpaca.openapi.broker.model.FundingWalletTransfer;
import net.jacobpeterson.alpaca.openapi.broker.model.ListFundingDetails;
import net.jacobpeterson.alpaca.openapi.broker.model.ListTransfersResponse;
import okhttp3.Call;

public class FundingWalletsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public FundingWalletsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FundingWalletsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    protected Call batchCreateFundingWalletsCall(BatchCreateFundingWalletRequest batchCreateFundingWalletRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        BatchCreateFundingWalletRequest localVarPostBody = batchCreateFundingWalletRequest;
        String localVarPath = "/v1beta/accounts/funding_wallet";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call batchCreateFundingWalletsValidateBeforeCall(BatchCreateFundingWalletRequest batchCreateFundingWalletRequest, ApiCallback _callback) throws ApiException {
        if (batchCreateFundingWalletRequest == null) {
            throw new ApiException("Missing the required parameter 'batchCreateFundingWalletRequest' when calling batchCreateFundingWallets(Async)");
        }
        return this.batchCreateFundingWalletsCall(batchCreateFundingWalletRequest, _callback);
    }

    public BatchCreateFundingWalletResponse batchCreateFundingWallets(BatchCreateFundingWalletRequest batchCreateFundingWalletRequest) throws ApiException {
        ApiResponse<BatchCreateFundingWalletResponse> localVarResp = this.batchCreateFundingWalletsWithHttpInfo(batchCreateFundingWalletRequest);
        return localVarResp.getData();
    }

    protected ApiResponse<BatchCreateFundingWalletResponse> batchCreateFundingWalletsWithHttpInfo(BatchCreateFundingWalletRequest batchCreateFundingWalletRequest) throws ApiException {
        Call localVarCall = this.batchCreateFundingWalletsValidateBeforeCall(batchCreateFundingWalletRequest, null);
        Type localVarReturnType = new TypeToken<BatchCreateFundingWalletResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call batchCreateFundingWalletsAsync(BatchCreateFundingWalletRequest batchCreateFundingWalletRequest, ApiCallback<BatchCreateFundingWalletResponse> _callback) throws ApiException {
        Call localVarCall = this.batchCreateFundingWalletsValidateBeforeCall(batchCreateFundingWalletRequest, _callback);
        Type localVarReturnType = new TypeToken<BatchCreateFundingWalletResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call createFundingWalletCall(String accountId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1beta/accounts/{account_id}/funding_wallet".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createFundingWalletValidateBeforeCall(String accountId, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling createFundingWallet(Async)");
        }
        return this.createFundingWalletCall(accountId, _callback);
    }

    public FundingWallet createFundingWallet(String accountId) throws ApiException {
        ApiResponse<FundingWallet> localVarResp = this.createFundingWalletWithHttpInfo(accountId);
        return localVarResp.getData();
    }

    protected ApiResponse<FundingWallet> createFundingWalletWithHttpInfo(String accountId) throws ApiException {
        Call localVarCall = this.createFundingWalletValidateBeforeCall(accountId, null);
        Type localVarReturnType = new TypeToken<FundingWallet>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call createFundingWalletAsync(String accountId, ApiCallback<FundingWallet> _callback) throws ApiException {
        Call localVarCall = this.createFundingWalletValidateBeforeCall(accountId, _callback);
        Type localVarReturnType = new TypeToken<FundingWallet>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call createFundingWalletRecipientBankCall(String accountId, String bankAccountHolderName, String bankCountry, String currency, String bankName, String streetAddress, String accountNumber, String routingCodeType, String routingCode, String bicSwift, String iban, String accountType, String city, String postalCode, String stateOrProvince, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1beta/accounts/{account_id}/funding_wallet/recipient_bank".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (bankName != null) {
            localVarFormParams.put("bank_name", bankName);
        }
        if (bankAccountHolderName != null) {
            localVarFormParams.put("bank_account_holder_name", bankAccountHolderName);
        }
        if (bankCountry != null) {
            localVarFormParams.put("bank_country", bankCountry);
        }
        if (currency != null) {
            localVarFormParams.put("currency", currency);
        }
        if (streetAddress != null) {
            localVarFormParams.put("street_address", streetAddress);
        }
        if (accountNumber != null) {
            localVarFormParams.put("account_number", accountNumber);
        }
        if (routingCodeType != null) {
            localVarFormParams.put("routing_code_type", routingCodeType);
        }
        if (routingCode != null) {
            localVarFormParams.put("routing_code", routingCode);
        }
        if (bicSwift != null) {
            localVarFormParams.put("bic_swift", bicSwift);
        }
        if (iban != null) {
            localVarFormParams.put("iban", iban);
        }
        if (accountType != null) {
            localVarFormParams.put("account_type", accountType);
        }
        if (city != null) {
            localVarFormParams.put("city", city);
        }
        if (postalCode != null) {
            localVarFormParams.put("postal_code", postalCode);
        }
        if (stateOrProvince != null) {
            localVarFormParams.put("state_or_province", stateOrProvince);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createFundingWalletRecipientBankValidateBeforeCall(String accountId, String bankAccountHolderName, String bankCountry, String currency, String bankName, String streetAddress, String accountNumber, String routingCodeType, String routingCode, String bicSwift, String iban, String accountType, String city, String postalCode, String stateOrProvince, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling createFundingWalletRecipientBank(Async)");
        }
        if (bankAccountHolderName == null) {
            throw new ApiException("Missing the required parameter 'bankAccountHolderName' when calling createFundingWalletRecipientBank(Async)");
        }
        if (bankCountry == null) {
            throw new ApiException("Missing the required parameter 'bankCountry' when calling createFundingWalletRecipientBank(Async)");
        }
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling createFundingWalletRecipientBank(Async)");
        }
        return this.createFundingWalletRecipientBankCall(accountId, bankAccountHolderName, bankCountry, currency, bankName, streetAddress, accountNumber, routingCodeType, routingCode, bicSwift, iban, accountType, city, postalCode, stateOrProvince, _callback);
    }

    public FundingWalletRecipientBank createFundingWalletRecipientBank(String accountId, String bankAccountHolderName, String bankCountry, String currency, String bankName, String streetAddress, String accountNumber, String routingCodeType, String routingCode, String bicSwift, String iban, String accountType, String city, String postalCode, String stateOrProvince) throws ApiException {
        ApiResponse<FundingWalletRecipientBank> localVarResp = this.createFundingWalletRecipientBankWithHttpInfo(accountId, bankAccountHolderName, bankCountry, currency, bankName, streetAddress, accountNumber, routingCodeType, routingCode, bicSwift, iban, accountType, city, postalCode, stateOrProvince);
        return localVarResp.getData();
    }

    protected ApiResponse<FundingWalletRecipientBank> createFundingWalletRecipientBankWithHttpInfo(String accountId, String bankAccountHolderName, String bankCountry, String currency, String bankName, String streetAddress, String accountNumber, String routingCodeType, String routingCode, String bicSwift, String iban, String accountType, String city, String postalCode, String stateOrProvince) throws ApiException {
        Call localVarCall = this.createFundingWalletRecipientBankValidateBeforeCall(accountId, bankAccountHolderName, bankCountry, currency, bankName, streetAddress, accountNumber, routingCodeType, routingCode, bicSwift, iban, accountType, city, postalCode, stateOrProvince, null);
        Type localVarReturnType = new TypeToken<FundingWalletRecipientBank>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call createFundingWalletRecipientBankAsync(String accountId, String bankAccountHolderName, String bankCountry, String currency, String bankName, String streetAddress, String accountNumber, String routingCodeType, String routingCode, String bicSwift, String iban, String accountType, String city, String postalCode, String stateOrProvince, ApiCallback<FundingWalletRecipientBank> _callback) throws ApiException {
        Call localVarCall = this.createFundingWalletRecipientBankValidateBeforeCall(accountId, bankAccountHolderName, bankCountry, currency, bankName, streetAddress, accountNumber, routingCodeType, routingCode, bicSwift, iban, accountType, city, postalCode, stateOrProvince, _callback);
        Type localVarReturnType = new TypeToken<FundingWalletRecipientBank>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call createFundingWalletWithdrawalCall(String accountId, CreateFundingWalletWithdrawalRequest createFundingWalletWithdrawalRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateFundingWalletWithdrawalRequest localVarPostBody = createFundingWalletWithdrawalRequest;
        String localVarPath = "/v1beta/accounts/{account_id}/funding_wallet/withdrawal".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createFundingWalletWithdrawalValidateBeforeCall(String accountId, CreateFundingWalletWithdrawalRequest createFundingWalletWithdrawalRequest, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling createFundingWalletWithdrawal(Async)");
        }
        if (createFundingWalletWithdrawalRequest == null) {
            throw new ApiException("Missing the required parameter 'createFundingWalletWithdrawalRequest' when calling createFundingWalletWithdrawal(Async)");
        }
        return this.createFundingWalletWithdrawalCall(accountId, createFundingWalletWithdrawalRequest, _callback);
    }

    public FundingWalletTransfer createFundingWalletWithdrawal(String accountId, CreateFundingWalletWithdrawalRequest createFundingWalletWithdrawalRequest) throws ApiException {
        ApiResponse<FundingWalletTransfer> localVarResp = this.createFundingWalletWithdrawalWithHttpInfo(accountId, createFundingWalletWithdrawalRequest);
        return localVarResp.getData();
    }

    protected ApiResponse<FundingWalletTransfer> createFundingWalletWithdrawalWithHttpInfo(String accountId, CreateFundingWalletWithdrawalRequest createFundingWalletWithdrawalRequest) throws ApiException {
        Call localVarCall = this.createFundingWalletWithdrawalValidateBeforeCall(accountId, createFundingWalletWithdrawalRequest, null);
        Type localVarReturnType = new TypeToken<FundingWalletTransfer>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call createFundingWalletWithdrawalAsync(String accountId, CreateFundingWalletWithdrawalRequest createFundingWalletWithdrawalRequest, ApiCallback<FundingWalletTransfer> _callback) throws ApiException {
        Call localVarCall = this.createFundingWalletWithdrawalValidateBeforeCall(accountId, createFundingWalletWithdrawalRequest, _callback);
        Type localVarReturnType = new TypeToken<FundingWalletTransfer>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call deleteFundingWalletRecipientBankCall(String accountId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1beta/accounts/{account_id}/funding_wallet/recipient_bank".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteFundingWalletRecipientBankValidateBeforeCall(String accountId, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling deleteFundingWalletRecipientBank(Async)");
        }
        return this.deleteFundingWalletRecipientBankCall(accountId, _callback);
    }

    public FundingWalletRecipientBank deleteFundingWalletRecipientBank(String accountId) throws ApiException {
        ApiResponse<FundingWalletRecipientBank> localVarResp = this.deleteFundingWalletRecipientBankWithHttpInfo(accountId);
        return localVarResp.getData();
    }

    protected ApiResponse<FundingWalletRecipientBank> deleteFundingWalletRecipientBankWithHttpInfo(String accountId) throws ApiException {
        Call localVarCall = this.deleteFundingWalletRecipientBankValidateBeforeCall(accountId, null);
        Type localVarReturnType = new TypeToken<FundingWalletRecipientBank>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call deleteFundingWalletRecipientBankAsync(String accountId, ApiCallback<FundingWalletRecipientBank> _callback) throws ApiException {
        Call localVarCall = this.deleteFundingWalletRecipientBankValidateBeforeCall(accountId, _callback);
        Type localVarReturnType = new TypeToken<FundingWalletRecipientBank>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call demoDepositFundingCall(DemoFundingTransfer demoFundingTransfer, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        DemoFundingTransfer localVarPostBody = demoFundingTransfer;
        String localVarPath = "/v1beta/demo/banking/funding";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call demoDepositFundingValidateBeforeCall(DemoFundingTransfer demoFundingTransfer, ApiCallback _callback) throws ApiException {
        if (demoFundingTransfer == null) {
            throw new ApiException("Missing the required parameter 'demoFundingTransfer' when calling demoDepositFunding(Async)");
        }
        return this.demoDepositFundingCall(demoFundingTransfer, _callback);
    }

    public DemoFundingTransfer demoDepositFunding(DemoFundingTransfer demoFundingTransfer) throws ApiException {
        ApiResponse<DemoFundingTransfer> localVarResp = this.demoDepositFundingWithHttpInfo(demoFundingTransfer);
        return localVarResp.getData();
    }

    protected ApiResponse<DemoFundingTransfer> demoDepositFundingWithHttpInfo(DemoFundingTransfer demoFundingTransfer) throws ApiException {
        Call localVarCall = this.demoDepositFundingValidateBeforeCall(demoFundingTransfer, null);
        Type localVarReturnType = new TypeToken<DemoFundingTransfer>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call demoDepositFundingAsync(DemoFundingTransfer demoFundingTransfer, ApiCallback<DemoFundingTransfer> _callback) throws ApiException {
        Call localVarCall = this.demoDepositFundingValidateBeforeCall(demoFundingTransfer, _callback);
        Type localVarReturnType = new TypeToken<DemoFundingTransfer>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call getFundingWalletCall(String accountId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1beta/accounts/{account_id}/funding_wallet".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getFundingWalletValidateBeforeCall(String accountId, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getFundingWallet(Async)");
        }
        return this.getFundingWalletCall(accountId, _callback);
    }

    public FundingWallet getFundingWallet(String accountId) throws ApiException {
        ApiResponse<FundingWallet> localVarResp = this.getFundingWalletWithHttpInfo(accountId);
        return localVarResp.getData();
    }

    protected ApiResponse<FundingWallet> getFundingWalletWithHttpInfo(String accountId) throws ApiException {
        Call localVarCall = this.getFundingWalletValidateBeforeCall(accountId, null);
        Type localVarReturnType = new TypeToken<FundingWallet>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getFundingWalletAsync(String accountId, ApiCallback<FundingWallet> _callback) throws ApiException {
        Call localVarCall = this.getFundingWalletValidateBeforeCall(accountId, _callback);
        Type localVarReturnType = new TypeToken<FundingWallet>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call getFundingWalletRecipientBankCall(String accountId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1beta/accounts/{account_id}/funding_wallet/recipient_bank".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getFundingWalletRecipientBankValidateBeforeCall(String accountId, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getFundingWalletRecipientBank(Async)");
        }
        return this.getFundingWalletRecipientBankCall(accountId, _callback);
    }

    public void getFundingWalletRecipientBank(String accountId) throws ApiException {
        this.getFundingWalletRecipientBankWithHttpInfo(accountId);
    }

    protected ApiResponse<Void> getFundingWalletRecipientBankWithHttpInfo(String accountId) throws ApiException {
        Call localVarCall = this.getFundingWalletRecipientBankValidateBeforeCall(accountId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    protected Call getFundingWalletRecipientBankAsync(String accountId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.getFundingWalletRecipientBankValidateBeforeCall(accountId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    protected Call getFundingWalletTransfersCall(String accountId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1beta/accounts/{account_id}/funding_wallet/transfers".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getFundingWalletTransfersValidateBeforeCall(String accountId, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getFundingWalletTransfers(Async)");
        }
        return this.getFundingWalletTransfersCall(accountId, _callback);
    }

    public ListTransfersResponse getFundingWalletTransfers(String accountId) throws ApiException {
        ApiResponse<ListTransfersResponse> localVarResp = this.getFundingWalletTransfersWithHttpInfo(accountId);
        return localVarResp.getData();
    }

    protected ApiResponse<ListTransfersResponse> getFundingWalletTransfersWithHttpInfo(String accountId) throws ApiException {
        Call localVarCall = this.getFundingWalletTransfersValidateBeforeCall(accountId, null);
        Type localVarReturnType = new TypeToken<ListTransfersResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getFundingWalletTransfersAsync(String accountId, ApiCallback<ListTransfersResponse> _callback) throws ApiException {
        Call localVarCall = this.getFundingWalletTransfersValidateBeforeCall(accountId, _callback);
        Type localVarReturnType = new TypeToken<ListTransfersResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call listFundingDetailsCall(String accountId, FundingDetailPaymentType paymentType, String currency, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1beta/accounts/{account_id}/funding_wallet/funding_details".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (paymentType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("payment_type", (Object)paymentType));
        }
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listFundingDetailsValidateBeforeCall(String accountId, FundingDetailPaymentType paymentType, String currency, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling listFundingDetails(Async)");
        }
        return this.listFundingDetailsCall(accountId, paymentType, currency, _callback);
    }

    public List<ListFundingDetails> listFundingDetails(String accountId, FundingDetailPaymentType paymentType, String currency) throws ApiException {
        ApiResponse<List<ListFundingDetails>> localVarResp = this.listFundingDetailsWithHttpInfo(accountId, paymentType, currency);
        return localVarResp.getData();
    }

    protected ApiResponse<List<ListFundingDetails>> listFundingDetailsWithHttpInfo(String accountId, FundingDetailPaymentType paymentType, String currency) throws ApiException {
        Call localVarCall = this.listFundingDetailsValidateBeforeCall(accountId, paymentType, currency, null);
        Type localVarReturnType = new TypeToken<List<ListFundingDetails>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call listFundingDetailsAsync(String accountId, FundingDetailPaymentType paymentType, String currency, ApiCallback<List<ListFundingDetails>> _callback) throws ApiException {
        Call localVarCall = this.listFundingDetailsValidateBeforeCall(accountId, paymentType, currency, _callback);
        Type localVarReturnType = new TypeToken<List<ListFundingDetails>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

