/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.jacobpeterson.alpaca.openapi.broker.ApiCallback;
import net.jacobpeterson.alpaca.openapi.broker.ApiClient;
import net.jacobpeterson.alpaca.openapi.broker.ApiException;
import net.jacobpeterson.alpaca.openapi.broker.ApiResponse;
import net.jacobpeterson.alpaca.openapi.broker.Configuration;
import net.jacobpeterson.alpaca.openapi.broker.Pair;
import net.jacobpeterson.alpaca.openapi.broker.model.BatchJournalRequest;
import net.jacobpeterson.alpaca.openapi.broker.model.BatchJournalResponse;
import net.jacobpeterson.alpaca.openapi.broker.model.CreateJournalRequest;
import net.jacobpeterson.alpaca.openapi.broker.model.Journal;
import net.jacobpeterson.alpaca.openapi.broker.model.ReverseBatchJournalRequest;
import okhttp3.Call;

public class JournalsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public JournalsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public JournalsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    protected Call createBatchJournalCall(BatchJournalRequest batchJournalRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        BatchJournalRequest localVarPostBody = batchJournalRequest;
        String localVarPath = "/v1/journals/batch";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createBatchJournalValidateBeforeCall(BatchJournalRequest batchJournalRequest, ApiCallback _callback) throws ApiException {
        if (batchJournalRequest == null) {
            throw new ApiException("Missing the required parameter 'batchJournalRequest' when calling createBatchJournal(Async)");
        }
        return this.createBatchJournalCall(batchJournalRequest, _callback);
    }

    public List<BatchJournalResponse> createBatchJournal(BatchJournalRequest batchJournalRequest) throws ApiException {
        ApiResponse<List<BatchJournalResponse>> localVarResp = this.createBatchJournalWithHttpInfo(batchJournalRequest);
        return localVarResp.getData();
    }

    protected ApiResponse<List<BatchJournalResponse>> createBatchJournalWithHttpInfo(BatchJournalRequest batchJournalRequest) throws ApiException {
        Call localVarCall = this.createBatchJournalValidateBeforeCall(batchJournalRequest, null);
        Type localVarReturnType = new TypeToken<List<BatchJournalResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call createBatchJournalAsync(BatchJournalRequest batchJournalRequest, ApiCallback<List<BatchJournalResponse>> _callback) throws ApiException {
        Call localVarCall = this.createBatchJournalValidateBeforeCall(batchJournalRequest, _callback);
        Type localVarReturnType = new TypeToken<List<BatchJournalResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call createJournalCall(CreateJournalRequest createJournalRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateJournalRequest localVarPostBody = createJournalRequest;
        String localVarPath = "/v1/journals";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createJournalValidateBeforeCall(CreateJournalRequest createJournalRequest, ApiCallback _callback) throws ApiException {
        if (createJournalRequest == null) {
            throw new ApiException("Missing the required parameter 'createJournalRequest' when calling createJournal(Async)");
        }
        return this.createJournalCall(createJournalRequest, _callback);
    }

    public Journal createJournal(CreateJournalRequest createJournalRequest) throws ApiException {
        ApiResponse<Journal> localVarResp = this.createJournalWithHttpInfo(createJournalRequest);
        return localVarResp.getData();
    }

    protected ApiResponse<Journal> createJournalWithHttpInfo(CreateJournalRequest createJournalRequest) throws ApiException {
        Call localVarCall = this.createJournalValidateBeforeCall(createJournalRequest, null);
        Type localVarReturnType = new TypeToken<Journal>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call createJournalAsync(CreateJournalRequest createJournalRequest, ApiCallback<Journal> _callback) throws ApiException {
        Call localVarCall = this.createJournalValidateBeforeCall(createJournalRequest, _callback);
        Type localVarReturnType = new TypeToken<Journal>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call deleteJournalByIdCall(UUID journalId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/journals/{journal_id}".replace("{journal_id}", this.localVarApiClient.escapeString(journalId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteJournalByIdValidateBeforeCall(UUID journalId, ApiCallback _callback) throws ApiException {
        if (journalId == null) {
            throw new ApiException("Missing the required parameter 'journalId' when calling deleteJournalById(Async)");
        }
        return this.deleteJournalByIdCall(journalId, _callback);
    }

    public void deleteJournalById(UUID journalId) throws ApiException {
        this.deleteJournalByIdWithHttpInfo(journalId);
    }

    protected ApiResponse<Void> deleteJournalByIdWithHttpInfo(UUID journalId) throws ApiException {
        Call localVarCall = this.deleteJournalByIdValidateBeforeCall(journalId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    protected Call deleteJournalByIdAsync(UUID journalId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteJournalByIdValidateBeforeCall(journalId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    protected Call getAllJournalsCall(LocalDate after, LocalDate before, String status, String entryType, UUID toAccount, UUID fromAccount, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/journals";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (before != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("before", before));
        }
        if (status != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("status", status));
        }
        if (entryType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("entry_type", entryType));
        }
        if (toAccount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to_account", toAccount));
        }
        if (fromAccount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from_account", fromAccount));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAllJournalsValidateBeforeCall(LocalDate after, LocalDate before, String status, String entryType, UUID toAccount, UUID fromAccount, ApiCallback _callback) throws ApiException {
        return this.getAllJournalsCall(after, before, status, entryType, toAccount, fromAccount, _callback);
    }

    public List<Journal> getAllJournals(LocalDate after, LocalDate before, String status, String entryType, UUID toAccount, UUID fromAccount) throws ApiException {
        ApiResponse<List<Journal>> localVarResp = this.getAllJournalsWithHttpInfo(after, before, status, entryType, toAccount, fromAccount);
        return localVarResp.getData();
    }

    protected ApiResponse<List<Journal>> getAllJournalsWithHttpInfo(LocalDate after, LocalDate before, String status, String entryType, UUID toAccount, UUID fromAccount) throws ApiException {
        Call localVarCall = this.getAllJournalsValidateBeforeCall(after, before, status, entryType, toAccount, fromAccount, null);
        Type localVarReturnType = new TypeToken<List<Journal>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getAllJournalsAsync(LocalDate after, LocalDate before, String status, String entryType, UUID toAccount, UUID fromAccount, ApiCallback<List<Journal>> _callback) throws ApiException {
        Call localVarCall = this.getAllJournalsValidateBeforeCall(after, before, status, entryType, toAccount, fromAccount, _callback);
        Type localVarReturnType = new TypeToken<List<Journal>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call getV1JournalsJournalIdCall(UUID journalId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/journals/{journal_id}".replace("{journal_id}", this.localVarApiClient.escapeString(journalId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getV1JournalsJournalIdValidateBeforeCall(UUID journalId, ApiCallback _callback) throws ApiException {
        if (journalId == null) {
            throw new ApiException("Missing the required parameter 'journalId' when calling getV1JournalsJournalId(Async)");
        }
        return this.getV1JournalsJournalIdCall(journalId, _callback);
    }

    public Journal getV1JournalsJournalId(UUID journalId) throws ApiException {
        ApiResponse<Journal> localVarResp = this.getV1JournalsJournalIdWithHttpInfo(journalId);
        return localVarResp.getData();
    }

    protected ApiResponse<Journal> getV1JournalsJournalIdWithHttpInfo(UUID journalId) throws ApiException {
        Call localVarCall = this.getV1JournalsJournalIdValidateBeforeCall(journalId, null);
        Type localVarReturnType = new TypeToken<Journal>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getV1JournalsJournalIdAsync(UUID journalId, ApiCallback<Journal> _callback) throws ApiException {
        Call localVarCall = this.getV1JournalsJournalIdValidateBeforeCall(journalId, _callback);
        Type localVarReturnType = new TypeToken<Journal>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call postV1JournalsBatchReverseBatchCall(ReverseBatchJournalRequest reverseBatchJournalRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ReverseBatchJournalRequest localVarPostBody = reverseBatchJournalRequest;
        String localVarPath = "/v1/journals/batch/reverse_batch";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postV1JournalsBatchReverseBatchValidateBeforeCall(ReverseBatchJournalRequest reverseBatchJournalRequest, ApiCallback _callback) throws ApiException {
        return this.postV1JournalsBatchReverseBatchCall(reverseBatchJournalRequest, _callback);
    }

    public List<BatchJournalResponse> postV1JournalsBatchReverseBatch(ReverseBatchJournalRequest reverseBatchJournalRequest) throws ApiException {
        ApiResponse<List<BatchJournalResponse>> localVarResp = this.postV1JournalsBatchReverseBatchWithHttpInfo(reverseBatchJournalRequest);
        return localVarResp.getData();
    }

    protected ApiResponse<List<BatchJournalResponse>> postV1JournalsBatchReverseBatchWithHttpInfo(ReverseBatchJournalRequest reverseBatchJournalRequest) throws ApiException {
        Call localVarCall = this.postV1JournalsBatchReverseBatchValidateBeforeCall(reverseBatchJournalRequest, null);
        Type localVarReturnType = new TypeToken<List<BatchJournalResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call postV1JournalsBatchReverseBatchAsync(ReverseBatchJournalRequest reverseBatchJournalRequest, ApiCallback<List<BatchJournalResponse>> _callback) throws ApiException {
        Call localVarCall = this.postV1JournalsBatchReverseBatchValidateBeforeCall(reverseBatchJournalRequest, _callback);
        Type localVarReturnType = new TypeToken<List<BatchJournalResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

