/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.jacobpeterson.alpaca.openapi.broker.ApiCallback;
import net.jacobpeterson.alpaca.openapi.broker.ApiClient;
import net.jacobpeterson.alpaca.openapi.broker.ApiException;
import net.jacobpeterson.alpaca.openapi.broker.ApiResponse;
import net.jacobpeterson.alpaca.openapi.broker.Configuration;
import net.jacobpeterson.alpaca.openapi.broker.Pair;
import net.jacobpeterson.alpaca.openapi.broker.model.AuthorizeOAuthTokenResponse;
import net.jacobpeterson.alpaca.openapi.broker.model.IssueOAuthTokenResponse;
import net.jacobpeterson.alpaca.openapi.broker.model.OAuthTokenRequest;
import net.jacobpeterson.alpaca.openapi.broker.model.OathClientResponse;
import okhttp3.Call;

public class OAuthApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public OAuthApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OAuthApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    protected Call authorizeOAuthTokenCall(OAuthTokenRequest oauthTokenRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        OAuthTokenRequest localVarPostBody = oauthTokenRequest;
        String localVarPath = "/v1/oauth/authorize";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call authorizeOAuthTokenValidateBeforeCall(OAuthTokenRequest oauthTokenRequest, ApiCallback _callback) throws ApiException {
        if (oauthTokenRequest == null) {
            throw new ApiException("Missing the required parameter 'oauthTokenRequest' when calling authorizeOAuthToken(Async)");
        }
        return this.authorizeOAuthTokenCall(oauthTokenRequest, _callback);
    }

    public AuthorizeOAuthTokenResponse authorizeOAuthToken(OAuthTokenRequest oauthTokenRequest) throws ApiException {
        ApiResponse<AuthorizeOAuthTokenResponse> localVarResp = this.authorizeOAuthTokenWithHttpInfo(oauthTokenRequest);
        return localVarResp.getData();
    }

    protected ApiResponse<AuthorizeOAuthTokenResponse> authorizeOAuthTokenWithHttpInfo(OAuthTokenRequest oauthTokenRequest) throws ApiException {
        Call localVarCall = this.authorizeOAuthTokenValidateBeforeCall(oauthTokenRequest, null);
        Type localVarReturnType = new TypeToken<AuthorizeOAuthTokenResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call authorizeOAuthTokenAsync(OAuthTokenRequest oauthTokenRequest, ApiCallback<AuthorizeOAuthTokenResponse> _callback) throws ApiException {
        Call localVarCall = this.authorizeOAuthTokenValidateBeforeCall(oauthTokenRequest, _callback);
        Type localVarReturnType = new TypeToken<AuthorizeOAuthTokenResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call getOAuthClientCall(UUID clientId, String responseType, String redirectUri, String scope, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/oauth/clients/{client_id}".replace("{client_id}", this.localVarApiClient.escapeString(clientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (responseType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("response_type", responseType));
        }
        if (redirectUri != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("redirect_uri", redirectUri));
        }
        if (scope != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("scope", scope));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getOAuthClientValidateBeforeCall(UUID clientId, String responseType, String redirectUri, String scope, ApiCallback _callback) throws ApiException {
        if (clientId == null) {
            throw new ApiException("Missing the required parameter 'clientId' when calling getOAuthClient(Async)");
        }
        return this.getOAuthClientCall(clientId, responseType, redirectUri, scope, _callback);
    }

    public OathClientResponse getOAuthClient(UUID clientId, String responseType, String redirectUri, String scope) throws ApiException {
        ApiResponse<OathClientResponse> localVarResp = this.getOAuthClientWithHttpInfo(clientId, responseType, redirectUri, scope);
        return localVarResp.getData();
    }

    protected ApiResponse<OathClientResponse> getOAuthClientWithHttpInfo(UUID clientId, String responseType, String redirectUri, String scope) throws ApiException {
        Call localVarCall = this.getOAuthClientValidateBeforeCall(clientId, responseType, redirectUri, scope, null);
        Type localVarReturnType = new TypeToken<OathClientResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getOAuthClientAsync(UUID clientId, String responseType, String redirectUri, String scope, ApiCallback<OathClientResponse> _callback) throws ApiException {
        Call localVarCall = this.getOAuthClientValidateBeforeCall(clientId, responseType, redirectUri, scope, _callback);
        Type localVarReturnType = new TypeToken<OathClientResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call issueOAuthTokenCall(OAuthTokenRequest oauthTokenRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        OAuthTokenRequest localVarPostBody = oauthTokenRequest;
        String localVarPath = "/v1/oauth/token";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call issueOAuthTokenValidateBeforeCall(OAuthTokenRequest oauthTokenRequest, ApiCallback _callback) throws ApiException {
        if (oauthTokenRequest == null) {
            throw new ApiException("Missing the required parameter 'oauthTokenRequest' when calling issueOAuthToken(Async)");
        }
        return this.issueOAuthTokenCall(oauthTokenRequest, _callback);
    }

    public IssueOAuthTokenResponse issueOAuthToken(OAuthTokenRequest oauthTokenRequest) throws ApiException {
        ApiResponse<IssueOAuthTokenResponse> localVarResp = this.issueOAuthTokenWithHttpInfo(oauthTokenRequest);
        return localVarResp.getData();
    }

    protected ApiResponse<IssueOAuthTokenResponse> issueOAuthTokenWithHttpInfo(OAuthTokenRequest oauthTokenRequest) throws ApiException {
        Call localVarCall = this.issueOAuthTokenValidateBeforeCall(oauthTokenRequest, null);
        Type localVarReturnType = new TypeToken<IssueOAuthTokenResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call issueOAuthTokenAsync(OAuthTokenRequest oauthTokenRequest, ApiCallback<IssueOAuthTokenResponse> _callback) throws ApiException {
        Call localVarCall = this.issueOAuthTokenValidateBeforeCall(oauthTokenRequest, _callback);
        Type localVarReturnType = new TypeToken<IssueOAuthTokenResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

