/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.jacobpeterson.alpaca.openapi.broker.ApiCallback;
import net.jacobpeterson.alpaca.openapi.broker.ApiClient;
import net.jacobpeterson.alpaca.openapi.broker.ApiException;
import net.jacobpeterson.alpaca.openapi.broker.ApiResponse;
import net.jacobpeterson.alpaca.openapi.broker.Configuration;
import net.jacobpeterson.alpaca.openapi.broker.Pair;
import net.jacobpeterson.alpaca.openapi.broker.model.AggregatePositionResponse;
import net.jacobpeterson.alpaca.openapi.broker.model.GetV1ReportingEodPositions200Response;
import okhttp3.Call;

public class ReportingApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ReportingApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ReportingApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    protected Call getV1ReportingEodAggregatePositionsCall(LocalDate date, String symbols, String firmAccounts, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/reporting/eod/aggregate_positions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (date != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("date", date));
        }
        if (symbols != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbols", symbols));
        }
        if (firmAccounts != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("firm_accounts", firmAccounts));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getV1ReportingEodAggregatePositionsValidateBeforeCall(LocalDate date, String symbols, String firmAccounts, ApiCallback _callback) throws ApiException {
        if (date == null) {
            throw new ApiException("Missing the required parameter 'date' when calling getV1ReportingEodAggregatePositions(Async)");
        }
        return this.getV1ReportingEodAggregatePositionsCall(date, symbols, firmAccounts, _callback);
    }

    public List<AggregatePositionResponse> getV1ReportingEodAggregatePositions(LocalDate date, String symbols, String firmAccounts) throws ApiException {
        ApiResponse<List<AggregatePositionResponse>> localVarResp = this.getV1ReportingEodAggregatePositionsWithHttpInfo(date, symbols, firmAccounts);
        return localVarResp.getData();
    }

    protected ApiResponse<List<AggregatePositionResponse>> getV1ReportingEodAggregatePositionsWithHttpInfo(LocalDate date, String symbols, String firmAccounts) throws ApiException {
        Call localVarCall = this.getV1ReportingEodAggregatePositionsValidateBeforeCall(date, symbols, firmAccounts, null);
        Type localVarReturnType = new TypeToken<List<AggregatePositionResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getV1ReportingEodAggregatePositionsAsync(LocalDate date, String symbols, String firmAccounts, ApiCallback<List<AggregatePositionResponse>> _callback) throws ApiException {
        Call localVarCall = this.getV1ReportingEodAggregatePositionsValidateBeforeCall(date, symbols, firmAccounts, _callback);
        Type localVarReturnType = new TypeToken<List<AggregatePositionResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call getV1ReportingEodPositionsCall(UUID accountId, String asset, LocalDate asof, String pageToken, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/reporting/eod/positions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("account_id", accountId));
        }
        if (asset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("asset", asset));
        }
        if (asof != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("asof", asof));
        }
        if (pageToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_token", pageToken));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getV1ReportingEodPositionsValidateBeforeCall(UUID accountId, String asset, LocalDate asof, String pageToken, Integer limit, ApiCallback _callback) throws ApiException {
        return this.getV1ReportingEodPositionsCall(accountId, asset, asof, pageToken, limit, _callback);
    }

    public GetV1ReportingEodPositions200Response getV1ReportingEodPositions(UUID accountId, String asset, LocalDate asof, String pageToken, Integer limit) throws ApiException {
        ApiResponse<GetV1ReportingEodPositions200Response> localVarResp = this.getV1ReportingEodPositionsWithHttpInfo(accountId, asset, asof, pageToken, limit);
        return localVarResp.getData();
    }

    protected ApiResponse<GetV1ReportingEodPositions200Response> getV1ReportingEodPositionsWithHttpInfo(UUID accountId, String asset, LocalDate asof, String pageToken, Integer limit) throws ApiException {
        Call localVarCall = this.getV1ReportingEodPositionsValidateBeforeCall(accountId, asset, asof, pageToken, limit, null);
        Type localVarReturnType = new TypeToken<GetV1ReportingEodPositions200Response>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getV1ReportingEodPositionsAsync(UUID accountId, String asset, LocalDate asof, String pageToken, Integer limit, ApiCallback<GetV1ReportingEodPositions200Response> _callback) throws ApiException {
        Call localVarCall = this.getV1ReportingEodPositionsValidateBeforeCall(accountId, asset, asof, pageToken, limit, _callback);
        Type localVarReturnType = new TypeToken<GetV1ReportingEodPositions200Response>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

