/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.jacobpeterson.alpaca.openapi.broker.ApiCallback;
import net.jacobpeterson.alpaca.openapi.broker.ApiClient;
import net.jacobpeterson.alpaca.openapi.broker.ApiException;
import net.jacobpeterson.alpaca.openapi.broker.ApiResponse;
import net.jacobpeterson.alpaca.openapi.broker.Configuration;
import net.jacobpeterson.alpaca.openapi.broker.Pair;
import net.jacobpeterson.alpaca.openapi.broker.model.AccountConfigurations;
import net.jacobpeterson.alpaca.openapi.broker.model.CreateOrderRequest;
import net.jacobpeterson.alpaca.openapi.broker.model.GetV1AccountsPositions200Response;
import net.jacobpeterson.alpaca.openapi.broker.model.GetV1TradingAccountsAccountIdOrdersEstimationRequest;
import net.jacobpeterson.alpaca.openapi.broker.model.Order;
import net.jacobpeterson.alpaca.openapi.broker.model.OrderClosedResponse;
import net.jacobpeterson.alpaca.openapi.broker.model.PortfolioHistory;
import net.jacobpeterson.alpaca.openapi.broker.model.Position;
import net.jacobpeterson.alpaca.openapi.broker.model.PositionClosedResponse;
import net.jacobpeterson.alpaca.openapi.broker.model.TradeUpdateEventV2;
import net.jacobpeterson.alpaca.openapi.broker.model.UpdateOrderRequest;
import okhttp3.Call;

public class TradingApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public TradingApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TradingApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    protected Call closeAllPositionsForAccountCall(UUID accountId, Boolean cancelOrders, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/trading/accounts/{account_id}/positions".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (cancelOrders != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cancel_orders", cancelOrders));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call closeAllPositionsForAccountValidateBeforeCall(UUID accountId, Boolean cancelOrders, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling closeAllPositionsForAccount(Async)");
        }
        return this.closeAllPositionsForAccountCall(accountId, cancelOrders, _callback);
    }

    public List<PositionClosedResponse> closeAllPositionsForAccount(UUID accountId, Boolean cancelOrders) throws ApiException {
        ApiResponse<List<PositionClosedResponse>> localVarResp = this.closeAllPositionsForAccountWithHttpInfo(accountId, cancelOrders);
        return localVarResp.getData();
    }

    protected ApiResponse<List<PositionClosedResponse>> closeAllPositionsForAccountWithHttpInfo(UUID accountId, Boolean cancelOrders) throws ApiException {
        Call localVarCall = this.closeAllPositionsForAccountValidateBeforeCall(accountId, cancelOrders, null);
        Type localVarReturnType = new TypeToken<List<PositionClosedResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call closeAllPositionsForAccountAsync(UUID accountId, Boolean cancelOrders, ApiCallback<List<PositionClosedResponse>> _callback) throws ApiException {
        Call localVarCall = this.closeAllPositionsForAccountValidateBeforeCall(accountId, cancelOrders, _callback);
        Type localVarReturnType = new TypeToken<List<PositionClosedResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call closePositionForAccountBySymbolCall(UUID accountId, String symbolOrAssetId, String qty, String percentage, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/trading/accounts/{account_id}/positions/{symbol_or_asset_id}".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString())).replace("{symbol_or_asset_id}", this.localVarApiClient.escapeString(symbolOrAssetId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (qty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("qty", qty));
        }
        if (percentage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("percentage", percentage));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call closePositionForAccountBySymbolValidateBeforeCall(UUID accountId, String symbolOrAssetId, String qty, String percentage, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling closePositionForAccountBySymbol(Async)");
        }
        if (symbolOrAssetId == null) {
            throw new ApiException("Missing the required parameter 'symbolOrAssetId' when calling closePositionForAccountBySymbol(Async)");
        }
        return this.closePositionForAccountBySymbolCall(accountId, symbolOrAssetId, qty, percentage, _callback);
    }

    public Order closePositionForAccountBySymbol(UUID accountId, String symbolOrAssetId, String qty, String percentage) throws ApiException {
        ApiResponse<Order> localVarResp = this.closePositionForAccountBySymbolWithHttpInfo(accountId, symbolOrAssetId, qty, percentage);
        return localVarResp.getData();
    }

    protected ApiResponse<Order> closePositionForAccountBySymbolWithHttpInfo(UUID accountId, String symbolOrAssetId, String qty, String percentage) throws ApiException {
        Call localVarCall = this.closePositionForAccountBySymbolValidateBeforeCall(accountId, symbolOrAssetId, qty, percentage, null);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call closePositionForAccountBySymbolAsync(UUID accountId, String symbolOrAssetId, String qty, String percentage, ApiCallback<Order> _callback) throws ApiException {
        Call localVarCall = this.closePositionForAccountBySymbolValidateBeforeCall(accountId, symbolOrAssetId, qty, percentage, _callback);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call createOrderForAccountCall(UUID accountId, CreateOrderRequest createOrderRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateOrderRequest localVarPostBody = createOrderRequest;
        String localVarPath = "/v1/trading/accounts/{account_id}/orders".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createOrderForAccountValidateBeforeCall(UUID accountId, CreateOrderRequest createOrderRequest, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling createOrderForAccount(Async)");
        }
        if (createOrderRequest == null) {
            throw new ApiException("Missing the required parameter 'createOrderRequest' when calling createOrderForAccount(Async)");
        }
        return this.createOrderForAccountCall(accountId, createOrderRequest, _callback);
    }

    public Order createOrderForAccount(UUID accountId, CreateOrderRequest createOrderRequest) throws ApiException {
        ApiResponse<Order> localVarResp = this.createOrderForAccountWithHttpInfo(accountId, createOrderRequest);
        return localVarResp.getData();
    }

    protected ApiResponse<Order> createOrderForAccountWithHttpInfo(UUID accountId, CreateOrderRequest createOrderRequest) throws ApiException {
        Call localVarCall = this.createOrderForAccountValidateBeforeCall(accountId, createOrderRequest, null);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call createOrderForAccountAsync(UUID accountId, CreateOrderRequest createOrderRequest, ApiCallback<Order> _callback) throws ApiException {
        Call localVarCall = this.createOrderForAccountValidateBeforeCall(accountId, createOrderRequest, _callback);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call deleteAllOrdersForAccountCall(UUID accountId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/trading/accounts/{account_id}/orders".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteAllOrdersForAccountValidateBeforeCall(UUID accountId, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling deleteAllOrdersForAccount(Async)");
        }
        return this.deleteAllOrdersForAccountCall(accountId, _callback);
    }

    public List<OrderClosedResponse> deleteAllOrdersForAccount(UUID accountId) throws ApiException {
        ApiResponse<List<OrderClosedResponse>> localVarResp = this.deleteAllOrdersForAccountWithHttpInfo(accountId);
        return localVarResp.getData();
    }

    protected ApiResponse<List<OrderClosedResponse>> deleteAllOrdersForAccountWithHttpInfo(UUID accountId) throws ApiException {
        Call localVarCall = this.deleteAllOrdersForAccountValidateBeforeCall(accountId, null);
        Type localVarReturnType = new TypeToken<List<OrderClosedResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call deleteAllOrdersForAccountAsync(UUID accountId, ApiCallback<List<OrderClosedResponse>> _callback) throws ApiException {
        Call localVarCall = this.deleteAllOrdersForAccountValidateBeforeCall(accountId, _callback);
        Type localVarReturnType = new TypeToken<List<OrderClosedResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call deleteOrderForAccountCall(UUID accountId, String orderId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/trading/accounts/{account_id}/orders/{order_id}".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString())).replace("{order_id}", this.localVarApiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteOrderForAccountValidateBeforeCall(UUID accountId, String orderId, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling deleteOrderForAccount(Async)");
        }
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling deleteOrderForAccount(Async)");
        }
        return this.deleteOrderForAccountCall(accountId, orderId, _callback);
    }

    public void deleteOrderForAccount(UUID accountId, String orderId) throws ApiException {
        this.deleteOrderForAccountWithHttpInfo(accountId, orderId);
    }

    protected ApiResponse<Void> deleteOrderForAccountWithHttpInfo(UUID accountId, String orderId) throws ApiException {
        Call localVarCall = this.deleteOrderForAccountValidateBeforeCall(accountId, orderId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    protected Call deleteOrderForAccountAsync(UUID accountId, String orderId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteOrderForAccountValidateBeforeCall(accountId, orderId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    protected Call getAllOrdersForAccountCall(UUID accountId, String status, Integer limit, OffsetDateTime after, OffsetDateTime until, String direction, Boolean nested, String symbols, String qtyAbove, String qtyBelow, String subtag, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/trading/accounts/{account_id}/orders".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (status != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("status", status));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (until != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("until", until));
        }
        if (direction != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("direction", direction));
        }
        if (nested != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("nested", nested));
        }
        if (symbols != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbols", symbols));
        }
        if (qtyAbove != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("qty_above", qtyAbove));
        }
        if (qtyBelow != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("qty_below", qtyBelow));
        }
        if (subtag != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("subtag", subtag));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAllOrdersForAccountValidateBeforeCall(UUID accountId, String status, Integer limit, OffsetDateTime after, OffsetDateTime until, String direction, Boolean nested, String symbols, String qtyAbove, String qtyBelow, String subtag, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getAllOrdersForAccount(Async)");
        }
        return this.getAllOrdersForAccountCall(accountId, status, limit, after, until, direction, nested, symbols, qtyAbove, qtyBelow, subtag, _callback);
    }

    public List<Order> getAllOrdersForAccount(UUID accountId, String status, Integer limit, OffsetDateTime after, OffsetDateTime until, String direction, Boolean nested, String symbols, String qtyAbove, String qtyBelow, String subtag) throws ApiException {
        ApiResponse<List<Order>> localVarResp = this.getAllOrdersForAccountWithHttpInfo(accountId, status, limit, after, until, direction, nested, symbols, qtyAbove, qtyBelow, subtag);
        return localVarResp.getData();
    }

    protected ApiResponse<List<Order>> getAllOrdersForAccountWithHttpInfo(UUID accountId, String status, Integer limit, OffsetDateTime after, OffsetDateTime until, String direction, Boolean nested, String symbols, String qtyAbove, String qtyBelow, String subtag) throws ApiException {
        Call localVarCall = this.getAllOrdersForAccountValidateBeforeCall(accountId, status, limit, after, until, direction, nested, symbols, qtyAbove, qtyBelow, subtag, null);
        Type localVarReturnType = new TypeToken<List<Order>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getAllOrdersForAccountAsync(UUID accountId, String status, Integer limit, OffsetDateTime after, OffsetDateTime until, String direction, Boolean nested, String symbols, String qtyAbove, String qtyBelow, String subtag, ApiCallback<List<Order>> _callback) throws ApiException {
        Call localVarCall = this.getAllOrdersForAccountValidateBeforeCall(accountId, status, limit, after, until, direction, nested, symbols, qtyAbove, qtyBelow, subtag, _callback);
        Type localVarReturnType = new TypeToken<List<Order>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call getOrderForAccountCall(UUID accountId, String orderId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/trading/accounts/{account_id}/orders/{order_id}".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString())).replace("{order_id}", this.localVarApiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getOrderForAccountValidateBeforeCall(UUID accountId, String orderId, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getOrderForAccount(Async)");
        }
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling getOrderForAccount(Async)");
        }
        return this.getOrderForAccountCall(accountId, orderId, _callback);
    }

    public Order getOrderForAccount(UUID accountId, String orderId) throws ApiException {
        ApiResponse<Order> localVarResp = this.getOrderForAccountWithHttpInfo(accountId, orderId);
        return localVarResp.getData();
    }

    protected ApiResponse<Order> getOrderForAccountWithHttpInfo(UUID accountId, String orderId) throws ApiException {
        Call localVarCall = this.getOrderForAccountValidateBeforeCall(accountId, orderId, null);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getOrderForAccountAsync(UUID accountId, String orderId, ApiCallback<Order> _callback) throws ApiException {
        Call localVarCall = this.getOrderForAccountValidateBeforeCall(accountId, orderId, _callback);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call getPositionsForAccountCall(UUID accountId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/trading/accounts/{account_id}/positions".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPositionsForAccountValidateBeforeCall(UUID accountId, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getPositionsForAccount(Async)");
        }
        return this.getPositionsForAccountCall(accountId, _callback);
    }

    public List<Position> getPositionsForAccount(UUID accountId) throws ApiException {
        ApiResponse<List<Position>> localVarResp = this.getPositionsForAccountWithHttpInfo(accountId);
        return localVarResp.getData();
    }

    protected ApiResponse<List<Position>> getPositionsForAccountWithHttpInfo(UUID accountId) throws ApiException {
        Call localVarCall = this.getPositionsForAccountValidateBeforeCall(accountId, null);
        Type localVarReturnType = new TypeToken<List<Position>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getPositionsForAccountAsync(UUID accountId, ApiCallback<List<Position>> _callback) throws ApiException {
        Call localVarCall = this.getPositionsForAccountValidateBeforeCall(accountId, _callback);
        Type localVarReturnType = new TypeToken<List<Position>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call getPositionsForAccountBySymbolCall(UUID accountId, String symbolOrAssetId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/trading/accounts/{account_id}/positions/{symbol_or_asset_id}".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString())).replace("{symbol_or_asset_id}", this.localVarApiClient.escapeString(symbolOrAssetId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPositionsForAccountBySymbolValidateBeforeCall(UUID accountId, String symbolOrAssetId, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getPositionsForAccountBySymbol(Async)");
        }
        if (symbolOrAssetId == null) {
            throw new ApiException("Missing the required parameter 'symbolOrAssetId' when calling getPositionsForAccountBySymbol(Async)");
        }
        return this.getPositionsForAccountBySymbolCall(accountId, symbolOrAssetId, _callback);
    }

    public Position getPositionsForAccountBySymbol(UUID accountId, String symbolOrAssetId) throws ApiException {
        ApiResponse<Position> localVarResp = this.getPositionsForAccountBySymbolWithHttpInfo(accountId, symbolOrAssetId);
        return localVarResp.getData();
    }

    protected ApiResponse<Position> getPositionsForAccountBySymbolWithHttpInfo(UUID accountId, String symbolOrAssetId) throws ApiException {
        Call localVarCall = this.getPositionsForAccountBySymbolValidateBeforeCall(accountId, symbolOrAssetId, null);
        Type localVarReturnType = new TypeToken<Position>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getPositionsForAccountBySymbolAsync(UUID accountId, String symbolOrAssetId, ApiCallback<Position> _callback) throws ApiException {
        Call localVarCall = this.getPositionsForAccountBySymbolValidateBeforeCall(accountId, symbolOrAssetId, _callback);
        Type localVarReturnType = new TypeToken<Position>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    protected Call getV1AccountsPositionsCall(Integer page, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/accounts/positions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @Deprecated
    private Call getV1AccountsPositionsValidateBeforeCall(Integer page, ApiCallback _callback) throws ApiException {
        return this.getV1AccountsPositionsCall(page, _callback);
    }

    @Deprecated
    public GetV1AccountsPositions200Response getV1AccountsPositions(Integer page) throws ApiException {
        ApiResponse<GetV1AccountsPositions200Response> localVarResp = this.getV1AccountsPositionsWithHttpInfo(page);
        return localVarResp.getData();
    }

    @Deprecated
    protected ApiResponse<GetV1AccountsPositions200Response> getV1AccountsPositionsWithHttpInfo(Integer page) throws ApiException {
        Call localVarCall = this.getV1AccountsPositionsValidateBeforeCall(page, null);
        Type localVarReturnType = new TypeToken<GetV1AccountsPositions200Response>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    @Deprecated
    protected Call getV1AccountsPositionsAsync(Integer page, ApiCallback<GetV1AccountsPositions200Response> _callback) throws ApiException {
        Call localVarCall = this.getV1AccountsPositionsValidateBeforeCall(page, _callback);
        Type localVarReturnType = new TypeToken<GetV1AccountsPositions200Response>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call getV1TradingAccountsAccountIdAccountPortfolioHistoryCall(String accountId, String period, String timeframe, String intradayReporting, OffsetDateTime start, String pnlReset, OffsetDateTime end, LocalDate dateEnd, String extendedHours, String forceEngineVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/trading/accounts/{account_id}/account/portfolio/history".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (period != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("period", period));
        }
        if (timeframe != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeframe", timeframe));
        }
        if (intradayReporting != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("intraday_reporting", intradayReporting));
        }
        if (start != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start", start));
        }
        if (pnlReset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pnl_reset", pnlReset));
        }
        if (end != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end", end));
        }
        if (dateEnd != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("date_end", dateEnd));
        }
        if (extendedHours != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("extended_hours", extendedHours));
        }
        if (forceEngineVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force_engine_version", forceEngineVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getV1TradingAccountsAccountIdAccountPortfolioHistoryValidateBeforeCall(String accountId, String period, String timeframe, String intradayReporting, OffsetDateTime start, String pnlReset, OffsetDateTime end, LocalDate dateEnd, String extendedHours, String forceEngineVersion, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getV1TradingAccountsAccountIdAccountPortfolioHistory(Async)");
        }
        return this.getV1TradingAccountsAccountIdAccountPortfolioHistoryCall(accountId, period, timeframe, intradayReporting, start, pnlReset, end, dateEnd, extendedHours, forceEngineVersion, _callback);
    }

    public PortfolioHistory getV1TradingAccountsAccountIdAccountPortfolioHistory(String accountId, String period, String timeframe, String intradayReporting, OffsetDateTime start, String pnlReset, OffsetDateTime end, LocalDate dateEnd, String extendedHours, String forceEngineVersion) throws ApiException {
        ApiResponse<PortfolioHistory> localVarResp = this.getV1TradingAccountsAccountIdAccountPortfolioHistoryWithHttpInfo(accountId, period, timeframe, intradayReporting, start, pnlReset, end, dateEnd, extendedHours, forceEngineVersion);
        return localVarResp.getData();
    }

    protected ApiResponse<PortfolioHistory> getV1TradingAccountsAccountIdAccountPortfolioHistoryWithHttpInfo(String accountId, String period, String timeframe, String intradayReporting, OffsetDateTime start, String pnlReset, OffsetDateTime end, LocalDate dateEnd, String extendedHours, String forceEngineVersion) throws ApiException {
        Call localVarCall = this.getV1TradingAccountsAccountIdAccountPortfolioHistoryValidateBeforeCall(accountId, period, timeframe, intradayReporting, start, pnlReset, end, dateEnd, extendedHours, forceEngineVersion, null);
        Type localVarReturnType = new TypeToken<PortfolioHistory>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getV1TradingAccountsAccountIdAccountPortfolioHistoryAsync(String accountId, String period, String timeframe, String intradayReporting, OffsetDateTime start, String pnlReset, OffsetDateTime end, LocalDate dateEnd, String extendedHours, String forceEngineVersion, ApiCallback<PortfolioHistory> _callback) throws ApiException {
        Call localVarCall = this.getV1TradingAccountsAccountIdAccountPortfolioHistoryValidateBeforeCall(accountId, period, timeframe, intradayReporting, start, pnlReset, end, dateEnd, extendedHours, forceEngineVersion, _callback);
        Type localVarReturnType = new TypeToken<PortfolioHistory>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call getV1TradingAccountsAccountIdOrdersEstimationCall(String accountId, GetV1TradingAccountsAccountIdOrdersEstimationRequest getV1TradingAccountsAccountIdOrdersEstimationRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        GetV1TradingAccountsAccountIdOrdersEstimationRequest localVarPostBody = getV1TradingAccountsAccountIdOrdersEstimationRequest;
        String localVarPath = "/v1/trading/accounts/{account_id}/orders/estimation".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getV1TradingAccountsAccountIdOrdersEstimationValidateBeforeCall(String accountId, GetV1TradingAccountsAccountIdOrdersEstimationRequest getV1TradingAccountsAccountIdOrdersEstimationRequest, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getV1TradingAccountsAccountIdOrdersEstimation(Async)");
        }
        return this.getV1TradingAccountsAccountIdOrdersEstimationCall(accountId, getV1TradingAccountsAccountIdOrdersEstimationRequest, _callback);
    }

    public Order getV1TradingAccountsAccountIdOrdersEstimation(String accountId, GetV1TradingAccountsAccountIdOrdersEstimationRequest getV1TradingAccountsAccountIdOrdersEstimationRequest) throws ApiException {
        ApiResponse<Order> localVarResp = this.getV1TradingAccountsAccountIdOrdersEstimationWithHttpInfo(accountId, getV1TradingAccountsAccountIdOrdersEstimationRequest);
        return localVarResp.getData();
    }

    protected ApiResponse<Order> getV1TradingAccountsAccountIdOrdersEstimationWithHttpInfo(String accountId, GetV1TradingAccountsAccountIdOrdersEstimationRequest getV1TradingAccountsAccountIdOrdersEstimationRequest) throws ApiException {
        Call localVarCall = this.getV1TradingAccountsAccountIdOrdersEstimationValidateBeforeCall(accountId, getV1TradingAccountsAccountIdOrdersEstimationRequest, null);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getV1TradingAccountsAccountIdOrdersEstimationAsync(String accountId, GetV1TradingAccountsAccountIdOrdersEstimationRequest getV1TradingAccountsAccountIdOrdersEstimationRequest, ApiCallback<Order> _callback) throws ApiException {
        Call localVarCall = this.getV1TradingAccountsAccountIdOrdersEstimationValidateBeforeCall(accountId, getV1TradingAccountsAccountIdOrdersEstimationRequest, _callback);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call optionExerciseCall(UUID accountId, UUID symbolOrContractId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/trading/accounts/{account_id}/positions/{symbol_or_contract_id}/exercise".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString())).replace("{symbol_or_contract_id}", this.localVarApiClient.escapeString(symbolOrContractId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call optionExerciseValidateBeforeCall(UUID accountId, UUID symbolOrContractId, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling optionExercise(Async)");
        }
        if (symbolOrContractId == null) {
            throw new ApiException("Missing the required parameter 'symbolOrContractId' when calling optionExercise(Async)");
        }
        return this.optionExerciseCall(accountId, symbolOrContractId, _callback);
    }

    public void optionExercise(UUID accountId, UUID symbolOrContractId) throws ApiException {
        this.optionExerciseWithHttpInfo(accountId, symbolOrContractId);
    }

    protected ApiResponse<Void> optionExerciseWithHttpInfo(UUID accountId, UUID symbolOrContractId) throws ApiException {
        Call localVarCall = this.optionExerciseValidateBeforeCall(accountId, symbolOrContractId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    protected Call optionExerciseAsync(UUID accountId, UUID symbolOrContractId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.optionExerciseValidateBeforeCall(accountId, symbolOrContractId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    protected Call patchPATCHV1TradingAccountsAccountIdAccountConfigurationsCall(String accountId, AccountConfigurations accountConfigurations, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AccountConfigurations localVarPostBody = accountConfigurations;
        String localVarPath = "/v1/trading/accounts/{account_id}/account/configurations".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchPATCHV1TradingAccountsAccountIdAccountConfigurationsValidateBeforeCall(String accountId, AccountConfigurations accountConfigurations, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling patchPATCHV1TradingAccountsAccountIdAccountConfigurations(Async)");
        }
        return this.patchPATCHV1TradingAccountsAccountIdAccountConfigurationsCall(accountId, accountConfigurations, _callback);
    }

    public AccountConfigurations patchPATCHV1TradingAccountsAccountIdAccountConfigurations(String accountId, AccountConfigurations accountConfigurations) throws ApiException {
        ApiResponse<AccountConfigurations> localVarResp = this.patchPATCHV1TradingAccountsAccountIdAccountConfigurationsWithHttpInfo(accountId, accountConfigurations);
        return localVarResp.getData();
    }

    protected ApiResponse<AccountConfigurations> patchPATCHV1TradingAccountsAccountIdAccountConfigurationsWithHttpInfo(String accountId, AccountConfigurations accountConfigurations) throws ApiException {
        Call localVarCall = this.patchPATCHV1TradingAccountsAccountIdAccountConfigurationsValidateBeforeCall(accountId, accountConfigurations, null);
        Type localVarReturnType = new TypeToken<AccountConfigurations>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call patchPATCHV1TradingAccountsAccountIdAccountConfigurationsAsync(String accountId, AccountConfigurations accountConfigurations, ApiCallback<AccountConfigurations> _callback) throws ApiException {
        Call localVarCall = this.patchPATCHV1TradingAccountsAccountIdAccountConfigurationsValidateBeforeCall(accountId, accountConfigurations, _callback);
        Type localVarReturnType = new TypeToken<AccountConfigurations>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call replaceOrderForAccountCall(UUID accountId, String orderId, UpdateOrderRequest updateOrderRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateOrderRequest localVarPostBody = updateOrderRequest;
        String localVarPath = "/v1/trading/accounts/{account_id}/orders/{order_id}".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString())).replace("{order_id}", this.localVarApiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceOrderForAccountValidateBeforeCall(UUID accountId, String orderId, UpdateOrderRequest updateOrderRequest, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling replaceOrderForAccount(Async)");
        }
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling replaceOrderForAccount(Async)");
        }
        if (updateOrderRequest == null) {
            throw new ApiException("Missing the required parameter 'updateOrderRequest' when calling replaceOrderForAccount(Async)");
        }
        return this.replaceOrderForAccountCall(accountId, orderId, updateOrderRequest, _callback);
    }

    public Order replaceOrderForAccount(UUID accountId, String orderId, UpdateOrderRequest updateOrderRequest) throws ApiException {
        ApiResponse<Order> localVarResp = this.replaceOrderForAccountWithHttpInfo(accountId, orderId, updateOrderRequest);
        return localVarResp.getData();
    }

    protected ApiResponse<Order> replaceOrderForAccountWithHttpInfo(UUID accountId, String orderId, UpdateOrderRequest updateOrderRequest) throws ApiException {
        Call localVarCall = this.replaceOrderForAccountValidateBeforeCall(accountId, orderId, updateOrderRequest, null);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call replaceOrderForAccountAsync(UUID accountId, String orderId, UpdateOrderRequest updateOrderRequest, ApiCallback<Order> _callback) throws ApiException {
        Call localVarCall = this.replaceOrderForAccountValidateBeforeCall(accountId, orderId, updateOrderRequest, _callback);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call subscribeToTradeV2SSECall(OffsetDateTime since, OffsetDateTime until, String sinceId, String untilId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2beta1/events/trades";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (since != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("since", since));
        }
        if (until != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("until", until));
        }
        if (sinceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("since_id", sinceId));
        }
        if (untilId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("until_id", untilId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"text/event-stream"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call subscribeToTradeV2SSEValidateBeforeCall(OffsetDateTime since, OffsetDateTime until, String sinceId, String untilId, ApiCallback _callback) throws ApiException {
        return this.subscribeToTradeV2SSECall(since, until, sinceId, untilId, _callback);
    }

    public List<TradeUpdateEventV2> subscribeToTradeV2SSE(OffsetDateTime since, OffsetDateTime until, String sinceId, String untilId) throws ApiException {
        ApiResponse<List<TradeUpdateEventV2>> localVarResp = this.subscribeToTradeV2SSEWithHttpInfo(since, until, sinceId, untilId);
        return localVarResp.getData();
    }

    protected ApiResponse<List<TradeUpdateEventV2>> subscribeToTradeV2SSEWithHttpInfo(OffsetDateTime since, OffsetDateTime until, String sinceId, String untilId) throws ApiException {
        Call localVarCall = this.subscribeToTradeV2SSEValidateBeforeCall(since, until, sinceId, untilId, null);
        Type localVarReturnType = new TypeToken<List<TradeUpdateEventV2>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call subscribeToTradeV2SSEAsync(OffsetDateTime since, OffsetDateTime until, String sinceId, String untilId, ApiCallback<List<TradeUpdateEventV2>> _callback) throws ApiException {
        Call localVarCall = this.subscribeToTradeV2SSEValidateBeforeCall(since, until, sinceId, untilId, _callback);
        Type localVarReturnType = new TypeToken<List<TradeUpdateEventV2>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

