/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.jacobpeterson.alpaca.openapi.broker.ApiCallback;
import net.jacobpeterson.alpaca.openapi.broker.ApiClient;
import net.jacobpeterson.alpaca.openapi.broker.ApiException;
import net.jacobpeterson.alpaca.openapi.broker.ApiResponse;
import net.jacobpeterson.alpaca.openapi.broker.Configuration;
import net.jacobpeterson.alpaca.openapi.broker.Pair;
import net.jacobpeterson.alpaca.openapi.broker.model.CreateWatchlistRequest;
import net.jacobpeterson.alpaca.openapi.broker.model.PostV1TradingAccountsAccountIdWatchlistsWatchlistIdRequest;
import net.jacobpeterson.alpaca.openapi.broker.model.Watchlist;
import okhttp3.Call;

public class WatchlistApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public WatchlistApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WatchlistApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    protected Call createWatchlistForAccountCall(UUID accountId, CreateWatchlistRequest createWatchlistRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateWatchlistRequest localVarPostBody = createWatchlistRequest;
        String localVarPath = "/v1/trading/accounts/{account_id}/watchlists".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createWatchlistForAccountValidateBeforeCall(UUID accountId, CreateWatchlistRequest createWatchlistRequest, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling createWatchlistForAccount(Async)");
        }
        return this.createWatchlistForAccountCall(accountId, createWatchlistRequest, _callback);
    }

    public Watchlist createWatchlistForAccount(UUID accountId, CreateWatchlistRequest createWatchlistRequest) throws ApiException {
        ApiResponse<Watchlist> localVarResp = this.createWatchlistForAccountWithHttpInfo(accountId, createWatchlistRequest);
        return localVarResp.getData();
    }

    protected ApiResponse<Watchlist> createWatchlistForAccountWithHttpInfo(UUID accountId, CreateWatchlistRequest createWatchlistRequest) throws ApiException {
        Call localVarCall = this.createWatchlistForAccountValidateBeforeCall(accountId, createWatchlistRequest, null);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call createWatchlistForAccountAsync(UUID accountId, CreateWatchlistRequest createWatchlistRequest, ApiCallback<Watchlist> _callback) throws ApiException {
        Call localVarCall = this.createWatchlistForAccountValidateBeforeCall(accountId, createWatchlistRequest, _callback);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call deleteDELETEV1TradingAccountsAccountIdWatchlistsWatchlistIdSymbolCall(String accountId, String watchlistId, String symbol, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/trading/accounts/{account_id}/watchlists/{watchlist_id}/{symbol}".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString())).replace("{watchlist_id}", this.localVarApiClient.escapeString(watchlistId.toString())).replace("{symbol}", this.localVarApiClient.escapeString(symbol.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteDELETEV1TradingAccountsAccountIdWatchlistsWatchlistIdSymbolValidateBeforeCall(String accountId, String watchlistId, String symbol, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling deleteDELETEV1TradingAccountsAccountIdWatchlistsWatchlistIdSymbol(Async)");
        }
        if (watchlistId == null) {
            throw new ApiException("Missing the required parameter 'watchlistId' when calling deleteDELETEV1TradingAccountsAccountIdWatchlistsWatchlistIdSymbol(Async)");
        }
        if (symbol == null) {
            throw new ApiException("Missing the required parameter 'symbol' when calling deleteDELETEV1TradingAccountsAccountIdWatchlistsWatchlistIdSymbol(Async)");
        }
        return this.deleteDELETEV1TradingAccountsAccountIdWatchlistsWatchlistIdSymbolCall(accountId, watchlistId, symbol, _callback);
    }

    public void deleteDELETEV1TradingAccountsAccountIdWatchlistsWatchlistIdSymbol(String accountId, String watchlistId, String symbol) throws ApiException {
        this.deleteDELETEV1TradingAccountsAccountIdWatchlistsWatchlistIdSymbolWithHttpInfo(accountId, watchlistId, symbol);
    }

    protected ApiResponse<Void> deleteDELETEV1TradingAccountsAccountIdWatchlistsWatchlistIdSymbolWithHttpInfo(String accountId, String watchlistId, String symbol) throws ApiException {
        Call localVarCall = this.deleteDELETEV1TradingAccountsAccountIdWatchlistsWatchlistIdSymbolValidateBeforeCall(accountId, watchlistId, symbol, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    protected Call deleteDELETEV1TradingAccountsAccountIdWatchlistsWatchlistIdSymbolAsync(String accountId, String watchlistId, String symbol, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteDELETEV1TradingAccountsAccountIdWatchlistsWatchlistIdSymbolValidateBeforeCall(accountId, watchlistId, symbol, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    protected Call deleteWatchlistFromAccountByIdCall(UUID accountId, UUID watchlistId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/trading/accounts/{account_id}/watchlists/{watchlist_id}".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString())).replace("{watchlist_id}", this.localVarApiClient.escapeString(watchlistId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteWatchlistFromAccountByIdValidateBeforeCall(UUID accountId, UUID watchlistId, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling deleteWatchlistFromAccountById(Async)");
        }
        if (watchlistId == null) {
            throw new ApiException("Missing the required parameter 'watchlistId' when calling deleteWatchlistFromAccountById(Async)");
        }
        return this.deleteWatchlistFromAccountByIdCall(accountId, watchlistId, _callback);
    }

    public void deleteWatchlistFromAccountById(UUID accountId, UUID watchlistId) throws ApiException {
        this.deleteWatchlistFromAccountByIdWithHttpInfo(accountId, watchlistId);
    }

    protected ApiResponse<Void> deleteWatchlistFromAccountByIdWithHttpInfo(UUID accountId, UUID watchlistId) throws ApiException {
        Call localVarCall = this.deleteWatchlistFromAccountByIdValidateBeforeCall(accountId, watchlistId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    protected Call deleteWatchlistFromAccountByIdAsync(UUID accountId, UUID watchlistId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteWatchlistFromAccountByIdValidateBeforeCall(accountId, watchlistId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    protected Call getAllWatchlistsForAccountCall(UUID accountId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/trading/accounts/{account_id}/watchlists".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAllWatchlistsForAccountValidateBeforeCall(UUID accountId, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getAllWatchlistsForAccount(Async)");
        }
        return this.getAllWatchlistsForAccountCall(accountId, _callback);
    }

    public List<Watchlist> getAllWatchlistsForAccount(UUID accountId) throws ApiException {
        ApiResponse<List<Watchlist>> localVarResp = this.getAllWatchlistsForAccountWithHttpInfo(accountId);
        return localVarResp.getData();
    }

    protected ApiResponse<List<Watchlist>> getAllWatchlistsForAccountWithHttpInfo(UUID accountId) throws ApiException {
        Call localVarCall = this.getAllWatchlistsForAccountValidateBeforeCall(accountId, null);
        Type localVarReturnType = new TypeToken<List<Watchlist>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getAllWatchlistsForAccountAsync(UUID accountId, ApiCallback<List<Watchlist>> _callback) throws ApiException {
        Call localVarCall = this.getAllWatchlistsForAccountValidateBeforeCall(accountId, _callback);
        Type localVarReturnType = new TypeToken<List<Watchlist>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call getWatchlistForAccountByIdCall(UUID accountId, UUID watchlistId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/trading/accounts/{account_id}/watchlists/{watchlist_id}".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString())).replace("{watchlist_id}", this.localVarApiClient.escapeString(watchlistId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getWatchlistForAccountByIdValidateBeforeCall(UUID accountId, UUID watchlistId, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getWatchlistForAccountById(Async)");
        }
        if (watchlistId == null) {
            throw new ApiException("Missing the required parameter 'watchlistId' when calling getWatchlistForAccountById(Async)");
        }
        return this.getWatchlistForAccountByIdCall(accountId, watchlistId, _callback);
    }

    public Watchlist getWatchlistForAccountById(UUID accountId, UUID watchlistId) throws ApiException {
        ApiResponse<Watchlist> localVarResp = this.getWatchlistForAccountByIdWithHttpInfo(accountId, watchlistId);
        return localVarResp.getData();
    }

    protected ApiResponse<Watchlist> getWatchlistForAccountByIdWithHttpInfo(UUID accountId, UUID watchlistId) throws ApiException {
        Call localVarCall = this.getWatchlistForAccountByIdValidateBeforeCall(accountId, watchlistId, null);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getWatchlistForAccountByIdAsync(UUID accountId, UUID watchlistId, ApiCallback<Watchlist> _callback) throws ApiException {
        Call localVarCall = this.getWatchlistForAccountByIdValidateBeforeCall(accountId, watchlistId, _callback);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call postV1TradingAccountsAccountIdWatchlistsWatchlistIdCall(UUID accountId, UUID watchlistId, PostV1TradingAccountsAccountIdWatchlistsWatchlistIdRequest postV1TradingAccountsAccountIdWatchlistsWatchlistIdRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PostV1TradingAccountsAccountIdWatchlistsWatchlistIdRequest localVarPostBody = postV1TradingAccountsAccountIdWatchlistsWatchlistIdRequest;
        String localVarPath = "/v1/trading/accounts/{account_id}/watchlists/{watchlist_id}".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString())).replace("{watchlist_id}", this.localVarApiClient.escapeString(watchlistId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postV1TradingAccountsAccountIdWatchlistsWatchlistIdValidateBeforeCall(UUID accountId, UUID watchlistId, PostV1TradingAccountsAccountIdWatchlistsWatchlistIdRequest postV1TradingAccountsAccountIdWatchlistsWatchlistIdRequest, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling postV1TradingAccountsAccountIdWatchlistsWatchlistId(Async)");
        }
        if (watchlistId == null) {
            throw new ApiException("Missing the required parameter 'watchlistId' when calling postV1TradingAccountsAccountIdWatchlistsWatchlistId(Async)");
        }
        return this.postV1TradingAccountsAccountIdWatchlistsWatchlistIdCall(accountId, watchlistId, postV1TradingAccountsAccountIdWatchlistsWatchlistIdRequest, _callback);
    }

    public Watchlist postV1TradingAccountsAccountIdWatchlistsWatchlistId(UUID accountId, UUID watchlistId, PostV1TradingAccountsAccountIdWatchlistsWatchlistIdRequest postV1TradingAccountsAccountIdWatchlistsWatchlistIdRequest) throws ApiException {
        ApiResponse<Watchlist> localVarResp = this.postV1TradingAccountsAccountIdWatchlistsWatchlistIdWithHttpInfo(accountId, watchlistId, postV1TradingAccountsAccountIdWatchlistsWatchlistIdRequest);
        return localVarResp.getData();
    }

    protected ApiResponse<Watchlist> postV1TradingAccountsAccountIdWatchlistsWatchlistIdWithHttpInfo(UUID accountId, UUID watchlistId, PostV1TradingAccountsAccountIdWatchlistsWatchlistIdRequest postV1TradingAccountsAccountIdWatchlistsWatchlistIdRequest) throws ApiException {
        Call localVarCall = this.postV1TradingAccountsAccountIdWatchlistsWatchlistIdValidateBeforeCall(accountId, watchlistId, postV1TradingAccountsAccountIdWatchlistsWatchlistIdRequest, null);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call postV1TradingAccountsAccountIdWatchlistsWatchlistIdAsync(UUID accountId, UUID watchlistId, PostV1TradingAccountsAccountIdWatchlistsWatchlistIdRequest postV1TradingAccountsAccountIdWatchlistsWatchlistIdRequest, ApiCallback<Watchlist> _callback) throws ApiException {
        Call localVarCall = this.postV1TradingAccountsAccountIdWatchlistsWatchlistIdValidateBeforeCall(accountId, watchlistId, postV1TradingAccountsAccountIdWatchlistsWatchlistIdRequest, _callback);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call replaceWatchlistForAccountByIdCall(UUID accountId, UUID watchlistId, CreateWatchlistRequest createWatchlistRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateWatchlistRequest localVarPostBody = createWatchlistRequest;
        String localVarPath = "/v1/trading/accounts/{account_id}/watchlists/{watchlist_id}".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString())).replace("{watchlist_id}", this.localVarApiClient.escapeString(watchlistId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceWatchlistForAccountByIdValidateBeforeCall(UUID accountId, UUID watchlistId, CreateWatchlistRequest createWatchlistRequest, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling replaceWatchlistForAccountById(Async)");
        }
        if (watchlistId == null) {
            throw new ApiException("Missing the required parameter 'watchlistId' when calling replaceWatchlistForAccountById(Async)");
        }
        return this.replaceWatchlistForAccountByIdCall(accountId, watchlistId, createWatchlistRequest, _callback);
    }

    public Watchlist replaceWatchlistForAccountById(UUID accountId, UUID watchlistId, CreateWatchlistRequest createWatchlistRequest) throws ApiException {
        ApiResponse<Watchlist> localVarResp = this.replaceWatchlistForAccountByIdWithHttpInfo(accountId, watchlistId, createWatchlistRequest);
        return localVarResp.getData();
    }

    protected ApiResponse<Watchlist> replaceWatchlistForAccountByIdWithHttpInfo(UUID accountId, UUID watchlistId, CreateWatchlistRequest createWatchlistRequest) throws ApiException {
        Call localVarCall = this.replaceWatchlistForAccountByIdValidateBeforeCall(accountId, watchlistId, createWatchlistRequest, null);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call replaceWatchlistForAccountByIdAsync(UUID accountId, UUID watchlistId, CreateWatchlistRequest createWatchlistRequest, ApiCallback<Watchlist> _callback) throws ApiException {
        Call localVarCall = this.replaceWatchlistForAccountByIdValidateBeforeCall(accountId, watchlistId, createWatchlistRequest, _callback);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

