/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.broker.JSON;

public class ACHRelationship {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private UUID id;
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_UPDATED_AT = "updated_at";
    @SerializedName(value="updated_at")
    private OffsetDateTime updatedAt;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private UUID accountId;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private StatusEnum status;
    public static final String SERIALIZED_NAME_ACCOUNT_OWNER_NAME = "account_owner_name";
    @SerializedName(value="account_owner_name")
    private String accountOwnerName;
    public static final String SERIALIZED_NAME_BANK_ACCOUNT_TYPE = "bank_account_type";
    @SerializedName(value="bank_account_type")
    private BankAccountTypeEnum bankAccountType;
    public static final String SERIALIZED_NAME_BANK_ACCOUNT_NUMBER = "bank_account_number";
    @SerializedName(value="bank_account_number")
    private String bankAccountNumber;
    public static final String SERIALIZED_NAME_BANK_ROUTING_NUMBER = "bank_routing_number";
    @SerializedName(value="bank_routing_number")
    private String bankRoutingNumber;
    public static final String SERIALIZED_NAME_NICKNAME = "nickname";
    @SerializedName(value="nickname")
    private String nickname;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public ACHRelationship id(UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public ACHRelationship createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nonnull
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public ACHRelationship updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nonnull
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public ACHRelationship accountId(UUID accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nonnull
    public UUID getAccountId() {
        return this.accountId;
    }

    public void setAccountId(UUID accountId) {
        this.accountId = accountId;
    }

    public ACHRelationship status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nonnull
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public ACHRelationship accountOwnerName(String accountOwnerName) {
        this.accountOwnerName = accountOwnerName;
        return this;
    }

    @Nonnull
    public String getAccountOwnerName() {
        return this.accountOwnerName;
    }

    public void setAccountOwnerName(String accountOwnerName) {
        this.accountOwnerName = accountOwnerName;
    }

    public ACHRelationship bankAccountType(BankAccountTypeEnum bankAccountType) {
        this.bankAccountType = bankAccountType;
        return this;
    }

    @Nullable
    public BankAccountTypeEnum getBankAccountType() {
        return this.bankAccountType;
    }

    public void setBankAccountType(BankAccountTypeEnum bankAccountType) {
        this.bankAccountType = bankAccountType;
    }

    public ACHRelationship bankAccountNumber(String bankAccountNumber) {
        this.bankAccountNumber = bankAccountNumber;
        return this;
    }

    @Nullable
    public String getBankAccountNumber() {
        return this.bankAccountNumber;
    }

    public void setBankAccountNumber(String bankAccountNumber) {
        this.bankAccountNumber = bankAccountNumber;
    }

    public ACHRelationship bankRoutingNumber(String bankRoutingNumber) {
        this.bankRoutingNumber = bankRoutingNumber;
        return this;
    }

    @Nullable
    public String getBankRoutingNumber() {
        return this.bankRoutingNumber;
    }

    public void setBankRoutingNumber(String bankRoutingNumber) {
        this.bankRoutingNumber = bankRoutingNumber;
    }

    public ACHRelationship nickname(String nickname) {
        this.nickname = nickname;
        return this;
    }

    @Nullable
    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ACHRelationship acHRelationship = (ACHRelationship)o;
        return Objects.equals(this.id, acHRelationship.id) && Objects.equals(this.createdAt, acHRelationship.createdAt) && Objects.equals(this.updatedAt, acHRelationship.updatedAt) && Objects.equals(this.accountId, acHRelationship.accountId) && Objects.equals((Object)this.status, (Object)acHRelationship.status) && Objects.equals(this.accountOwnerName, acHRelationship.accountOwnerName) && Objects.equals((Object)this.bankAccountType, (Object)acHRelationship.bankAccountType) && Objects.equals(this.bankAccountNumber, acHRelationship.bankAccountNumber) && Objects.equals(this.bankRoutingNumber, acHRelationship.bankRoutingNumber) && Objects.equals(this.nickname, acHRelationship.nickname);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.createdAt, this.updatedAt, this.accountId, this.status, this.accountOwnerName, this.bankAccountType, this.bankAccountNumber, this.bankRoutingNumber, this.nickname});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ACHRelationship {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    accountOwnerName: ").append(this.toIndentedString(this.accountOwnerName)).append("\n");
        sb.append("    bankAccountType: ").append(this.toIndentedString((Object)this.bankAccountType)).append("\n");
        sb.append("    bankAccountNumber: ").append(this.toIndentedString(this.bankAccountNumber)).append("\n");
        sb.append("    bankRoutingNumber: ").append(this.toIndentedString(this.bankRoutingNumber)).append("\n");
        sb.append("    nickname: ").append(this.toIndentedString(this.nickname)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in ACHRelationship is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ACHRelationship` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `account_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
        }
        StatusEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STATUS));
        if (!jsonObj.get(SERIALIZED_NAME_ACCOUNT_OWNER_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `account_owner_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_OWNER_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BANK_ACCOUNT_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_BANK_ACCOUNT_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_BANK_ACCOUNT_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `bank_account_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BANK_ACCOUNT_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BANK_ACCOUNT_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_BANK_ACCOUNT_TYPE).isJsonNull()) {
            BankAccountTypeEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_BANK_ACCOUNT_TYPE));
        }
        if (jsonObj.get(SERIALIZED_NAME_BANK_ACCOUNT_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_BANK_ACCOUNT_NUMBER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_BANK_ACCOUNT_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `bank_account_number` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BANK_ACCOUNT_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BANK_ROUTING_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_BANK_ROUTING_NUMBER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_BANK_ROUTING_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `bank_routing_number` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BANK_ROUTING_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NICKNAME) != null && !jsonObj.get(SERIALIZED_NAME_NICKNAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NICKNAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `nickname` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NICKNAME).toString()));
        }
    }

    public static ACHRelationship fromJson(String jsonString) throws IOException {
        return (ACHRelationship)JSON.getGson().fromJson(jsonString, ACHRelationship.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiFields.add(SERIALIZED_NAME_UPDATED_AT);
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_ID);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_OWNER_NAME);
        openapiFields.add(SERIALIZED_NAME_BANK_ACCOUNT_TYPE);
        openapiFields.add(SERIALIZED_NAME_BANK_ACCOUNT_NUMBER);
        openapiFields.add(SERIALIZED_NAME_BANK_ROUTING_NUMBER);
        openapiFields.add(SERIALIZED_NAME_NICKNAME);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiRequiredFields.add(SERIALIZED_NAME_UPDATED_AT);
        openapiRequiredFields.add(SERIALIZED_NAME_ACCOUNT_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_STATUS);
        openapiRequiredFields.add(SERIALIZED_NAME_ACCOUNT_OWNER_NAME);
        validate = false;
        isValid = jsonElement -> true;
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        QUEUED("QUEUED"),
        APPROVED("APPROVED"),
        PENDING("PENDING"),
        CANCEL_REQUESTED("CANCEL_REQUESTED");

        private String value;
        public static boolean validate;
        public static Predicate<JsonElement> isValid;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            if (!isValid.test(jsonElement)) {
                throw new RuntimeException();
            }
            if (!validate) {
                return;
            }
            String value = jsonElement.getAsString();
            StatusEnum.fromValue(value);
        }

        static {
            validate = false;
            isValid = jsonElement -> true;
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum BankAccountTypeEnum {
        CHECKING("CHECKING"),
        SAVINGS("SAVINGS");

        private String value;
        public static boolean validate;
        public static Predicate<JsonElement> isValid;

        private BankAccountTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static BankAccountTypeEnum fromValue(String value) {
            for (BankAccountTypeEnum b : BankAccountTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            if (!isValid.test(jsonElement)) {
                throw new RuntimeException();
            }
            if (!validate) {
                return;
            }
            String value = jsonElement.getAsString();
            BankAccountTypeEnum.fromValue(value);
        }

        static {
            validate = false;
            isValid = jsonElement -> true;
        }

        public static class Adapter
        extends TypeAdapter<BankAccountTypeEnum> {
            public void write(JsonWriter jsonWriter, BankAccountTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public BankAccountTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return BankAccountTypeEnum.fromValue(value);
            }
        }
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ACHRelationship.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ACHRelationship.class));
            return new TypeAdapter<ACHRelationship>(){

                public void write(JsonWriter out, ACHRelationship value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ACHRelationship read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    ACHRelationship.validateJsonElement(jsonElement);
                    return (ACHRelationship)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

