/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.broker.JSON;
import net.jacobpeterson.alpaca.openapi.broker.model.AccountStatus;
import net.jacobpeterson.alpaca.openapi.broker.model.AccountType;
import net.jacobpeterson.alpaca.openapi.broker.model.Agreement;
import net.jacobpeterson.alpaca.openapi.broker.model.AssetClass;
import net.jacobpeterson.alpaca.openapi.broker.model.Contact;
import net.jacobpeterson.alpaca.openapi.broker.model.Disclosures;
import net.jacobpeterson.alpaca.openapi.broker.model.DocumentInner;
import net.jacobpeterson.alpaca.openapi.broker.model.Identity;
import net.jacobpeterson.alpaca.openapi.broker.model.TrustedContact;

public class Account {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private UUID id;
    public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "account_number";
    @SerializedName(value="account_number")
    private String accountNumber;
    public static final String SERIALIZED_NAME_ACCOUNT_TYPE = "account_type";
    @SerializedName(value="account_type")
    private AccountType accountType;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private AccountStatus status;
    public static final String SERIALIZED_NAME_CRYPTO_STATUS = "crypto_status";
    @SerializedName(value="crypto_status")
    private AccountStatus cryptoStatus;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_LAST_EQUITY = "last_equity";
    @SerializedName(value="last_equity")
    private BigDecimal lastEquity;
    public static final String SERIALIZED_NAME_ENABLED_ASSETS = "enabled_assets";
    @SerializedName(value="enabled_assets")
    private List<AssetClass> enabledAssets;
    public static final String SERIALIZED_NAME_CONTACT = "contact";
    @SerializedName(value="contact")
    private Contact contact;
    public static final String SERIALIZED_NAME_IDENTITY = "identity";
    @SerializedName(value="identity")
    private Identity identity;
    public static final String SERIALIZED_NAME_DISCLOSURES = "disclosures";
    @SerializedName(value="disclosures")
    private Disclosures disclosures;
    public static final String SERIALIZED_NAME_DOCUMENTS = "documents";
    @SerializedName(value="documents")
    private List<Set<DocumentInner>> documents;
    public static final String SERIALIZED_NAME_AGREEMENTS = "agreements";
    @SerializedName(value="agreements")
    private List<Agreement> agreements;
    public static final String SERIALIZED_NAME_TRUSTED_CONTACT = "trusted_contact";
    @SerializedName(value="trusted_contact")
    private TrustedContact trustedContact;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public Account id(UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public Account accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @Nullable
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public Account accountType(AccountType accountType) {
        this.accountType = accountType;
        return this;
    }

    @Nullable
    public AccountType getAccountType() {
        return this.accountType;
    }

    public void setAccountType(AccountType accountType) {
        this.accountType = accountType;
    }

    public Account status(AccountStatus status) {
        this.status = status;
        return this;
    }

    @Nonnull
    public AccountStatus getStatus() {
        return this.status;
    }

    public void setStatus(AccountStatus status) {
        this.status = status;
    }

    public Account cryptoStatus(AccountStatus cryptoStatus) {
        this.cryptoStatus = cryptoStatus;
        return this;
    }

    @Nullable
    public AccountStatus getCryptoStatus() {
        return this.cryptoStatus;
    }

    public void setCryptoStatus(AccountStatus cryptoStatus) {
        this.cryptoStatus = cryptoStatus;
    }

    public Account currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nonnull
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Account createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nonnull
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Account lastEquity(BigDecimal lastEquity) {
        this.lastEquity = lastEquity;
        return this;
    }

    @Nonnull
    public BigDecimal getLastEquity() {
        return this.lastEquity;
    }

    public void setLastEquity(BigDecimal lastEquity) {
        this.lastEquity = lastEquity;
    }

    public Account enabledAssets(List<AssetClass> enabledAssets) {
        this.enabledAssets = enabledAssets;
        return this;
    }

    public Account addEnabledAssetsItem(AssetClass enabledAssetsItem) {
        if (this.enabledAssets == null) {
            this.enabledAssets = new ArrayList<AssetClass>();
        }
        this.enabledAssets.add(enabledAssetsItem);
        return this;
    }

    @Nullable
    public List<AssetClass> getEnabledAssets() {
        return this.enabledAssets;
    }

    public void setEnabledAssets(List<AssetClass> enabledAssets) {
        this.enabledAssets = enabledAssets;
    }

    public Account contact(Contact contact) {
        this.contact = contact;
        return this;
    }

    @Nullable
    public Contact getContact() {
        return this.contact;
    }

    public void setContact(Contact contact) {
        this.contact = contact;
    }

    public Account identity(Identity identity) {
        this.identity = identity;
        return this;
    }

    @Nullable
    public Identity getIdentity() {
        return this.identity;
    }

    public void setIdentity(Identity identity) {
        this.identity = identity;
    }

    public Account disclosures(Disclosures disclosures) {
        this.disclosures = disclosures;
        return this;
    }

    @Nullable
    public Disclosures getDisclosures() {
        return this.disclosures;
    }

    public void setDisclosures(Disclosures disclosures) {
        this.disclosures = disclosures;
    }

    public Account documents(List<Set<DocumentInner>> documents) {
        this.documents = documents;
        return this;
    }

    public Account addDocumentsItem(Set<DocumentInner> documentsItem) {
        if (this.documents == null) {
            this.documents = new ArrayList<Set<DocumentInner>>();
        }
        this.documents.add(documentsItem);
        return this;
    }

    @Nullable
    public List<Set<DocumentInner>> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<Set<DocumentInner>> documents) {
        this.documents = documents;
    }

    public Account agreements(List<Agreement> agreements) {
        this.agreements = agreements;
        return this;
    }

    public Account addAgreementsItem(Agreement agreementsItem) {
        if (this.agreements == null) {
            this.agreements = new ArrayList<Agreement>();
        }
        this.agreements.add(agreementsItem);
        return this;
    }

    @Nullable
    public List<Agreement> getAgreements() {
        return this.agreements;
    }

    public void setAgreements(List<Agreement> agreements) {
        this.agreements = agreements;
    }

    public Account trustedContact(TrustedContact trustedContact) {
        this.trustedContact = trustedContact;
        return this;
    }

    @Nullable
    public TrustedContact getTrustedContact() {
        return this.trustedContact;
    }

    public void setTrustedContact(TrustedContact trustedContact) {
        this.trustedContact = trustedContact;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Account account = (Account)o;
        return Objects.equals(this.id, account.id) && Objects.equals(this.accountNumber, account.accountNumber) && Objects.equals((Object)this.accountType, (Object)account.accountType) && Objects.equals((Object)this.status, (Object)account.status) && Objects.equals((Object)this.cryptoStatus, (Object)account.cryptoStatus) && Objects.equals(this.currency, account.currency) && Objects.equals(this.createdAt, account.createdAt) && Objects.equals(this.lastEquity, account.lastEquity) && Objects.equals(this.enabledAssets, account.enabledAssets) && Objects.equals(this.contact, account.contact) && Objects.equals(this.identity, account.identity) && Objects.equals(this.disclosures, account.disclosures) && Objects.equals(this.documents, account.documents) && Objects.equals(this.agreements, account.agreements) && Objects.equals(this.trustedContact, account.trustedContact);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.accountNumber, this.accountType, this.status, this.cryptoStatus, this.currency, this.createdAt, this.lastEquity, this.enabledAssets, this.contact, this.identity, this.disclosures, this.documents, this.agreements, this.trustedContact});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Account {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    accountType: ").append(this.toIndentedString((Object)this.accountType)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    cryptoStatus: ").append(this.toIndentedString((Object)this.cryptoStatus)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    lastEquity: ").append(this.toIndentedString(this.lastEquity)).append("\n");
        sb.append("    enabledAssets: ").append(this.toIndentedString(this.enabledAssets)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    identity: ").append(this.toIndentedString(this.identity)).append("\n");
        sb.append("    disclosures: ").append(this.toIndentedString(this.disclosures)).append("\n");
        sb.append("    documents: ").append(this.toIndentedString(this.documents)).append("\n");
        sb.append("    agreements: ").append(this.toIndentedString(this.agreements)).append("\n");
        sb.append("    trustedContact: ").append(this.toIndentedString(this.trustedContact)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayagreements;
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in Account is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Account` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCOUNT_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_NUMBER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `account_number` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCOUNT_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_TYPE).isJsonNull()) {
            AccountType.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ACCOUNT_TYPE));
        }
        AccountStatus.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STATUS));
        if (jsonObj.get(SERIALIZED_NAME_CRYPTO_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_CRYPTO_STATUS).isJsonNull()) {
            AccountStatus.validateJsonElement(jsonObj.get(SERIALIZED_NAME_CRYPTO_STATUS));
        }
        if (!jsonObj.get(SERIALIZED_NAME_CURRENCY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CURRENCY).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_LAST_EQUITY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `last_equity` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LAST_EQUITY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENABLED_ASSETS) != null && !jsonObj.get(SERIALIZED_NAME_ENABLED_ASSETS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ENABLED_ASSETS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `enabled_assets` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENABLED_ASSETS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONTACT) != null && !jsonObj.get(SERIALIZED_NAME_CONTACT).isJsonNull()) {
            Contact.validateJsonElement(jsonObj.get(SERIALIZED_NAME_CONTACT));
        }
        if (jsonObj.get(SERIALIZED_NAME_IDENTITY) != null && !jsonObj.get(SERIALIZED_NAME_IDENTITY).isJsonNull()) {
            Identity.validateJsonElement(jsonObj.get(SERIALIZED_NAME_IDENTITY));
        }
        if (jsonObj.get(SERIALIZED_NAME_DISCLOSURES) != null && !jsonObj.get(SERIALIZED_NAME_DISCLOSURES).isJsonNull()) {
            Disclosures.validateJsonElement(jsonObj.get(SERIALIZED_NAME_DISCLOSURES));
        }
        if (jsonObj.get(SERIALIZED_NAME_DOCUMENTS) != null && !jsonObj.get(SERIALIZED_NAME_DOCUMENTS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DOCUMENTS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `documents` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DOCUMENTS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_AGREEMENTS) != null && !jsonObj.get(SERIALIZED_NAME_AGREEMENTS).isJsonNull() && (jsonArrayagreements = jsonObj.getAsJsonArray(SERIALIZED_NAME_AGREEMENTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_AGREEMENTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `agreements` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AGREEMENTS).toString()));
            }
            for (int i = 0; i < jsonArrayagreements.size(); ++i) {
                Agreement.validateJsonElement(jsonArrayagreements.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_TRUSTED_CONTACT) != null && !jsonObj.get(SERIALIZED_NAME_TRUSTED_CONTACT).isJsonNull()) {
            TrustedContact.validateJsonElement(jsonObj.get(SERIALIZED_NAME_TRUSTED_CONTACT));
        }
    }

    public static Account fromJson(String jsonString) throws IOException {
        return (Account)JSON.getGson().fromJson(jsonString, Account.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_NUMBER);
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_TYPE);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_CRYPTO_STATUS);
        openapiFields.add(SERIALIZED_NAME_CURRENCY);
        openapiFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiFields.add(SERIALIZED_NAME_LAST_EQUITY);
        openapiFields.add(SERIALIZED_NAME_ENABLED_ASSETS);
        openapiFields.add(SERIALIZED_NAME_CONTACT);
        openapiFields.add(SERIALIZED_NAME_IDENTITY);
        openapiFields.add(SERIALIZED_NAME_DISCLOSURES);
        openapiFields.add(SERIALIZED_NAME_DOCUMENTS);
        openapiFields.add(SERIALIZED_NAME_AGREEMENTS);
        openapiFields.add(SERIALIZED_NAME_TRUSTED_CONTACT);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_ACCOUNT_NUMBER);
        openapiRequiredFields.add(SERIALIZED_NAME_STATUS);
        openapiRequiredFields.add(SERIALIZED_NAME_CURRENCY);
        openapiRequiredFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiRequiredFields.add(SERIALIZED_NAME_LAST_EQUITY);
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Account.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Account.class));
            return new TypeAdapter<Account>(){

                public void write(JsonWriter out, Account value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Account read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    Account.validateJsonElement(jsonElement);
                    return (Account)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

