/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.broker.JSON;

public class AccountConfigurations {
    public static final String SERIALIZED_NAME_DTBP_CHECK = "dtbp_check";
    @SerializedName(value="dtbp_check")
    private DtbpCheckEnum dtbpCheck;
    public static final String SERIALIZED_NAME_TRADE_CONFIRM_EMAIL = "trade_confirm_email";
    @SerializedName(value="trade_confirm_email")
    private TradeConfirmEmailEnum tradeConfirmEmail;
    public static final String SERIALIZED_NAME_SUSPEND_TRADE = "suspend_trade";
    @SerializedName(value="suspend_trade")
    private Boolean suspendTrade;
    public static final String SERIALIZED_NAME_NO_SHORTING = "no_shorting";
    @SerializedName(value="no_shorting")
    private Boolean noShorting;
    public static final String SERIALIZED_NAME_FRACTIONAL_TRADING = "fractional_trading";
    @SerializedName(value="fractional_trading")
    private Boolean fractionalTrading;
    public static final String SERIALIZED_NAME_MAX_MARGIN_MULTIPLIER = "max_margin_multiplier";
    @SerializedName(value="max_margin_multiplier")
    private String maxMarginMultiplier;
    public static final String SERIALIZED_NAME_MAX_OPTIONS_TRADING_LEVEL = "max_options_trading_level";
    @SerializedName(value="max_options_trading_level")
    private MaxOptionsTradingLevelEnum maxOptionsTradingLevel;
    public static final String SERIALIZED_NAME_PDT_CHECK = "pdt_check";
    @SerializedName(value="pdt_check")
    private String pdtCheck;
    public static final String SERIALIZED_NAME_PTP_NO_EXCEPTION_ENTRY = "ptp_no_exception_entry";
    @SerializedName(value="ptp_no_exception_entry")
    private String ptpNoExceptionEntry;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public AccountConfigurations dtbpCheck(DtbpCheckEnum dtbpCheck) {
        this.dtbpCheck = dtbpCheck;
        return this;
    }

    @Nonnull
    public DtbpCheckEnum getDtbpCheck() {
        return this.dtbpCheck;
    }

    public void setDtbpCheck(DtbpCheckEnum dtbpCheck) {
        this.dtbpCheck = dtbpCheck;
    }

    public AccountConfigurations tradeConfirmEmail(TradeConfirmEmailEnum tradeConfirmEmail) {
        this.tradeConfirmEmail = tradeConfirmEmail;
        return this;
    }

    @Nonnull
    public TradeConfirmEmailEnum getTradeConfirmEmail() {
        return this.tradeConfirmEmail;
    }

    public void setTradeConfirmEmail(TradeConfirmEmailEnum tradeConfirmEmail) {
        this.tradeConfirmEmail = tradeConfirmEmail;
    }

    public AccountConfigurations suspendTrade(Boolean suspendTrade) {
        this.suspendTrade = suspendTrade;
        return this;
    }

    @Nonnull
    public Boolean getSuspendTrade() {
        return this.suspendTrade;
    }

    public void setSuspendTrade(Boolean suspendTrade) {
        this.suspendTrade = suspendTrade;
    }

    public AccountConfigurations noShorting(Boolean noShorting) {
        this.noShorting = noShorting;
        return this;
    }

    @Nonnull
    public Boolean getNoShorting() {
        return this.noShorting;
    }

    public void setNoShorting(Boolean noShorting) {
        this.noShorting = noShorting;
    }

    public AccountConfigurations fractionalTrading(Boolean fractionalTrading) {
        this.fractionalTrading = fractionalTrading;
        return this;
    }

    @Nonnull
    public Boolean getFractionalTrading() {
        return this.fractionalTrading;
    }

    public void setFractionalTrading(Boolean fractionalTrading) {
        this.fractionalTrading = fractionalTrading;
    }

    public AccountConfigurations maxMarginMultiplier(String maxMarginMultiplier) {
        this.maxMarginMultiplier = maxMarginMultiplier;
        return this;
    }

    @Nonnull
    public String getMaxMarginMultiplier() {
        return this.maxMarginMultiplier;
    }

    public void setMaxMarginMultiplier(String maxMarginMultiplier) {
        this.maxMarginMultiplier = maxMarginMultiplier;
    }

    public AccountConfigurations maxOptionsTradingLevel(MaxOptionsTradingLevelEnum maxOptionsTradingLevel) {
        this.maxOptionsTradingLevel = maxOptionsTradingLevel;
        return this;
    }

    @Nullable
    public MaxOptionsTradingLevelEnum getMaxOptionsTradingLevel() {
        return this.maxOptionsTradingLevel;
    }

    public void setMaxOptionsTradingLevel(MaxOptionsTradingLevelEnum maxOptionsTradingLevel) {
        this.maxOptionsTradingLevel = maxOptionsTradingLevel;
    }

    public AccountConfigurations pdtCheck(String pdtCheck) {
        this.pdtCheck = pdtCheck;
        return this;
    }

    @Nonnull
    public String getPdtCheck() {
        return this.pdtCheck;
    }

    public void setPdtCheck(String pdtCheck) {
        this.pdtCheck = pdtCheck;
    }

    public AccountConfigurations ptpNoExceptionEntry(String ptpNoExceptionEntry) {
        this.ptpNoExceptionEntry = ptpNoExceptionEntry;
        return this;
    }

    @Nonnull
    public String getPtpNoExceptionEntry() {
        return this.ptpNoExceptionEntry;
    }

    public void setPtpNoExceptionEntry(String ptpNoExceptionEntry) {
        this.ptpNoExceptionEntry = ptpNoExceptionEntry;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountConfigurations accountConfigurations = (AccountConfigurations)o;
        return Objects.equals((Object)this.dtbpCheck, (Object)accountConfigurations.dtbpCheck) && Objects.equals((Object)this.tradeConfirmEmail, (Object)accountConfigurations.tradeConfirmEmail) && Objects.equals(this.suspendTrade, accountConfigurations.suspendTrade) && Objects.equals(this.noShorting, accountConfigurations.noShorting) && Objects.equals(this.fractionalTrading, accountConfigurations.fractionalTrading) && Objects.equals(this.maxMarginMultiplier, accountConfigurations.maxMarginMultiplier) && Objects.equals((Object)this.maxOptionsTradingLevel, (Object)accountConfigurations.maxOptionsTradingLevel) && Objects.equals(this.pdtCheck, accountConfigurations.pdtCheck) && Objects.equals(this.ptpNoExceptionEntry, accountConfigurations.ptpNoExceptionEntry);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dtbpCheck, this.tradeConfirmEmail, this.suspendTrade, this.noShorting, this.fractionalTrading, this.maxMarginMultiplier, this.maxOptionsTradingLevel, this.pdtCheck, this.ptpNoExceptionEntry});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountConfigurations {\n");
        sb.append("    dtbpCheck: ").append(this.toIndentedString((Object)this.dtbpCheck)).append("\n");
        sb.append("    tradeConfirmEmail: ").append(this.toIndentedString((Object)this.tradeConfirmEmail)).append("\n");
        sb.append("    suspendTrade: ").append(this.toIndentedString(this.suspendTrade)).append("\n");
        sb.append("    noShorting: ").append(this.toIndentedString(this.noShorting)).append("\n");
        sb.append("    fractionalTrading: ").append(this.toIndentedString(this.fractionalTrading)).append("\n");
        sb.append("    maxMarginMultiplier: ").append(this.toIndentedString(this.maxMarginMultiplier)).append("\n");
        sb.append("    maxOptionsTradingLevel: ").append(this.toIndentedString((Object)this.maxOptionsTradingLevel)).append("\n");
        sb.append("    pdtCheck: ").append(this.toIndentedString(this.pdtCheck)).append("\n");
        sb.append("    ptpNoExceptionEntry: ").append(this.toIndentedString(this.ptpNoExceptionEntry)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in AccountConfigurations is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AccountConfigurations` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_DTBP_CHECK).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `dtbp_check` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DTBP_CHECK).toString()));
        }
        DtbpCheckEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_DTBP_CHECK));
        if (!jsonObj.get(SERIALIZED_NAME_TRADE_CONFIRM_EMAIL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `trade_confirm_email` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRADE_CONFIRM_EMAIL).toString()));
        }
        TradeConfirmEmailEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_TRADE_CONFIRM_EMAIL));
        if (!jsonObj.get(SERIALIZED_NAME_MAX_MARGIN_MULTIPLIER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `max_margin_multiplier` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MAX_MARGIN_MULTIPLIER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MAX_OPTIONS_TRADING_LEVEL) != null && !jsonObj.get(SERIALIZED_NAME_MAX_OPTIONS_TRADING_LEVEL).isJsonNull()) {
            MaxOptionsTradingLevelEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_MAX_OPTIONS_TRADING_LEVEL));
        }
        if (!jsonObj.get(SERIALIZED_NAME_PDT_CHECK).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `pdt_check` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PDT_CHECK).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_PTP_NO_EXCEPTION_ENTRY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `ptp_no_exception_entry` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PTP_NO_EXCEPTION_ENTRY).toString()));
        }
    }

    public static AccountConfigurations fromJson(String jsonString) throws IOException {
        return (AccountConfigurations)JSON.getGson().fromJson(jsonString, AccountConfigurations.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DTBP_CHECK);
        openapiFields.add(SERIALIZED_NAME_TRADE_CONFIRM_EMAIL);
        openapiFields.add(SERIALIZED_NAME_SUSPEND_TRADE);
        openapiFields.add(SERIALIZED_NAME_NO_SHORTING);
        openapiFields.add(SERIALIZED_NAME_FRACTIONAL_TRADING);
        openapiFields.add(SERIALIZED_NAME_MAX_MARGIN_MULTIPLIER);
        openapiFields.add(SERIALIZED_NAME_MAX_OPTIONS_TRADING_LEVEL);
        openapiFields.add(SERIALIZED_NAME_PDT_CHECK);
        openapiFields.add(SERIALIZED_NAME_PTP_NO_EXCEPTION_ENTRY);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_DTBP_CHECK);
        openapiRequiredFields.add(SERIALIZED_NAME_TRADE_CONFIRM_EMAIL);
        openapiRequiredFields.add(SERIALIZED_NAME_SUSPEND_TRADE);
        openapiRequiredFields.add(SERIALIZED_NAME_NO_SHORTING);
        openapiRequiredFields.add(SERIALIZED_NAME_FRACTIONAL_TRADING);
        openapiRequiredFields.add(SERIALIZED_NAME_MAX_MARGIN_MULTIPLIER);
        openapiRequiredFields.add(SERIALIZED_NAME_PDT_CHECK);
        openapiRequiredFields.add(SERIALIZED_NAME_PTP_NO_EXCEPTION_ENTRY);
        validate = false;
        isValid = jsonElement -> true;
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DtbpCheckEnum {
        BOTH("both"),
        ENTRY("entry"),
        EXIT("exit");

        private String value;
        public static boolean validate;
        public static Predicate<JsonElement> isValid;

        private DtbpCheckEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DtbpCheckEnum fromValue(String value) {
            for (DtbpCheckEnum b : DtbpCheckEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            if (!isValid.test(jsonElement)) {
                throw new RuntimeException();
            }
            if (!validate) {
                return;
            }
            String value = jsonElement.getAsString();
            DtbpCheckEnum.fromValue(value);
        }

        static {
            validate = false;
            isValid = jsonElement -> true;
        }

        public static class Adapter
        extends TypeAdapter<DtbpCheckEnum> {
            public void write(JsonWriter jsonWriter, DtbpCheckEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DtbpCheckEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DtbpCheckEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TradeConfirmEmailEnum {
        ALL("all"),
        NONE("none");

        private String value;
        public static boolean validate;
        public static Predicate<JsonElement> isValid;

        private TradeConfirmEmailEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TradeConfirmEmailEnum fromValue(String value) {
            for (TradeConfirmEmailEnum b : TradeConfirmEmailEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            if (!isValid.test(jsonElement)) {
                throw new RuntimeException();
            }
            if (!validate) {
                return;
            }
            String value = jsonElement.getAsString();
            TradeConfirmEmailEnum.fromValue(value);
        }

        static {
            validate = false;
            isValid = jsonElement -> true;
        }

        public static class Adapter
        extends TypeAdapter<TradeConfirmEmailEnum> {
            public void write(JsonWriter jsonWriter, TradeConfirmEmailEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TradeConfirmEmailEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TradeConfirmEmailEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum MaxOptionsTradingLevelEnum {
        NUMBER_0(0),
        NUMBER_1(1),
        NUMBER_2(2);

        private Integer value;
        public static boolean validate;
        public static Predicate<JsonElement> isValid;

        private MaxOptionsTradingLevelEnum(Integer value) {
            this.value = value;
        }

        public Integer getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static MaxOptionsTradingLevelEnum fromValue(Integer value) {
            for (MaxOptionsTradingLevelEnum b : MaxOptionsTradingLevelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            if (!isValid.test(jsonElement)) {
                throw new RuntimeException();
            }
            if (!validate) {
                return;
            }
            Integer value = jsonElement.getAsInt();
            MaxOptionsTradingLevelEnum.fromValue(value);
        }

        static {
            validate = false;
            isValid = jsonElement -> true;
        }

        public static class Adapter
        extends TypeAdapter<MaxOptionsTradingLevelEnum> {
            public void write(JsonWriter jsonWriter, MaxOptionsTradingLevelEnum enumeration) throws IOException {
                jsonWriter.value((Number)enumeration.getValue());
            }

            public MaxOptionsTradingLevelEnum read(JsonReader jsonReader) throws IOException {
                Integer value = jsonReader.nextInt();
                return MaxOptionsTradingLevelEnum.fromValue(value);
            }
        }
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AccountConfigurations.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AccountConfigurations.class));
            return new TypeAdapter<AccountConfigurations>(){

                public void write(JsonWriter out, AccountConfigurations value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AccountConfigurations read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    AccountConfigurations.validateJsonElement(jsonElement);
                    return (AccountConfigurations)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

