/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.broker.JSON;
import net.jacobpeterson.alpaca.openapi.broker.model.Agreement;
import net.jacobpeterson.alpaca.openapi.broker.model.AssetClass;
import net.jacobpeterson.alpaca.openapi.broker.model.Contact;
import net.jacobpeterson.alpaca.openapi.broker.model.Disclosures;
import net.jacobpeterson.alpaca.openapi.broker.model.DocumentUploadRequest;
import net.jacobpeterson.alpaca.openapi.broker.model.Identity;
import net.jacobpeterson.alpaca.openapi.broker.model.TrustedContact;

public class AccountCreationRequest {
    public static final String SERIALIZED_NAME_CONTACT = "contact";
    @SerializedName(value="contact")
    private Contact contact;
    public static final String SERIALIZED_NAME_IDENTITY = "identity";
    @SerializedName(value="identity")
    private Identity identity;
    public static final String SERIALIZED_NAME_DISCLOSURES = "disclosures";
    @SerializedName(value="disclosures")
    private Disclosures disclosures;
    public static final String SERIALIZED_NAME_AGREEMENTS = "agreements";
    @SerializedName(value="agreements")
    private List<Agreement> agreements = new ArrayList<Agreement>();
    public static final String SERIALIZED_NAME_DOCUMENTS = "documents";
    @SerializedName(value="documents")
    private List<DocumentUploadRequest> documents;
    public static final String SERIALIZED_NAME_TRUSTED_CONTACT = "trusted_contact";
    @SerializedName(value="trusted_contact")
    private TrustedContact trustedContact;
    public static final String SERIALIZED_NAME_ENABLED_ASSETS = "enabled_assets";
    @SerializedName(value="enabled_assets")
    private List<AssetClass> enabledAssets;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public AccountCreationRequest contact(Contact contact) {
        this.contact = contact;
        return this;
    }

    @Nonnull
    public Contact getContact() {
        return this.contact;
    }

    public void setContact(Contact contact) {
        this.contact = contact;
    }

    public AccountCreationRequest identity(Identity identity) {
        this.identity = identity;
        return this;
    }

    @Nonnull
    public Identity getIdentity() {
        return this.identity;
    }

    public void setIdentity(Identity identity) {
        this.identity = identity;
    }

    public AccountCreationRequest disclosures(Disclosures disclosures) {
        this.disclosures = disclosures;
        return this;
    }

    @Nonnull
    public Disclosures getDisclosures() {
        return this.disclosures;
    }

    public void setDisclosures(Disclosures disclosures) {
        this.disclosures = disclosures;
    }

    public AccountCreationRequest agreements(List<Agreement> agreements) {
        this.agreements = agreements;
        return this;
    }

    public AccountCreationRequest addAgreementsItem(Agreement agreementsItem) {
        if (this.agreements == null) {
            this.agreements = new ArrayList<Agreement>();
        }
        this.agreements.add(agreementsItem);
        return this;
    }

    @Nonnull
    public List<Agreement> getAgreements() {
        return this.agreements;
    }

    public void setAgreements(List<Agreement> agreements) {
        this.agreements = agreements;
    }

    public AccountCreationRequest documents(List<DocumentUploadRequest> documents) {
        this.documents = documents;
        return this;
    }

    public AccountCreationRequest addDocumentsItem(DocumentUploadRequest documentsItem) {
        if (this.documents == null) {
            this.documents = new ArrayList<DocumentUploadRequest>();
        }
        this.documents.add(documentsItem);
        return this;
    }

    @Nullable
    public List<DocumentUploadRequest> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<DocumentUploadRequest> documents) {
        this.documents = documents;
    }

    public AccountCreationRequest trustedContact(TrustedContact trustedContact) {
        this.trustedContact = trustedContact;
        return this;
    }

    @Nullable
    public TrustedContact getTrustedContact() {
        return this.trustedContact;
    }

    public void setTrustedContact(TrustedContact trustedContact) {
        this.trustedContact = trustedContact;
    }

    public AccountCreationRequest enabledAssets(List<AssetClass> enabledAssets) {
        this.enabledAssets = enabledAssets;
        return this;
    }

    public AccountCreationRequest addEnabledAssetsItem(AssetClass enabledAssetsItem) {
        if (this.enabledAssets == null) {
            this.enabledAssets = new ArrayList<AssetClass>();
        }
        this.enabledAssets.add(enabledAssetsItem);
        return this;
    }

    @Nullable
    public List<AssetClass> getEnabledAssets() {
        return this.enabledAssets;
    }

    public void setEnabledAssets(List<AssetClass> enabledAssets) {
        this.enabledAssets = enabledAssets;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountCreationRequest accountCreationRequest = (AccountCreationRequest)o;
        return Objects.equals(this.contact, accountCreationRequest.contact) && Objects.equals(this.identity, accountCreationRequest.identity) && Objects.equals(this.disclosures, accountCreationRequest.disclosures) && Objects.equals(this.agreements, accountCreationRequest.agreements) && Objects.equals(this.documents, accountCreationRequest.documents) && Objects.equals(this.trustedContact, accountCreationRequest.trustedContact) && Objects.equals(this.enabledAssets, accountCreationRequest.enabledAssets);
    }

    public int hashCode() {
        return Objects.hash(this.contact, this.identity, this.disclosures, this.agreements, this.documents, this.trustedContact, this.enabledAssets);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountCreationRequest {\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    identity: ").append(this.toIndentedString(this.identity)).append("\n");
        sb.append("    disclosures: ").append(this.toIndentedString(this.disclosures)).append("\n");
        sb.append("    agreements: ").append(this.toIndentedString(this.agreements)).append("\n");
        sb.append("    documents: ").append(this.toIndentedString(this.documents)).append("\n");
        sb.append("    trustedContact: ").append(this.toIndentedString(this.trustedContact)).append("\n");
        sb.append("    enabledAssets: ").append(this.toIndentedString(this.enabledAssets)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArraydocuments;
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in AccountCreationRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AccountCreationRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        Contact.validateJsonElement(jsonObj.get(SERIALIZED_NAME_CONTACT));
        Identity.validateJsonElement(jsonObj.get(SERIALIZED_NAME_IDENTITY));
        Disclosures.validateJsonElement(jsonObj.get(SERIALIZED_NAME_DISCLOSURES));
        if (!jsonObj.get(SERIALIZED_NAME_AGREEMENTS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `agreements` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AGREEMENTS).toString()));
        }
        JsonArray jsonArrayagreements = jsonObj.getAsJsonArray(SERIALIZED_NAME_AGREEMENTS);
        for (int i = 0; i < jsonArrayagreements.size(); ++i) {
            Agreement.validateJsonElement(jsonArrayagreements.get(i));
        }
        if (jsonObj.get(SERIALIZED_NAME_DOCUMENTS) != null && !jsonObj.get(SERIALIZED_NAME_DOCUMENTS).isJsonNull() && (jsonArraydocuments = jsonObj.getAsJsonArray(SERIALIZED_NAME_DOCUMENTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_DOCUMENTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `documents` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DOCUMENTS).toString()));
            }
            for (int i = 0; i < jsonArraydocuments.size(); ++i) {
                DocumentUploadRequest.validateJsonElement(jsonArraydocuments.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_TRUSTED_CONTACT) != null && !jsonObj.get(SERIALIZED_NAME_TRUSTED_CONTACT).isJsonNull()) {
            TrustedContact.validateJsonElement(jsonObj.get(SERIALIZED_NAME_TRUSTED_CONTACT));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENABLED_ASSETS) != null && !jsonObj.get(SERIALIZED_NAME_ENABLED_ASSETS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ENABLED_ASSETS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `enabled_assets` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENABLED_ASSETS).toString()));
        }
    }

    public static AccountCreationRequest fromJson(String jsonString) throws IOException {
        return (AccountCreationRequest)JSON.getGson().fromJson(jsonString, AccountCreationRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CONTACT);
        openapiFields.add(SERIALIZED_NAME_IDENTITY);
        openapiFields.add(SERIALIZED_NAME_DISCLOSURES);
        openapiFields.add(SERIALIZED_NAME_AGREEMENTS);
        openapiFields.add(SERIALIZED_NAME_DOCUMENTS);
        openapiFields.add(SERIALIZED_NAME_TRUSTED_CONTACT);
        openapiFields.add(SERIALIZED_NAME_ENABLED_ASSETS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_CONTACT);
        openapiRequiredFields.add(SERIALIZED_NAME_IDENTITY);
        openapiRequiredFields.add(SERIALIZED_NAME_DISCLOSURES);
        openapiRequiredFields.add(SERIALIZED_NAME_AGREEMENTS);
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AccountCreationRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AccountCreationRequest.class));
            return new TypeAdapter<AccountCreationRequest>(){

                public void write(JsonWriter out, AccountCreationRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AccountCreationRequest read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    AccountCreationRequest.validateJsonElement(jsonElement);
                    return (AccountCreationRequest)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

