/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.broker.JSON;
import net.jacobpeterson.alpaca.openapi.broker.model.DocumentType;

public class AccountDocument {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private UUID id;
    public static final String SERIALIZED_NAME_DOCUMENT_TYPE = "document_type";
    @SerializedName(value="document_type")
    private DocumentType documentType;
    public static final String SERIALIZED_NAME_DOCUMENT_SUB_TYPE = "document_sub_type";
    @SerializedName(value="document_sub_type")
    private String documentSubType;
    public static final String SERIALIZED_NAME_MIME_TYPE = "mime_type";
    @SerializedName(value="mime_type")
    private String mimeType;
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private OffsetDateTime createdAt;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public AccountDocument id(UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public AccountDocument documentType(DocumentType documentType) {
        this.documentType = documentType;
        return this;
    }

    @Nonnull
    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(DocumentType documentType) {
        this.documentType = documentType;
    }

    public AccountDocument documentSubType(String documentSubType) {
        this.documentSubType = documentSubType;
        return this;
    }

    @Nullable
    public String getDocumentSubType() {
        return this.documentSubType;
    }

    public void setDocumentSubType(String documentSubType) {
        this.documentSubType = documentSubType;
    }

    public AccountDocument mimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    @Nullable
    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public AccountDocument createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nonnull
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountDocument accountDocument = (AccountDocument)o;
        return Objects.equals(this.id, accountDocument.id) && Objects.equals((Object)this.documentType, (Object)accountDocument.documentType) && Objects.equals(this.documentSubType, accountDocument.documentSubType) && Objects.equals(this.mimeType, accountDocument.mimeType) && Objects.equals(this.createdAt, accountDocument.createdAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.documentType, this.documentSubType, this.mimeType, this.createdAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountDocument {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    documentType: ").append(this.toIndentedString((Object)this.documentType)).append("\n");
        sb.append("    documentSubType: ").append(this.toIndentedString(this.documentSubType)).append("\n");
        sb.append("    mimeType: ").append(this.toIndentedString(this.mimeType)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in AccountDocument is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AccountDocument` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        DocumentType.validateJsonElement(jsonObj.get(SERIALIZED_NAME_DOCUMENT_TYPE));
        if (jsonObj.get(SERIALIZED_NAME_DOCUMENT_SUB_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_DOCUMENT_SUB_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DOCUMENT_SUB_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `document_sub_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DOCUMENT_SUB_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MIME_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_MIME_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MIME_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `mime_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MIME_TYPE).toString()));
        }
    }

    public static AccountDocument fromJson(String jsonString) throws IOException {
        return (AccountDocument)JSON.getGson().fromJson(jsonString, AccountDocument.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_DOCUMENT_TYPE);
        openapiFields.add(SERIALIZED_NAME_DOCUMENT_SUB_TYPE);
        openapiFields.add(SERIALIZED_NAME_MIME_TYPE);
        openapiFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_DOCUMENT_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_CREATED_AT);
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AccountDocument.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AccountDocument.class));
            return new TypeAdapter<AccountDocument>(){

                public void write(JsonWriter out, AccountDocument value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AccountDocument read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    AccountDocument.validateJsonElement(jsonElement);
                    return (AccountDocument)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

