/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.broker.JSON;
import net.jacobpeterson.alpaca.openapi.broker.model.AccountConfigurations;
import net.jacobpeterson.alpaca.openapi.broker.model.AccountStatus;
import net.jacobpeterson.alpaca.openapi.broker.model.AccountType;
import net.jacobpeterson.alpaca.openapi.broker.model.Agreement;
import net.jacobpeterson.alpaca.openapi.broker.model.ApplicationDocument;
import net.jacobpeterson.alpaca.openapi.broker.model.AssetClass;
import net.jacobpeterson.alpaca.openapi.broker.model.Contact;
import net.jacobpeterson.alpaca.openapi.broker.model.CustodialAccountMinorIdentity;
import net.jacobpeterson.alpaca.openapi.broker.model.Disclosures;
import net.jacobpeterson.alpaca.openapi.broker.model.Identity;
import net.jacobpeterson.alpaca.openapi.broker.model.KYCResult;
import net.jacobpeterson.alpaca.openapi.broker.model.TrustedContact;
import net.jacobpeterson.alpaca.openapi.broker.model.USDBalances;

public class AccountExtended {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private UUID id;
    public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "account_number";
    @SerializedName(value="account_number")
    private String accountNumber;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private AccountStatus status;
    public static final String SERIALIZED_NAME_CRYPTO_STATUS = "crypto_status";
    @SerializedName(value="crypto_status")
    private AccountStatus cryptoStatus;
    public static final String SERIALIZED_NAME_KYC_RESULT = "kyc_result";
    @SerializedName(value="kyc_result")
    private KYCResult kycResult;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_LAST_EQUITY = "last_equity";
    @SerializedName(value="last_equity")
    private BigDecimal lastEquity;
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_CONTACT = "contact";
    @SerializedName(value="contact")
    private Contact contact;
    public static final String SERIALIZED_NAME_IDENTITY = "identity";
    @SerializedName(value="identity")
    private Identity identity;
    public static final String SERIALIZED_NAME_DISCLOSURES = "disclosures";
    @SerializedName(value="disclosures")
    private Disclosures disclosures;
    public static final String SERIALIZED_NAME_AGREEMENTS = "agreements";
    @SerializedName(value="agreements")
    private List<Agreement> agreements;
    public static final String SERIALIZED_NAME_DOCUMENTS = "documents";
    @SerializedName(value="documents")
    private List<ApplicationDocument> documents;
    public static final String SERIALIZED_NAME_TRUSTED_CONTACT = "trusted_contact";
    @SerializedName(value="trusted_contact")
    private TrustedContact trustedContact;
    public static final String SERIALIZED_NAME_ACCOUNT_NAME = "account_name";
    @SerializedName(value="account_name")
    private String accountName;
    public static final String SERIALIZED_NAME_ACCOUNT_TYPE = "account_type";
    @SerializedName(value="account_type")
    private AccountType accountType;
    public static final String SERIALIZED_NAME_CUSTODIAL_ACCOUNT_TYPE = "custodial_account_type";
    @SerializedName(value="custodial_account_type")
    private String custodialAccountType;
    public static final String SERIALIZED_NAME_MINOR_IDENTITY = "minor_identity";
    @SerializedName(value="minor_identity")
    private CustodialAccountMinorIdentity minorIdentity;
    public static final String SERIALIZED_NAME_TRADING_CONFIGURATIONS = "trading_configurations";
    @SerializedName(value="trading_configurations")
    private AccountConfigurations tradingConfigurations;
    public static final String SERIALIZED_NAME_USD = "usd";
    @SerializedName(value="usd")
    private USDBalances usd;
    public static final String SERIALIZED_NAME_ENABLED_ASSETS = "enabled_assets";
    @SerializedName(value="enabled_assets")
    private List<AssetClass> enabledAssets;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public AccountExtended id(UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public AccountExtended accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @Nullable
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public AccountExtended status(AccountStatus status) {
        this.status = status;
        return this;
    }

    @Nonnull
    public AccountStatus getStatus() {
        return this.status;
    }

    public void setStatus(AccountStatus status) {
        this.status = status;
    }

    public AccountExtended cryptoStatus(AccountStatus cryptoStatus) {
        this.cryptoStatus = cryptoStatus;
        return this;
    }

    @Nullable
    public AccountStatus getCryptoStatus() {
        return this.cryptoStatus;
    }

    public void setCryptoStatus(AccountStatus cryptoStatus) {
        this.cryptoStatus = cryptoStatus;
    }

    public AccountExtended kycResult(KYCResult kycResult) {
        this.kycResult = kycResult;
        return this;
    }

    @Nullable
    public KYCResult getKycResult() {
        return this.kycResult;
    }

    public void setKycResult(KYCResult kycResult) {
        this.kycResult = kycResult;
    }

    public AccountExtended currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nonnull
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public AccountExtended lastEquity(BigDecimal lastEquity) {
        this.lastEquity = lastEquity;
        return this;
    }

    @Nonnull
    public BigDecimal getLastEquity() {
        return this.lastEquity;
    }

    public void setLastEquity(BigDecimal lastEquity) {
        this.lastEquity = lastEquity;
    }

    public AccountExtended createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nonnull
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public AccountExtended contact(Contact contact) {
        this.contact = contact;
        return this;
    }

    @Nullable
    public Contact getContact() {
        return this.contact;
    }

    public void setContact(Contact contact) {
        this.contact = contact;
    }

    public AccountExtended identity(Identity identity) {
        this.identity = identity;
        return this;
    }

    @Nullable
    public Identity getIdentity() {
        return this.identity;
    }

    public void setIdentity(Identity identity) {
        this.identity = identity;
    }

    public AccountExtended disclosures(Disclosures disclosures) {
        this.disclosures = disclosures;
        return this;
    }

    @Nullable
    public Disclosures getDisclosures() {
        return this.disclosures;
    }

    public void setDisclosures(Disclosures disclosures) {
        this.disclosures = disclosures;
    }

    public AccountExtended agreements(List<Agreement> agreements) {
        this.agreements = agreements;
        return this;
    }

    public AccountExtended addAgreementsItem(Agreement agreementsItem) {
        if (this.agreements == null) {
            this.agreements = new ArrayList<Agreement>();
        }
        this.agreements.add(agreementsItem);
        return this;
    }

    @Nullable
    public List<Agreement> getAgreements() {
        return this.agreements;
    }

    public void setAgreements(List<Agreement> agreements) {
        this.agreements = agreements;
    }

    public AccountExtended documents(List<ApplicationDocument> documents) {
        this.documents = documents;
        return this;
    }

    public AccountExtended addDocumentsItem(ApplicationDocument documentsItem) {
        if (this.documents == null) {
            this.documents = new ArrayList<ApplicationDocument>();
        }
        this.documents.add(documentsItem);
        return this;
    }

    @Nullable
    public List<ApplicationDocument> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<ApplicationDocument> documents) {
        this.documents = documents;
    }

    public AccountExtended trustedContact(TrustedContact trustedContact) {
        this.trustedContact = trustedContact;
        return this;
    }

    @Nullable
    public TrustedContact getTrustedContact() {
        return this.trustedContact;
    }

    public void setTrustedContact(TrustedContact trustedContact) {
        this.trustedContact = trustedContact;
    }

    public AccountExtended accountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    @Nullable
    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public AccountExtended accountType(AccountType accountType) {
        this.accountType = accountType;
        return this;
    }

    @Nonnull
    public AccountType getAccountType() {
        return this.accountType;
    }

    public void setAccountType(AccountType accountType) {
        this.accountType = accountType;
    }

    public AccountExtended custodialAccountType(String custodialAccountType) {
        this.custodialAccountType = custodialAccountType;
        return this;
    }

    @Nullable
    public String getCustodialAccountType() {
        return this.custodialAccountType;
    }

    public void setCustodialAccountType(String custodialAccountType) {
        this.custodialAccountType = custodialAccountType;
    }

    public AccountExtended minorIdentity(CustodialAccountMinorIdentity minorIdentity) {
        this.minorIdentity = minorIdentity;
        return this;
    }

    @Nullable
    public CustodialAccountMinorIdentity getMinorIdentity() {
        return this.minorIdentity;
    }

    public void setMinorIdentity(CustodialAccountMinorIdentity minorIdentity) {
        this.minorIdentity = minorIdentity;
    }

    public AccountExtended tradingConfigurations(AccountConfigurations tradingConfigurations) {
        this.tradingConfigurations = tradingConfigurations;
        return this;
    }

    @Nullable
    public AccountConfigurations getTradingConfigurations() {
        return this.tradingConfigurations;
    }

    public void setTradingConfigurations(AccountConfigurations tradingConfigurations) {
        this.tradingConfigurations = tradingConfigurations;
    }

    public AccountExtended usd(USDBalances usd) {
        this.usd = usd;
        return this;
    }

    @Nullable
    public USDBalances getUsd() {
        return this.usd;
    }

    public void setUsd(USDBalances usd) {
        this.usd = usd;
    }

    public AccountExtended enabledAssets(List<AssetClass> enabledAssets) {
        this.enabledAssets = enabledAssets;
        return this;
    }

    public AccountExtended addEnabledAssetsItem(AssetClass enabledAssetsItem) {
        if (this.enabledAssets == null) {
            this.enabledAssets = new ArrayList<AssetClass>();
        }
        this.enabledAssets.add(enabledAssetsItem);
        return this;
    }

    @Nullable
    public List<AssetClass> getEnabledAssets() {
        return this.enabledAssets;
    }

    public void setEnabledAssets(List<AssetClass> enabledAssets) {
        this.enabledAssets = enabledAssets;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountExtended accountExtended = (AccountExtended)o;
        return Objects.equals(this.id, accountExtended.id) && Objects.equals(this.accountNumber, accountExtended.accountNumber) && Objects.equals((Object)this.status, (Object)accountExtended.status) && Objects.equals((Object)this.cryptoStatus, (Object)accountExtended.cryptoStatus) && Objects.equals(this.kycResult, accountExtended.kycResult) && Objects.equals(this.currency, accountExtended.currency) && Objects.equals(this.lastEquity, accountExtended.lastEquity) && Objects.equals(this.createdAt, accountExtended.createdAt) && Objects.equals(this.contact, accountExtended.contact) && Objects.equals(this.identity, accountExtended.identity) && Objects.equals(this.disclosures, accountExtended.disclosures) && Objects.equals(this.agreements, accountExtended.agreements) && Objects.equals(this.documents, accountExtended.documents) && Objects.equals(this.trustedContact, accountExtended.trustedContact) && Objects.equals(this.accountName, accountExtended.accountName) && Objects.equals((Object)this.accountType, (Object)accountExtended.accountType) && Objects.equals(this.custodialAccountType, accountExtended.custodialAccountType) && Objects.equals(this.minorIdentity, accountExtended.minorIdentity) && Objects.equals(this.tradingConfigurations, accountExtended.tradingConfigurations) && Objects.equals(this.usd, accountExtended.usd) && Objects.equals(this.enabledAssets, accountExtended.enabledAssets);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.accountNumber, this.status, this.cryptoStatus, this.kycResult, this.currency, this.lastEquity, this.createdAt, this.contact, this.identity, this.disclosures, this.agreements, this.documents, this.trustedContact, this.accountName, this.accountType, this.custodialAccountType, this.minorIdentity, this.tradingConfigurations, this.usd, this.enabledAssets});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountExtended {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    cryptoStatus: ").append(this.toIndentedString((Object)this.cryptoStatus)).append("\n");
        sb.append("    kycResult: ").append(this.toIndentedString(this.kycResult)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    lastEquity: ").append(this.toIndentedString(this.lastEquity)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    identity: ").append(this.toIndentedString(this.identity)).append("\n");
        sb.append("    disclosures: ").append(this.toIndentedString(this.disclosures)).append("\n");
        sb.append("    agreements: ").append(this.toIndentedString(this.agreements)).append("\n");
        sb.append("    documents: ").append(this.toIndentedString(this.documents)).append("\n");
        sb.append("    trustedContact: ").append(this.toIndentedString(this.trustedContact)).append("\n");
        sb.append("    accountName: ").append(this.toIndentedString(this.accountName)).append("\n");
        sb.append("    accountType: ").append(this.toIndentedString((Object)this.accountType)).append("\n");
        sb.append("    custodialAccountType: ").append(this.toIndentedString(this.custodialAccountType)).append("\n");
        sb.append("    minorIdentity: ").append(this.toIndentedString(this.minorIdentity)).append("\n");
        sb.append("    tradingConfigurations: ").append(this.toIndentedString(this.tradingConfigurations)).append("\n");
        sb.append("    usd: ").append(this.toIndentedString(this.usd)).append("\n");
        sb.append("    enabledAssets: ").append(this.toIndentedString(this.enabledAssets)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArraydocuments;
        int i;
        JsonArray jsonArrayagreements;
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in AccountExtended is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AccountExtended` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCOUNT_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_NUMBER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `account_number` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_NUMBER).toString()));
        }
        AccountStatus.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STATUS));
        if (jsonObj.get(SERIALIZED_NAME_CRYPTO_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_CRYPTO_STATUS).isJsonNull()) {
            AccountStatus.validateJsonElement(jsonObj.get(SERIALIZED_NAME_CRYPTO_STATUS));
        }
        if (jsonObj.get(SERIALIZED_NAME_KYC_RESULT) != null && !jsonObj.get(SERIALIZED_NAME_KYC_RESULT).isJsonNull()) {
            KYCResult.validateJsonElement(jsonObj.get(SERIALIZED_NAME_KYC_RESULT));
        }
        if (!jsonObj.get(SERIALIZED_NAME_CURRENCY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CURRENCY).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_LAST_EQUITY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `last_equity` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LAST_EQUITY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONTACT) != null && !jsonObj.get(SERIALIZED_NAME_CONTACT).isJsonNull()) {
            Contact.validateJsonElement(jsonObj.get(SERIALIZED_NAME_CONTACT));
        }
        if (jsonObj.get(SERIALIZED_NAME_IDENTITY) != null && !jsonObj.get(SERIALIZED_NAME_IDENTITY).isJsonNull()) {
            Identity.validateJsonElement(jsonObj.get(SERIALIZED_NAME_IDENTITY));
        }
        if (jsonObj.get(SERIALIZED_NAME_DISCLOSURES) != null && !jsonObj.get(SERIALIZED_NAME_DISCLOSURES).isJsonNull()) {
            Disclosures.validateJsonElement(jsonObj.get(SERIALIZED_NAME_DISCLOSURES));
        }
        if (jsonObj.get(SERIALIZED_NAME_AGREEMENTS) != null && !jsonObj.get(SERIALIZED_NAME_AGREEMENTS).isJsonNull() && (jsonArrayagreements = jsonObj.getAsJsonArray(SERIALIZED_NAME_AGREEMENTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_AGREEMENTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `agreements` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AGREEMENTS).toString()));
            }
            for (i = 0; i < jsonArrayagreements.size(); ++i) {
                Agreement.validateJsonElement(jsonArrayagreements.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_DOCUMENTS) != null && !jsonObj.get(SERIALIZED_NAME_DOCUMENTS).isJsonNull() && (jsonArraydocuments = jsonObj.getAsJsonArray(SERIALIZED_NAME_DOCUMENTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_DOCUMENTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `documents` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DOCUMENTS).toString()));
            }
            for (i = 0; i < jsonArraydocuments.size(); ++i) {
                ApplicationDocument.validateJsonElement(jsonArraydocuments.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_TRUSTED_CONTACT) != null && !jsonObj.get(SERIALIZED_NAME_TRUSTED_CONTACT).isJsonNull()) {
            TrustedContact.validateJsonElement(jsonObj.get(SERIALIZED_NAME_TRUSTED_CONTACT));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCOUNT_NAME) != null && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `account_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_NAME).toString()));
        }
        AccountType.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ACCOUNT_TYPE));
        if (jsonObj.get(SERIALIZED_NAME_CUSTODIAL_ACCOUNT_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_CUSTODIAL_ACCOUNT_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CUSTODIAL_ACCOUNT_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `custodial_account_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CUSTODIAL_ACCOUNT_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MINOR_IDENTITY) != null && !jsonObj.get(SERIALIZED_NAME_MINOR_IDENTITY).isJsonNull()) {
            CustodialAccountMinorIdentity.validateJsonElement(jsonObj.get(SERIALIZED_NAME_MINOR_IDENTITY));
        }
        if (jsonObj.get(SERIALIZED_NAME_TRADING_CONFIGURATIONS) != null && !jsonObj.get(SERIALIZED_NAME_TRADING_CONFIGURATIONS).isJsonNull()) {
            AccountConfigurations.validateJsonElement(jsonObj.get(SERIALIZED_NAME_TRADING_CONFIGURATIONS));
        }
        if (jsonObj.get(SERIALIZED_NAME_USD) != null && !jsonObj.get(SERIALIZED_NAME_USD).isJsonNull()) {
            USDBalances.validateJsonElement(jsonObj.get(SERIALIZED_NAME_USD));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENABLED_ASSETS) != null && !jsonObj.get(SERIALIZED_NAME_ENABLED_ASSETS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ENABLED_ASSETS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `enabled_assets` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENABLED_ASSETS).toString()));
        }
    }

    public static AccountExtended fromJson(String jsonString) throws IOException {
        return (AccountExtended)JSON.getGson().fromJson(jsonString, AccountExtended.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_NUMBER);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_CRYPTO_STATUS);
        openapiFields.add(SERIALIZED_NAME_KYC_RESULT);
        openapiFields.add(SERIALIZED_NAME_CURRENCY);
        openapiFields.add(SERIALIZED_NAME_LAST_EQUITY);
        openapiFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiFields.add(SERIALIZED_NAME_CONTACT);
        openapiFields.add(SERIALIZED_NAME_IDENTITY);
        openapiFields.add(SERIALIZED_NAME_DISCLOSURES);
        openapiFields.add(SERIALIZED_NAME_AGREEMENTS);
        openapiFields.add(SERIALIZED_NAME_DOCUMENTS);
        openapiFields.add(SERIALIZED_NAME_TRUSTED_CONTACT);
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_NAME);
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_TYPE);
        openapiFields.add(SERIALIZED_NAME_CUSTODIAL_ACCOUNT_TYPE);
        openapiFields.add(SERIALIZED_NAME_MINOR_IDENTITY);
        openapiFields.add(SERIALIZED_NAME_TRADING_CONFIGURATIONS);
        openapiFields.add(SERIALIZED_NAME_USD);
        openapiFields.add(SERIALIZED_NAME_ENABLED_ASSETS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_ACCOUNT_NUMBER);
        openapiRequiredFields.add(SERIALIZED_NAME_STATUS);
        openapiRequiredFields.add(SERIALIZED_NAME_CURRENCY);
        openapiRequiredFields.add(SERIALIZED_NAME_LAST_EQUITY);
        openapiRequiredFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiRequiredFields.add(SERIALIZED_NAME_ACCOUNT_TYPE);
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AccountExtended.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AccountExtended.class));
            return new TypeAdapter<AccountExtended>(){

                public void write(JsonWriter out, AccountExtended value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AccountExtended read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    AccountExtended.validateJsonElement(jsonElement);
                    return (AccountExtended)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

