/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.function.Predicate;

@JsonAdapter(value=Adapter.class)
public enum AccountType {
    TRADING("trading"),
    CUSTODIAL("custodial"),
    DONOR_ADVISED("donor_advised");

    private String value;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    private AccountType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AccountType fromValue(String value) {
        for (AccountType b : AccountType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        return null;
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        String value = jsonElement.getAsString();
        AccountType.fromValue(value);
    }

    static {
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class Adapter
    extends TypeAdapter<AccountType> {
        public void write(JsonWriter jsonWriter, AccountType enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public AccountType read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return AccountType.fromValue(value);
        }
    }
}

