/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.broker.JSON;
import net.jacobpeterson.alpaca.openapi.broker.model.ActivityType;
import net.jacobpeterson.alpaca.openapi.broker.model.OrderSide;
import net.jacobpeterson.alpaca.openapi.broker.model.OrderStatus;

public class Activity {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private UUID accountId;
    public static final String SERIALIZED_NAME_ACTIVITY_TYPE = "activity_type";
    @SerializedName(value="activity_type")
    private ActivityType activityType;
    public static final String SERIALIZED_NAME_TRANSACTION_TIME = "transaction_time";
    @SerializedName(value="transaction_time")
    private OffsetDateTime transactionTime;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_PRICE = "price";
    @SerializedName(value="price")
    private BigDecimal price;
    public static final String SERIALIZED_NAME_QTY = "qty";
    @SerializedName(value="qty")
    private BigDecimal qty;
    public static final String SERIALIZED_NAME_SIDE = "side";
    @SerializedName(value="side")
    private OrderSide side;
    public static final String SERIALIZED_NAME_SYMBOL = "symbol";
    @SerializedName(value="symbol")
    private String symbol;
    public static final String SERIALIZED_NAME_LEAVES_QTY = "leaves_qty";
    @SerializedName(value="leaves_qty")
    private BigDecimal leavesQty;
    public static final String SERIALIZED_NAME_ORDER_ID = "order_id";
    @SerializedName(value="order_id")
    private UUID orderId;
    public static final String SERIALIZED_NAME_CUM_QTY = "cum_qty";
    @SerializedName(value="cum_qty")
    private BigDecimal cumQty;
    public static final String SERIALIZED_NAME_ORDER_STATUS = "order_status";
    @SerializedName(value="order_status")
    private OrderStatus orderStatus;
    public static final String SERIALIZED_NAME_DATE = "date";
    @SerializedName(value="date")
    private LocalDate date;
    public static final String SERIALIZED_NAME_NET_AMOUNT = "net_amount";
    @SerializedName(value="net_amount")
    private BigDecimal netAmount;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private StatusEnum status;
    public static final String SERIALIZED_NAME_PER_SHARE_AMOUNT = "per_share_amount";
    @SerializedName(value="per_share_amount")
    private BigDecimal perShareAmount;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public Activity id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Activity accountId(UUID accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    public UUID getAccountId() {
        return this.accountId;
    }

    public void setAccountId(UUID accountId) {
        this.accountId = accountId;
    }

    public Activity activityType(ActivityType activityType) {
        this.activityType = activityType;
        return this;
    }

    @Nonnull
    public ActivityType getActivityType() {
        return this.activityType;
    }

    public void setActivityType(ActivityType activityType) {
        this.activityType = activityType;
    }

    public Activity transactionTime(OffsetDateTime transactionTime) {
        this.transactionTime = transactionTime;
        return this;
    }

    @Nullable
    public OffsetDateTime getTransactionTime() {
        return this.transactionTime;
    }

    public void setTransactionTime(OffsetDateTime transactionTime) {
        this.transactionTime = transactionTime;
    }

    public Activity type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Activity price(BigDecimal price) {
        this.price = price;
        return this;
    }

    @Nullable
    public BigDecimal getPrice() {
        return this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public Activity qty(BigDecimal qty) {
        this.qty = qty;
        return this;
    }

    @Nullable
    public BigDecimal getQty() {
        return this.qty;
    }

    public void setQty(BigDecimal qty) {
        this.qty = qty;
    }

    public Activity side(OrderSide side) {
        this.side = side;
        return this;
    }

    @Nullable
    public OrderSide getSide() {
        return this.side;
    }

    public void setSide(OrderSide side) {
        this.side = side;
    }

    public Activity symbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    @Nullable
    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public Activity leavesQty(BigDecimal leavesQty) {
        this.leavesQty = leavesQty;
        return this;
    }

    @Nullable
    public BigDecimal getLeavesQty() {
        return this.leavesQty;
    }

    public void setLeavesQty(BigDecimal leavesQty) {
        this.leavesQty = leavesQty;
    }

    public Activity orderId(UUID orderId) {
        this.orderId = orderId;
        return this;
    }

    @Nullable
    public UUID getOrderId() {
        return this.orderId;
    }

    public void setOrderId(UUID orderId) {
        this.orderId = orderId;
    }

    public Activity cumQty(BigDecimal cumQty) {
        this.cumQty = cumQty;
        return this;
    }

    @Nullable
    public BigDecimal getCumQty() {
        return this.cumQty;
    }

    public void setCumQty(BigDecimal cumQty) {
        this.cumQty = cumQty;
    }

    public Activity orderStatus(OrderStatus orderStatus) {
        this.orderStatus = orderStatus;
        return this;
    }

    @Nullable
    public OrderStatus getOrderStatus() {
        return this.orderStatus;
    }

    public void setOrderStatus(OrderStatus orderStatus) {
        this.orderStatus = orderStatus;
    }

    public Activity date(LocalDate date) {
        this.date = date;
        return this;
    }

    @Nullable
    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public Activity netAmount(BigDecimal netAmount) {
        this.netAmount = netAmount;
        return this;
    }

    @Nullable
    public BigDecimal getNetAmount() {
        return this.netAmount;
    }

    public void setNetAmount(BigDecimal netAmount) {
        this.netAmount = netAmount;
    }

    public Activity description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Activity status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nullable
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Activity perShareAmount(BigDecimal perShareAmount) {
        this.perShareAmount = perShareAmount;
        return this;
    }

    @Nullable
    public BigDecimal getPerShareAmount() {
        return this.perShareAmount;
    }

    public void setPerShareAmount(BigDecimal perShareAmount) {
        this.perShareAmount = perShareAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Activity activity = (Activity)o;
        return Objects.equals(this.id, activity.id) && Objects.equals(this.accountId, activity.accountId) && Objects.equals((Object)this.activityType, (Object)activity.activityType) && Objects.equals(this.transactionTime, activity.transactionTime) && Objects.equals((Object)this.type, (Object)activity.type) && Objects.equals(this.price, activity.price) && Objects.equals(this.qty, activity.qty) && Objects.equals((Object)this.side, (Object)activity.side) && Objects.equals(this.symbol, activity.symbol) && Objects.equals(this.leavesQty, activity.leavesQty) && Objects.equals(this.orderId, activity.orderId) && Objects.equals(this.cumQty, activity.cumQty) && Objects.equals((Object)this.orderStatus, (Object)activity.orderStatus) && Objects.equals(this.date, activity.date) && Objects.equals(this.netAmount, activity.netAmount) && Objects.equals(this.description, activity.description) && Objects.equals((Object)this.status, (Object)activity.status) && Objects.equals(this.perShareAmount, activity.perShareAmount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.accountId, this.activityType, this.transactionTime, this.type, this.price, this.qty, this.side, this.symbol, this.leavesQty, this.orderId, this.cumQty, this.orderStatus, this.date, this.netAmount, this.description, this.status, this.perShareAmount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Activity {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    activityType: ").append(this.toIndentedString((Object)this.activityType)).append("\n");
        sb.append("    transactionTime: ").append(this.toIndentedString(this.transactionTime)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    qty: ").append(this.toIndentedString(this.qty)).append("\n");
        sb.append("    side: ").append(this.toIndentedString((Object)this.side)).append("\n");
        sb.append("    symbol: ").append(this.toIndentedString(this.symbol)).append("\n");
        sb.append("    leavesQty: ").append(this.toIndentedString(this.leavesQty)).append("\n");
        sb.append("    orderId: ").append(this.toIndentedString(this.orderId)).append("\n");
        sb.append("    cumQty: ").append(this.toIndentedString(this.cumQty)).append("\n");
        sb.append("    orderStatus: ").append(this.toIndentedString((Object)this.orderStatus)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    netAmount: ").append(this.toIndentedString(this.netAmount)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    perShareAmount: ").append(this.toIndentedString(this.perShareAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in Activity is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Activity` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID) != null && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `account_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID).toString()));
        }
        ActivityType.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ACTIVITY_TYPE));
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_TYPE).isJsonNull()) {
            TypeEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_TYPE));
        }
        if (jsonObj.get(SERIALIZED_NAME_PRICE) != null && !jsonObj.get(SERIALIZED_NAME_PRICE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PRICE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `price` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PRICE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_QTY) != null && !jsonObj.get(SERIALIZED_NAME_QTY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_QTY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `qty` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_QTY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SIDE) != null && !jsonObj.get(SERIALIZED_NAME_SIDE).isJsonNull()) {
            OrderSide.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SIDE));
        }
        if (jsonObj.get(SERIALIZED_NAME_SYMBOL) != null && !jsonObj.get(SERIALIZED_NAME_SYMBOL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SYMBOL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SYMBOL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LEAVES_QTY) != null && !jsonObj.get(SERIALIZED_NAME_LEAVES_QTY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LEAVES_QTY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `leaves_qty` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LEAVES_QTY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORDER_ID) != null && !jsonObj.get(SERIALIZED_NAME_ORDER_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ORDER_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `order_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORDER_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CUM_QTY) != null && !jsonObj.get(SERIALIZED_NAME_CUM_QTY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CUM_QTY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `cum_qty` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CUM_QTY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORDER_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_ORDER_STATUS).isJsonNull()) {
            OrderStatus.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ORDER_STATUS));
        }
        if (jsonObj.get(SERIALIZED_NAME_NET_AMOUNT) != null && !jsonObj.get(SERIALIZED_NAME_NET_AMOUNT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NET_AMOUNT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `net_amount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NET_AMOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonNull()) {
            StatusEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STATUS));
        }
        if (jsonObj.get(SERIALIZED_NAME_PER_SHARE_AMOUNT) != null && !jsonObj.get(SERIALIZED_NAME_PER_SHARE_AMOUNT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PER_SHARE_AMOUNT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `per_share_amount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PER_SHARE_AMOUNT).toString()));
        }
    }

    public static Activity fromJson(String jsonString) throws IOException {
        return (Activity)JSON.getGson().fromJson(jsonString, Activity.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_ID);
        openapiFields.add(SERIALIZED_NAME_ACTIVITY_TYPE);
        openapiFields.add(SERIALIZED_NAME_TRANSACTION_TIME);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_PRICE);
        openapiFields.add(SERIALIZED_NAME_QTY);
        openapiFields.add(SERIALIZED_NAME_SIDE);
        openapiFields.add(SERIALIZED_NAME_SYMBOL);
        openapiFields.add(SERIALIZED_NAME_LEAVES_QTY);
        openapiFields.add(SERIALIZED_NAME_ORDER_ID);
        openapiFields.add(SERIALIZED_NAME_CUM_QTY);
        openapiFields.add(SERIALIZED_NAME_ORDER_STATUS);
        openapiFields.add(SERIALIZED_NAME_DATE);
        openapiFields.add(SERIALIZED_NAME_NET_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_PER_SHARE_AMOUNT);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_ACTIVITY_TYPE);
        validate = false;
        isValid = jsonElement -> true;
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        FILL("fill"),
        PARTIAL_FILL("partial_fill");

        private String value;
        public static boolean validate;
        public static Predicate<JsonElement> isValid;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            if (!isValid.test(jsonElement)) {
                throw new RuntimeException();
            }
            if (!validate) {
                return;
            }
            String value = jsonElement.getAsString();
            TypeEnum.fromValue(value);
        }

        static {
            validate = false;
            isValid = jsonElement -> true;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        EXECUTED("executed"),
        CORRECT("correct"),
        CANCELED("canceled");

        private String value;
        public static boolean validate;
        public static Predicate<JsonElement> isValid;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            if (!isValid.test(jsonElement)) {
                throw new RuntimeException();
            }
            if (!validate) {
                return;
            }
            String value = jsonElement.getAsString();
            StatusEnum.fromValue(value);
        }

        static {
            validate = false;
            isValid = jsonElement -> true;
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Activity.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Activity.class));
            return new TypeAdapter<Activity>(){

                public void write(JsonWriter out, Activity value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Activity read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    Activity.validateJsonElement(jsonElement);
                    return (Activity)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

