/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jacobpeterson.alpaca.openapi.broker.JSON;
import net.jacobpeterson.alpaca.openapi.broker.model.AbstractOpenApiSchema;
import net.jacobpeterson.alpaca.openapi.broker.model.NonTradeActivity;
import net.jacobpeterson.alpaca.openapi.broker.model.TradeActivity;

public class ActivityItem
extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(ActivityItem.class.getName());
    public static final Map<String, Class<?>> schemas = new HashMap();
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public ActivityItem() {
        super("anyOf", Boolean.FALSE);
    }

    public ActivityItem(NonTradeActivity o) {
        super("anyOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    public ActivityItem(TradeActivity o) {
        super("anyOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    @Override
    public Map<String, Class<?>> getSchemas() {
        return schemas;
    }

    @Override
    public void setActualInstance(Object instance) {
        if (instance instanceof TradeActivity) {
            super.setActualInstance(instance);
            return;
        }
        if (instance instanceof NonTradeActivity) {
            super.setActualInstance(instance);
            return;
        }
        throw new RuntimeException("Invalid instance type. Must be NonTradeActivity, TradeActivity");
    }

    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    public TradeActivity getTradeActivity() throws ClassCastException {
        return (TradeActivity)super.getActualInstance();
    }

    public NonTradeActivity getNonTradeActivity() throws ClassCastException {
        return (NonTradeActivity)super.getActualInstance();
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        ArrayList<String> errorMessages = new ArrayList<String>();
        try {
            TradeActivity.validateJsonElement(jsonElement);
            return;
        }
        catch (Exception e) {
            errorMessages.add(String.format("Deserialization for TradeActivity failed with `%s`.", e.getMessage()));
            try {
                NonTradeActivity.validateJsonElement(jsonElement);
                return;
            }
            catch (Exception e2) {
                errorMessages.add(String.format("Deserialization for NonTradeActivity failed with `%s`.", e2.getMessage()));
                throw new IOException(String.format("The JSON string is invalid for ActivityItem with anyOf schemas: NonTradeActivity, TradeActivity. no class match the result, expected at least 1. Detailed failure message for anyOf schemas: %s. JSON: %s", errorMessages, jsonElement.toString()));
            }
        }
    }

    public static ActivityItem fromJson(String jsonString) throws IOException {
        return (ActivityItem)JSON.getGson().fromJson(jsonString, ActivityItem.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        schemas.put("TradeActivity", TradeActivity.class);
        schemas.put("NonTradeActivity", NonTradeActivity.class);
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ActivityItem.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter adapterTradeActivity = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TradeActivity.class));
            final TypeAdapter adapterNonTradeActivity = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(NonTradeActivity.class));
            return new TypeAdapter<ActivityItem>(){

                public void write(JsonWriter out, ActivityItem value) throws IOException {
                    if (value == null || value.getActualInstance() == null) {
                        elementAdapter.write(out, null);
                        return;
                    }
                    if (value.getActualInstance() instanceof TradeActivity) {
                        JsonElement element = adapterTradeActivity.toJsonTree((Object)((TradeActivity)value.getActualInstance()));
                        elementAdapter.write(out, (Object)element);
                        return;
                    }
                    if (value.getActualInstance() instanceof NonTradeActivity) {
                        JsonElement element = adapterNonTradeActivity.toJsonTree((Object)((NonTradeActivity)value.getActualInstance()));
                        elementAdapter.write(out, (Object)element);
                        return;
                    }
                    throw new IOException("Failed to serialize as the type doesn't match anyOf schemae: NonTradeActivity, TradeActivity");
                }

                public ActivityItem read(JsonReader in) throws IOException {
                    Object deserialized = null;
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    ArrayList<String> errorMessages = new ArrayList<String>();
                    TypeAdapter actualAdapter = elementAdapter;
                    try {
                        TradeActivity.validateJsonElement(jsonElement);
                        actualAdapter = adapterTradeActivity;
                        ActivityItem ret = new ActivityItem();
                        ret.setActualInstance(actualAdapter.fromJsonTree(jsonElement));
                        return ret;
                    }
                    catch (Exception e) {
                        errorMessages.add(String.format("Deserialization for TradeActivity failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'TradeActivity'", e);
                        try {
                            NonTradeActivity.validateJsonElement(jsonElement);
                            actualAdapter = adapterNonTradeActivity;
                            ActivityItem ret = new ActivityItem();
                            ret.setActualInstance(actualAdapter.fromJsonTree(jsonElement));
                            return ret;
                        }
                        catch (Exception e2) {
                            errorMessages.add(String.format("Deserialization for NonTradeActivity failed with `%s`.", e2.getMessage()));
                            log.log(Level.FINER, "Input data does not match schema 'NonTradeActivity'", e2);
                            throw new IOException(String.format("Failed deserialization for ActivityItem: no class matches result, expected at least 1. Detailed failure message for anyOf schemas: %s. JSON: %s", errorMessages, jsonElement.toString()));
                        }
                    }
                }
            }.nullSafe();
        }
    }
}

