/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.broker.JSON;
import net.jacobpeterson.alpaca.openapi.broker.model.AgreementType;

public class Agreement {
    public static final String SERIALIZED_NAME_AGREEMENT = "agreement";
    @SerializedName(value="agreement")
    private AgreementType agreement;
    public static final String SERIALIZED_NAME_SIGNED_AT = "signed_at";
    @SerializedName(value="signed_at")
    private OffsetDateTime signedAt;
    public static final String SERIALIZED_NAME_IP_ADDRESS = "ip_address";
    @SerializedName(value="ip_address")
    private String ipAddress;
    public static final String SERIALIZED_NAME_REVISION = "revision";
    @SerializedName(value="revision")
    private String revision;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public Agreement agreement(AgreementType agreement) {
        this.agreement = agreement;
        return this;
    }

    @Nonnull
    public AgreementType getAgreement() {
        return this.agreement;
    }

    public void setAgreement(AgreementType agreement) {
        this.agreement = agreement;
    }

    public Agreement signedAt(OffsetDateTime signedAt) {
        this.signedAt = signedAt;
        return this;
    }

    @Nonnull
    public OffsetDateTime getSignedAt() {
        return this.signedAt;
    }

    public void setSignedAt(OffsetDateTime signedAt) {
        this.signedAt = signedAt;
    }

    public Agreement ipAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    @Nonnull
    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public Agreement revision(String revision) {
        this.revision = revision;
        return this;
    }

    @Nullable
    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Agreement agreement = (Agreement)o;
        return Objects.equals((Object)this.agreement, (Object)agreement.agreement) && Objects.equals(this.signedAt, agreement.signedAt) && Objects.equals(this.ipAddress, agreement.ipAddress) && Objects.equals(this.revision, agreement.revision);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.agreement, this.signedAt, this.ipAddress, this.revision});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Agreement {\n");
        sb.append("    agreement: ").append(this.toIndentedString((Object)this.agreement)).append("\n");
        sb.append("    signedAt: ").append(this.toIndentedString(this.signedAt)).append("\n");
        sb.append("    ipAddress: ").append(this.toIndentedString(this.ipAddress)).append("\n");
        sb.append("    revision: ").append(this.toIndentedString(this.revision)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in Agreement is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Agreement` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        AgreementType.validateJsonElement(jsonObj.get(SERIALIZED_NAME_AGREEMENT));
        if (!jsonObj.get(SERIALIZED_NAME_IP_ADDRESS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `ip_address` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IP_ADDRESS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REVISION) != null && !jsonObj.get(SERIALIZED_NAME_REVISION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REVISION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `revision` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REVISION).toString()));
        }
    }

    public static Agreement fromJson(String jsonString) throws IOException {
        return (Agreement)JSON.getGson().fromJson(jsonString, Agreement.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AGREEMENT);
        openapiFields.add(SERIALIZED_NAME_SIGNED_AT);
        openapiFields.add(SERIALIZED_NAME_IP_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_REVISION);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_AGREEMENT);
        openapiRequiredFields.add(SERIALIZED_NAME_SIGNED_AT);
        openapiRequiredFields.add(SERIALIZED_NAME_IP_ADDRESS);
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Agreement.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Agreement.class));
            return new TypeAdapter<Agreement>(){

                public void write(JsonWriter out, Agreement value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Agreement read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    Agreement.validateJsonElement(jsonElement);
                    return (Agreement)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

