/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.function.Predicate;

@JsonAdapter(value=Adapter.class)
public enum AgreementType {
    MARGIN_AGREEMENT("margin_agreement"),
    ACCOUNT_AGREEMENT("account_agreement"),
    CUSTOMER_AGREEMENT("customer_agreement"),
    CRYPTO_AGREEMENT("crypto_agreement"),
    OPTIONS_AGREEMENT("options_agreement");

    private String value;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    private AgreementType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AgreementType fromValue(String value) {
        for (AgreementType b : AgreementType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        return null;
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        String value = jsonElement.getAsString();
        AgreementType.fromValue(value);
    }

    static {
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class Adapter
    extends TypeAdapter<AgreementType> {
        public void write(JsonWriter jsonWriter, AgreementType enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public AgreementType read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return AgreementType.fromValue(value);
        }
    }
}

