/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.broker.JSON;
import net.jacobpeterson.alpaca.openapi.broker.model.AssetClass;
import net.jacobpeterson.alpaca.openapi.broker.model.Exchange;

public class Asset {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private UUID id;
    public static final String SERIALIZED_NAME_PROPERTY_CLASS = "class";
    @SerializedName(value="class")
    private AssetClass propertyClass;
    public static final String SERIALIZED_NAME_EXCHANGE = "exchange";
    @SerializedName(value="exchange")
    private Exchange exchange;
    public static final String SERIALIZED_NAME_SYMBOL = "symbol";
    @SerializedName(value="symbol")
    private String symbol;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private StatusEnum status;
    public static final String SERIALIZED_NAME_TRADABLE = "tradable";
    @SerializedName(value="tradable")
    private Boolean tradable;
    public static final String SERIALIZED_NAME_MARGINABLE = "marginable";
    @SerializedName(value="marginable")
    private Boolean marginable;
    public static final String SERIALIZED_NAME_SHORTABLE = "shortable";
    @SerializedName(value="shortable")
    private Boolean shortable;
    public static final String SERIALIZED_NAME_EASY_TO_BORROW = "easy_to_borrow";
    @SerializedName(value="easy_to_borrow")
    private Boolean easyToBorrow;
    public static final String SERIALIZED_NAME_FRACTIONABLE = "fractionable";
    @SerializedName(value="fractionable")
    private Boolean fractionable;
    public static final String SERIALIZED_NAME_LAST_CLOSE_PCT_CHANGE = "last_close_pct_change";
    @SerializedName(value="last_close_pct_change")
    private BigDecimal lastClosePctChange;
    public static final String SERIALIZED_NAME_LAST_PRICE = "last_price";
    @SerializedName(value="last_price")
    private BigDecimal lastPrice;
    public static final String SERIALIZED_NAME_LAST_CLOSE = "last_close";
    @SerializedName(value="last_close")
    private BigDecimal lastClose;
    public static final String SERIALIZED_NAME_MIN_ORDER_SIZE = "min_order_size";
    @SerializedName(value="min_order_size")
    private String minOrderSize;
    public static final String SERIALIZED_NAME_MIN_TRADE_INCREMENT = "min_trade_increment";
    @SerializedName(value="min_trade_increment")
    private String minTradeIncrement;
    public static final String SERIALIZED_NAME_PRICE_INCREMENT = "price_increment";
    @SerializedName(value="price_increment")
    private String priceIncrement;
    public static final String SERIALIZED_NAME_MAINTENANCE_MARGIN_REQUIREMENT = "maintenance_margin_requirement";
    @SerializedName(value="maintenance_margin_requirement")
    private BigDecimal maintenanceMarginRequirement;
    public static final String SERIALIZED_NAME_ATTRIBUTES = "attributes";
    @SerializedName(value="attributes")
    private List<AttributesEnum> attributes;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public Asset id(UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public Asset propertyClass(AssetClass propertyClass) {
        this.propertyClass = propertyClass;
        return this;
    }

    @Nonnull
    public AssetClass getPropertyClass() {
        return this.propertyClass;
    }

    public void setPropertyClass(AssetClass propertyClass) {
        this.propertyClass = propertyClass;
    }

    public Asset exchange(Exchange exchange) {
        this.exchange = exchange;
        return this;
    }

    @Nullable
    public Exchange getExchange() {
        return this.exchange;
    }

    public void setExchange(Exchange exchange) {
        this.exchange = exchange;
    }

    public Asset symbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    @Nonnull
    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public Asset name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Asset status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nullable
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Asset tradable(Boolean tradable) {
        this.tradable = tradable;
        return this;
    }

    @Nullable
    public Boolean getTradable() {
        return this.tradable;
    }

    public void setTradable(Boolean tradable) {
        this.tradable = tradable;
    }

    public Asset marginable(Boolean marginable) {
        this.marginable = marginable;
        return this;
    }

    @Nullable
    public Boolean getMarginable() {
        return this.marginable;
    }

    public void setMarginable(Boolean marginable) {
        this.marginable = marginable;
    }

    public Asset shortable(Boolean shortable) {
        this.shortable = shortable;
        return this;
    }

    @Nullable
    public Boolean getShortable() {
        return this.shortable;
    }

    public void setShortable(Boolean shortable) {
        this.shortable = shortable;
    }

    public Asset easyToBorrow(Boolean easyToBorrow) {
        this.easyToBorrow = easyToBorrow;
        return this;
    }

    @Nullable
    public Boolean getEasyToBorrow() {
        return this.easyToBorrow;
    }

    public void setEasyToBorrow(Boolean easyToBorrow) {
        this.easyToBorrow = easyToBorrow;
    }

    public Asset fractionable(Boolean fractionable) {
        this.fractionable = fractionable;
        return this;
    }

    @Nullable
    public Boolean getFractionable() {
        return this.fractionable;
    }

    public void setFractionable(Boolean fractionable) {
        this.fractionable = fractionable;
    }

    public Asset lastClosePctChange(BigDecimal lastClosePctChange) {
        this.lastClosePctChange = lastClosePctChange;
        return this;
    }

    @Nullable
    public BigDecimal getLastClosePctChange() {
        return this.lastClosePctChange;
    }

    public void setLastClosePctChange(BigDecimal lastClosePctChange) {
        this.lastClosePctChange = lastClosePctChange;
    }

    public Asset lastPrice(BigDecimal lastPrice) {
        this.lastPrice = lastPrice;
        return this;
    }

    @Nullable
    public BigDecimal getLastPrice() {
        return this.lastPrice;
    }

    public void setLastPrice(BigDecimal lastPrice) {
        this.lastPrice = lastPrice;
    }

    public Asset lastClose(BigDecimal lastClose) {
        this.lastClose = lastClose;
        return this;
    }

    @Nullable
    public BigDecimal getLastClose() {
        return this.lastClose;
    }

    public void setLastClose(BigDecimal lastClose) {
        this.lastClose = lastClose;
    }

    public Asset minOrderSize(String minOrderSize) {
        this.minOrderSize = minOrderSize;
        return this;
    }

    @Nullable
    public String getMinOrderSize() {
        return this.minOrderSize;
    }

    public void setMinOrderSize(String minOrderSize) {
        this.minOrderSize = minOrderSize;
    }

    public Asset minTradeIncrement(String minTradeIncrement) {
        this.minTradeIncrement = minTradeIncrement;
        return this;
    }

    @Nullable
    public String getMinTradeIncrement() {
        return this.minTradeIncrement;
    }

    public void setMinTradeIncrement(String minTradeIncrement) {
        this.minTradeIncrement = minTradeIncrement;
    }

    public Asset priceIncrement(String priceIncrement) {
        this.priceIncrement = priceIncrement;
        return this;
    }

    @Nullable
    public String getPriceIncrement() {
        return this.priceIncrement;
    }

    public void setPriceIncrement(String priceIncrement) {
        this.priceIncrement = priceIncrement;
    }

    public Asset maintenanceMarginRequirement(BigDecimal maintenanceMarginRequirement) {
        this.maintenanceMarginRequirement = maintenanceMarginRequirement;
        return this;
    }

    @Nullable
    public BigDecimal getMaintenanceMarginRequirement() {
        return this.maintenanceMarginRequirement;
    }

    public void setMaintenanceMarginRequirement(BigDecimal maintenanceMarginRequirement) {
        this.maintenanceMarginRequirement = maintenanceMarginRequirement;
    }

    public Asset attributes(List<AttributesEnum> attributes) {
        this.attributes = attributes;
        return this;
    }

    public Asset addAttributesItem(AttributesEnum attributesItem) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<AttributesEnum>();
        }
        this.attributes.add(attributesItem);
        return this;
    }

    @Nullable
    public List<AttributesEnum> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<AttributesEnum> attributes) {
        this.attributes = attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Asset asset = (Asset)o;
        return Objects.equals(this.id, asset.id) && Objects.equals((Object)this.propertyClass, (Object)asset.propertyClass) && Objects.equals((Object)this.exchange, (Object)asset.exchange) && Objects.equals(this.symbol, asset.symbol) && Objects.equals(this.name, asset.name) && Objects.equals((Object)this.status, (Object)asset.status) && Objects.equals(this.tradable, asset.tradable) && Objects.equals(this.marginable, asset.marginable) && Objects.equals(this.shortable, asset.shortable) && Objects.equals(this.easyToBorrow, asset.easyToBorrow) && Objects.equals(this.fractionable, asset.fractionable) && Objects.equals(this.lastClosePctChange, asset.lastClosePctChange) && Objects.equals(this.lastPrice, asset.lastPrice) && Objects.equals(this.lastClose, asset.lastClose) && Objects.equals(this.minOrderSize, asset.minOrderSize) && Objects.equals(this.minTradeIncrement, asset.minTradeIncrement) && Objects.equals(this.priceIncrement, asset.priceIncrement) && Objects.equals(this.maintenanceMarginRequirement, asset.maintenanceMarginRequirement) && Objects.equals(this.attributes, asset.attributes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.propertyClass, this.exchange, this.symbol, this.name, this.status, this.tradable, this.marginable, this.shortable, this.easyToBorrow, this.fractionable, this.lastClosePctChange, this.lastPrice, this.lastClose, this.minOrderSize, this.minTradeIncrement, this.priceIncrement, this.maintenanceMarginRequirement, this.attributes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Asset {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    propertyClass: ").append(this.toIndentedString((Object)this.propertyClass)).append("\n");
        sb.append("    exchange: ").append(this.toIndentedString((Object)this.exchange)).append("\n");
        sb.append("    symbol: ").append(this.toIndentedString(this.symbol)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    tradable: ").append(this.toIndentedString(this.tradable)).append("\n");
        sb.append("    marginable: ").append(this.toIndentedString(this.marginable)).append("\n");
        sb.append("    shortable: ").append(this.toIndentedString(this.shortable)).append("\n");
        sb.append("    easyToBorrow: ").append(this.toIndentedString(this.easyToBorrow)).append("\n");
        sb.append("    fractionable: ").append(this.toIndentedString(this.fractionable)).append("\n");
        sb.append("    lastClosePctChange: ").append(this.toIndentedString(this.lastClosePctChange)).append("\n");
        sb.append("    lastPrice: ").append(this.toIndentedString(this.lastPrice)).append("\n");
        sb.append("    lastClose: ").append(this.toIndentedString(this.lastClose)).append("\n");
        sb.append("    minOrderSize: ").append(this.toIndentedString(this.minOrderSize)).append("\n");
        sb.append("    minTradeIncrement: ").append(this.toIndentedString(this.minTradeIncrement)).append("\n");
        sb.append("    priceIncrement: ").append(this.toIndentedString(this.priceIncrement)).append("\n");
        sb.append("    maintenanceMarginRequirement: ").append(this.toIndentedString(this.maintenanceMarginRequirement)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in Asset is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Asset` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        AssetClass.validateJsonElement(jsonObj.get(SERIALIZED_NAME_PROPERTY_CLASS));
        if (jsonObj.get(SERIALIZED_NAME_EXCHANGE) != null && !jsonObj.get(SERIALIZED_NAME_EXCHANGE).isJsonNull()) {
            Exchange.validateJsonElement(jsonObj.get(SERIALIZED_NAME_EXCHANGE));
        }
        if (!jsonObj.get(SERIALIZED_NAME_SYMBOL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SYMBOL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonNull()) {
            StatusEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STATUS));
        }
        if (jsonObj.get(SERIALIZED_NAME_LAST_CLOSE_PCT_CHANGE) != null && !jsonObj.get(SERIALIZED_NAME_LAST_CLOSE_PCT_CHANGE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LAST_CLOSE_PCT_CHANGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `last_close_pct_change` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LAST_CLOSE_PCT_CHANGE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LAST_PRICE) != null && !jsonObj.get(SERIALIZED_NAME_LAST_PRICE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LAST_PRICE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `last_price` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LAST_PRICE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LAST_CLOSE) != null && !jsonObj.get(SERIALIZED_NAME_LAST_CLOSE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LAST_CLOSE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `last_close` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LAST_CLOSE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MIN_ORDER_SIZE) != null && !jsonObj.get(SERIALIZED_NAME_MIN_ORDER_SIZE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MIN_ORDER_SIZE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `min_order_size` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MIN_ORDER_SIZE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MIN_TRADE_INCREMENT) != null && !jsonObj.get(SERIALIZED_NAME_MIN_TRADE_INCREMENT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MIN_TRADE_INCREMENT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `min_trade_increment` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MIN_TRADE_INCREMENT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PRICE_INCREMENT) != null && !jsonObj.get(SERIALIZED_NAME_PRICE_INCREMENT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PRICE_INCREMENT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `price_increment` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PRICE_INCREMENT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ATTRIBUTES) != null && !jsonObj.get(SERIALIZED_NAME_ATTRIBUTES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ATTRIBUTES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `attributes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ATTRIBUTES).toString()));
        }
    }

    public static Asset fromJson(String jsonString) throws IOException {
        return (Asset)JSON.getGson().fromJson(jsonString, Asset.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_PROPERTY_CLASS);
        openapiFields.add(SERIALIZED_NAME_EXCHANGE);
        openapiFields.add(SERIALIZED_NAME_SYMBOL);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_TRADABLE);
        openapiFields.add(SERIALIZED_NAME_MARGINABLE);
        openapiFields.add(SERIALIZED_NAME_SHORTABLE);
        openapiFields.add(SERIALIZED_NAME_EASY_TO_BORROW);
        openapiFields.add(SERIALIZED_NAME_FRACTIONABLE);
        openapiFields.add(SERIALIZED_NAME_LAST_CLOSE_PCT_CHANGE);
        openapiFields.add(SERIALIZED_NAME_LAST_PRICE);
        openapiFields.add(SERIALIZED_NAME_LAST_CLOSE);
        openapiFields.add(SERIALIZED_NAME_MIN_ORDER_SIZE);
        openapiFields.add(SERIALIZED_NAME_MIN_TRADE_INCREMENT);
        openapiFields.add(SERIALIZED_NAME_PRICE_INCREMENT);
        openapiFields.add(SERIALIZED_NAME_MAINTENANCE_MARGIN_REQUIREMENT);
        openapiFields.add(SERIALIZED_NAME_ATTRIBUTES);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_PROPERTY_CLASS);
        openapiRequiredFields.add(SERIALIZED_NAME_SYMBOL);
        validate = false;
        isValid = jsonElement -> true;
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        ACTIVE("active"),
        INACTIVE("inactive");

        private String value;
        public static boolean validate;
        public static Predicate<JsonElement> isValid;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            if (!isValid.test(jsonElement)) {
                throw new RuntimeException();
            }
            if (!validate) {
                return;
            }
            String value = jsonElement.getAsString();
            StatusEnum.fromValue(value);
        }

        static {
            validate = false;
            isValid = jsonElement -> true;
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Asset.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Asset.class));
            return new TypeAdapter<Asset>(){

                public void write(JsonWriter out, Asset value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Asset read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    Asset.validateJsonElement(jsonElement);
                    return (Asset)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AttributesEnum {
        PTP_NO_EXCEPTION("ptp_no_exception"),
        PTP_WITH_EXCEPTION("ptp_with_exception"),
        IPO("ipo"),
        OPTIONS_ENABLED("options_enabled");

        private String value;
        public static boolean validate;
        public static Predicate<JsonElement> isValid;

        private AttributesEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AttributesEnum fromValue(String value) {
            for (AttributesEnum b : AttributesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            if (!isValid.test(jsonElement)) {
                throw new RuntimeException();
            }
            if (!validate) {
                return;
            }
            String value = jsonElement.getAsString();
            AttributesEnum.fromValue(value);
        }

        static {
            validate = false;
            isValid = jsonElement -> true;
        }

        public static class Adapter
        extends TypeAdapter<AttributesEnum> {
            public void write(JsonWriter jsonWriter, AttributesEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AttributesEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AttributesEnum.fromValue(value);
            }
        }
    }
}

