/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.broker.JSON;
import net.jacobpeterson.alpaca.openapi.broker.model.BatchJournalRequestEntriesInner;

public class BatchJournalRequest {
    public static final String SERIALIZED_NAME_ENTRY_TYPE = "entry_type";
    @SerializedName(value="entry_type")
    private EntryTypeEnum entryType;
    public static final String SERIALIZED_NAME_FROM_ACCOUNT = "from_account";
    @SerializedName(value="from_account")
    private UUID fromAccount;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_ENTRIES = "entries";
    @SerializedName(value="entries")
    private List<BatchJournalRequestEntriesInner> entries = new ArrayList<BatchJournalRequestEntriesInner>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public BatchJournalRequest entryType(EntryTypeEnum entryType) {
        this.entryType = entryType;
        return this;
    }

    @Nonnull
    public EntryTypeEnum getEntryType() {
        return this.entryType;
    }

    public void setEntryType(EntryTypeEnum entryType) {
        this.entryType = entryType;
    }

    public BatchJournalRequest fromAccount(UUID fromAccount) {
        this.fromAccount = fromAccount;
        return this;
    }

    @Nonnull
    public UUID getFromAccount() {
        return this.fromAccount;
    }

    public void setFromAccount(UUID fromAccount) {
        this.fromAccount = fromAccount;
    }

    public BatchJournalRequest description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BatchJournalRequest entries(List<BatchJournalRequestEntriesInner> entries) {
        this.entries = entries;
        return this;
    }

    public BatchJournalRequest addEntriesItem(BatchJournalRequestEntriesInner entriesItem) {
        if (this.entries == null) {
            this.entries = new ArrayList<BatchJournalRequestEntriesInner>();
        }
        this.entries.add(entriesItem);
        return this;
    }

    @Nonnull
    public List<BatchJournalRequestEntriesInner> getEntries() {
        return this.entries;
    }

    public void setEntries(List<BatchJournalRequestEntriesInner> entries) {
        this.entries = entries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchJournalRequest batchJournalRequest = (BatchJournalRequest)o;
        return Objects.equals((Object)this.entryType, (Object)batchJournalRequest.entryType) && Objects.equals(this.fromAccount, batchJournalRequest.fromAccount) && Objects.equals(this.description, batchJournalRequest.description) && Objects.equals(this.entries, batchJournalRequest.entries);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.entryType, this.fromAccount, this.description, this.entries});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BatchJournalRequest {\n");
        sb.append("    entryType: ").append(this.toIndentedString((Object)this.entryType)).append("\n");
        sb.append("    fromAccount: ").append(this.toIndentedString(this.fromAccount)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    entries: ").append(this.toIndentedString(this.entries)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in BatchJournalRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `BatchJournalRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_ENTRY_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `entry_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENTRY_TYPE).toString()));
        }
        EntryTypeEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ENTRY_TYPE));
        if (!jsonObj.get(SERIALIZED_NAME_FROM_ACCOUNT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `from_account` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FROM_ACCOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_ENTRIES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `entries` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENTRIES).toString()));
        }
        JsonArray jsonArrayentries = jsonObj.getAsJsonArray(SERIALIZED_NAME_ENTRIES);
        for (int i = 0; i < jsonArrayentries.size(); ++i) {
            BatchJournalRequestEntriesInner.validateJsonElement(jsonArrayentries.get(i));
        }
    }

    public static BatchJournalRequest fromJson(String jsonString) throws IOException {
        return (BatchJournalRequest)JSON.getGson().fromJson(jsonString, BatchJournalRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ENTRY_TYPE);
        openapiFields.add(SERIALIZED_NAME_FROM_ACCOUNT);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_ENTRIES);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ENTRY_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_FROM_ACCOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_ENTRIES);
        validate = false;
        isValid = jsonElement -> true;
    }

    @JsonAdapter(value=Adapter.class)
    public static enum EntryTypeEnum {
        JNLC("JNLC");

        private String value;
        public static boolean validate;
        public static Predicate<JsonElement> isValid;

        private EntryTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static EntryTypeEnum fromValue(String value) {
            for (EntryTypeEnum b : EntryTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            if (!isValid.test(jsonElement)) {
                throw new RuntimeException();
            }
            if (!validate) {
                return;
            }
            String value = jsonElement.getAsString();
            EntryTypeEnum.fromValue(value);
        }

        static {
            validate = false;
            isValid = jsonElement -> true;
        }

        public static class Adapter
        extends TypeAdapter<EntryTypeEnum> {
            public void write(JsonWriter jsonWriter, EntryTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public EntryTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return EntryTypeEnum.fromValue(value);
            }
        }
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!BatchJournalRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(BatchJournalRequest.class));
            return new TypeAdapter<BatchJournalRequest>(){

                public void write(JsonWriter out, BatchJournalRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public BatchJournalRequest read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    BatchJournalRequest.validateJsonElement(jsonElement);
                    return (BatchJournalRequest)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

