/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.broker.JSON;
import net.jacobpeterson.alpaca.openapi.broker.model.CIPDocument;
import net.jacobpeterson.alpaca.openapi.broker.model.CIPIdentity;
import net.jacobpeterson.alpaca.openapi.broker.model.CIPKYC;
import net.jacobpeterson.alpaca.openapi.broker.model.CIPPhoto;
import net.jacobpeterson.alpaca.openapi.broker.model.CIPWatchlist;

public class CIPInfo {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private UUID id;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private UUID accountId;
    public static final String SERIALIZED_NAME_PROVIDER_NAME = "provider_name";
    @SerializedName(value="provider_name")
    private List<String> providerName;
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_UPDATED_AT = "updated_at";
    @SerializedName(value="updated_at")
    private OffsetDateTime updatedAt;
    public static final String SERIALIZED_NAME_KYC = "kyc";
    @SerializedName(value="kyc")
    private CIPKYC kyc;
    public static final String SERIALIZED_NAME_DOCUMENT = "document";
    @SerializedName(value="document")
    private CIPDocument document;
    public static final String SERIALIZED_NAME_PHOTO = "photo";
    @SerializedName(value="photo")
    private CIPPhoto photo;
    public static final String SERIALIZED_NAME_IDENTITY = "identity";
    @SerializedName(value="identity")
    private CIPIdentity identity;
    public static final String SERIALIZED_NAME_WATCHLIST = "watchlist";
    @SerializedName(value="watchlist")
    private CIPWatchlist watchlist;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public CIPInfo id(UUID id) {
        this.id = id;
        return this;
    }

    @Nullable
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public CIPInfo accountId(UUID accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    public UUID getAccountId() {
        return this.accountId;
    }

    public void setAccountId(UUID accountId) {
        this.accountId = accountId;
    }

    public CIPInfo providerName(List<String> providerName) {
        this.providerName = providerName;
        return this;
    }

    public CIPInfo addProviderNameItem(String providerNameItem) {
        if (this.providerName == null) {
            this.providerName = new ArrayList<String>();
        }
        this.providerName.add(providerNameItem);
        return this;
    }

    @Nullable
    public List<String> getProviderName() {
        return this.providerName;
    }

    public void setProviderName(List<String> providerName) {
        this.providerName = providerName;
    }

    public CIPInfo createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public CIPInfo updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public CIPInfo kyc(CIPKYC kyc) {
        this.kyc = kyc;
        return this;
    }

    @Nullable
    public CIPKYC getKyc() {
        return this.kyc;
    }

    public void setKyc(CIPKYC kyc) {
        this.kyc = kyc;
    }

    public CIPInfo document(CIPDocument document) {
        this.document = document;
        return this;
    }

    @Nullable
    public CIPDocument getDocument() {
        return this.document;
    }

    public void setDocument(CIPDocument document) {
        this.document = document;
    }

    public CIPInfo photo(CIPPhoto photo) {
        this.photo = photo;
        return this;
    }

    @Nullable
    public CIPPhoto getPhoto() {
        return this.photo;
    }

    public void setPhoto(CIPPhoto photo) {
        this.photo = photo;
    }

    public CIPInfo identity(CIPIdentity identity) {
        this.identity = identity;
        return this;
    }

    @Nullable
    public CIPIdentity getIdentity() {
        return this.identity;
    }

    public void setIdentity(CIPIdentity identity) {
        this.identity = identity;
    }

    public CIPInfo watchlist(CIPWatchlist watchlist) {
        this.watchlist = watchlist;
        return this;
    }

    @Nullable
    public CIPWatchlist getWatchlist() {
        return this.watchlist;
    }

    public void setWatchlist(CIPWatchlist watchlist) {
        this.watchlist = watchlist;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CIPInfo ciPInfo = (CIPInfo)o;
        return Objects.equals(this.id, ciPInfo.id) && Objects.equals(this.accountId, ciPInfo.accountId) && Objects.equals(this.providerName, ciPInfo.providerName) && Objects.equals(this.createdAt, ciPInfo.createdAt) && Objects.equals(this.updatedAt, ciPInfo.updatedAt) && Objects.equals(this.kyc, ciPInfo.kyc) && Objects.equals(this.document, ciPInfo.document) && Objects.equals(this.photo, ciPInfo.photo) && Objects.equals(this.identity, ciPInfo.identity) && Objects.equals(this.watchlist, ciPInfo.watchlist);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.accountId, this.providerName, this.createdAt, this.updatedAt, this.kyc, this.document, this.photo, this.identity, this.watchlist);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CIPInfo {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    providerName: ").append(this.toIndentedString(this.providerName)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    kyc: ").append(this.toIndentedString(this.kyc)).append("\n");
        sb.append("    document: ").append(this.toIndentedString(this.document)).append("\n");
        sb.append("    photo: ").append(this.toIndentedString(this.photo)).append("\n");
        sb.append("    identity: ").append(this.toIndentedString(this.identity)).append("\n");
        sb.append("    watchlist: ").append(this.toIndentedString(this.watchlist)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in CIPInfo is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CIPInfo` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID) != null && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `account_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PROVIDER_NAME) != null && !jsonObj.get(SERIALIZED_NAME_PROVIDER_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PROVIDER_NAME).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `provider_name` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PROVIDER_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KYC) != null && !jsonObj.get(SERIALIZED_NAME_KYC).isJsonNull()) {
            CIPKYC.validateJsonElement(jsonObj.get(SERIALIZED_NAME_KYC));
        }
        if (jsonObj.get(SERIALIZED_NAME_DOCUMENT) != null && !jsonObj.get(SERIALIZED_NAME_DOCUMENT).isJsonNull()) {
            CIPDocument.validateJsonElement(jsonObj.get(SERIALIZED_NAME_DOCUMENT));
        }
        if (jsonObj.get(SERIALIZED_NAME_PHOTO) != null && !jsonObj.get(SERIALIZED_NAME_PHOTO).isJsonNull()) {
            CIPPhoto.validateJsonElement(jsonObj.get(SERIALIZED_NAME_PHOTO));
        }
        if (jsonObj.get(SERIALIZED_NAME_IDENTITY) != null && !jsonObj.get(SERIALIZED_NAME_IDENTITY).isJsonNull()) {
            CIPIdentity.validateJsonElement(jsonObj.get(SERIALIZED_NAME_IDENTITY));
        }
        if (jsonObj.get(SERIALIZED_NAME_WATCHLIST) != null && !jsonObj.get(SERIALIZED_NAME_WATCHLIST).isJsonNull()) {
            CIPWatchlist.validateJsonElement(jsonObj.get(SERIALIZED_NAME_WATCHLIST));
        }
    }

    public static CIPInfo fromJson(String jsonString) throws IOException {
        return (CIPInfo)JSON.getGson().fromJson(jsonString, CIPInfo.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_ID);
        openapiFields.add(SERIALIZED_NAME_PROVIDER_NAME);
        openapiFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiFields.add(SERIALIZED_NAME_UPDATED_AT);
        openapiFields.add(SERIALIZED_NAME_KYC);
        openapiFields.add(SERIALIZED_NAME_DOCUMENT);
        openapiFields.add(SERIALIZED_NAME_PHOTO);
        openapiFields.add(SERIALIZED_NAME_IDENTITY);
        openapiFields.add(SERIALIZED_NAME_WATCHLIST);
        openapiRequiredFields = new HashSet();
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CIPInfo.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CIPInfo.class));
            return new TypeAdapter<CIPInfo>(){

                public void write(JsonWriter out, CIPInfo value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CIPInfo read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    CIPInfo.validateJsonElement(jsonElement);
                    return (CIPInfo)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

