/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.broker.JSON;

public class Contact {
    public static final String SERIALIZED_NAME_EMAIL_ADDRESS = "email_address";
    @SerializedName(value="email_address")
    private String emailAddress;
    public static final String SERIALIZED_NAME_PHONE_NUMBER = "phone_number";
    @SerializedName(value="phone_number")
    private String phoneNumber;
    public static final String SERIALIZED_NAME_STREET_ADDRESS = "street_address";
    @SerializedName(value="street_address")
    private List<String> streetAddress = new ArrayList<String>();
    public static final String SERIALIZED_NAME_UNIT = "unit";
    @SerializedName(value="unit")
    private String unit;
    public static final String SERIALIZED_NAME_CITY = "city";
    @SerializedName(value="city")
    private String city;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private String state;
    public static final String SERIALIZED_NAME_POSTAL_CODE = "postal_code";
    @SerializedName(value="postal_code")
    private String postalCode;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public Contact emailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @Nonnull
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public Contact phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @Nonnull
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public Contact streetAddress(List<String> streetAddress) {
        this.streetAddress = streetAddress;
        return this;
    }

    public Contact addStreetAddressItem(String streetAddressItem) {
        if (this.streetAddress == null) {
            this.streetAddress = new ArrayList<String>();
        }
        this.streetAddress.add(streetAddressItem);
        return this;
    }

    @Nonnull
    public List<String> getStreetAddress() {
        return this.streetAddress;
    }

    public void setStreetAddress(List<String> streetAddress) {
        this.streetAddress = streetAddress;
    }

    public Contact unit(String unit) {
        this.unit = unit;
        return this;
    }

    @Nullable
    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public Contact city(String city) {
        this.city = city;
        return this;
    }

    @Nullable
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public Contact state(String state) {
        this.state = state;
        return this;
    }

    @Nullable
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Contact postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @Nullable
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Contact contact = (Contact)o;
        return Objects.equals(this.emailAddress, contact.emailAddress) && Objects.equals(this.phoneNumber, contact.phoneNumber) && Objects.equals(this.streetAddress, contact.streetAddress) && Objects.equals(this.unit, contact.unit) && Objects.equals(this.city, contact.city) && Objects.equals(this.state, contact.state) && Objects.equals(this.postalCode, contact.postalCode);
    }

    public int hashCode() {
        return Objects.hash(this.emailAddress, this.phoneNumber, this.streetAddress, this.unit, this.city, this.state, this.postalCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Contact {\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    streetAddress: ").append(this.toIndentedString(this.streetAddress)).append("\n");
        sb.append("    unit: ").append(this.toIndentedString(this.unit)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in Contact is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Contact` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_EMAIL_ADDRESS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `email_address` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EMAIL_ADDRESS).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_PHONE_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `phone_number` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PHONE_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STREET_ADDRESS) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_STREET_ADDRESS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `street_address` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STREET_ADDRESS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UNIT) != null && !jsonObj.get(SERIALIZED_NAME_UNIT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_UNIT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `unit` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UNIT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CITY) != null && !jsonObj.get(SERIALIZED_NAME_CITY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CITY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `city` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CITY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATE) != null && !jsonObj.get(SERIALIZED_NAME_STATE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_STATE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `state` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_POSTAL_CODE) != null && !jsonObj.get(SERIALIZED_NAME_POSTAL_CODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_POSTAL_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `postal_code` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_POSTAL_CODE).toString()));
        }
    }

    public static Contact fromJson(String jsonString) throws IOException {
        return (Contact)JSON.getGson().fromJson(jsonString, Contact.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_EMAIL_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_PHONE_NUMBER);
        openapiFields.add(SERIALIZED_NAME_STREET_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_UNIT);
        openapiFields.add(SERIALIZED_NAME_CITY);
        openapiFields.add(SERIALIZED_NAME_STATE);
        openapiFields.add(SERIALIZED_NAME_POSTAL_CODE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_EMAIL_ADDRESS);
        openapiRequiredFields.add(SERIALIZED_NAME_PHONE_NUMBER);
        openapiRequiredFields.add(SERIALIZED_NAME_STREET_ADDRESS);
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Contact.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Contact.class));
            return new TypeAdapter<Contact>(){

                public void write(JsonWriter out, Contact value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Contact read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    Contact.validateJsonElement(jsonElement);
                    return (Contact)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

