/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.broker.JSON;

public class CountryInfo {
    public static final String SERIALIZED_NAME_FULL_NAME = "full_name";
    @SerializedName(value="full_name")
    private String fullName;
    public static final String SERIALIZED_NAME_CRYPTO_RISK_RATING = "crypto_risk_rating";
    @SerializedName(value="crypto_risk_rating")
    private CryptoRiskRatingEnum cryptoRiskRating;
    public static final String SERIALIZED_NAME_SECURITIES_RISK_RATING = "securities_risk_rating";
    @SerializedName(value="securities_risk_rating")
    private SecuritiesRiskRatingEnum securitiesRiskRating;
    public static final String SERIALIZED_NAME_CRYPTO_SUPPORTED_STATES = "crypto_supported_states";
    @SerializedName(value="crypto_supported_states")
    private List<String> cryptoSupportedStates;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public CountryInfo fullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    @Nonnull
    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public CountryInfo cryptoRiskRating(CryptoRiskRatingEnum cryptoRiskRating) {
        this.cryptoRiskRating = cryptoRiskRating;
        return this;
    }

    @Nonnull
    public CryptoRiskRatingEnum getCryptoRiskRating() {
        return this.cryptoRiskRating;
    }

    public void setCryptoRiskRating(CryptoRiskRatingEnum cryptoRiskRating) {
        this.cryptoRiskRating = cryptoRiskRating;
    }

    public CountryInfo securitiesRiskRating(SecuritiesRiskRatingEnum securitiesRiskRating) {
        this.securitiesRiskRating = securitiesRiskRating;
        return this;
    }

    @Nonnull
    public SecuritiesRiskRatingEnum getSecuritiesRiskRating() {
        return this.securitiesRiskRating;
    }

    public void setSecuritiesRiskRating(SecuritiesRiskRatingEnum securitiesRiskRating) {
        this.securitiesRiskRating = securitiesRiskRating;
    }

    public CountryInfo cryptoSupportedStates(List<String> cryptoSupportedStates) {
        this.cryptoSupportedStates = cryptoSupportedStates;
        return this;
    }

    public CountryInfo addCryptoSupportedStatesItem(String cryptoSupportedStatesItem) {
        if (this.cryptoSupportedStates == null) {
            this.cryptoSupportedStates = new ArrayList<String>();
        }
        this.cryptoSupportedStates.add(cryptoSupportedStatesItem);
        return this;
    }

    @Nullable
    public List<String> getCryptoSupportedStates() {
        return this.cryptoSupportedStates;
    }

    public void setCryptoSupportedStates(List<String> cryptoSupportedStates) {
        this.cryptoSupportedStates = cryptoSupportedStates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountryInfo countryInfo = (CountryInfo)o;
        return Objects.equals(this.fullName, countryInfo.fullName) && Objects.equals((Object)this.cryptoRiskRating, (Object)countryInfo.cryptoRiskRating) && Objects.equals((Object)this.securitiesRiskRating, (Object)countryInfo.securitiesRiskRating) && Objects.equals(this.cryptoSupportedStates, countryInfo.cryptoSupportedStates);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fullName, this.cryptoRiskRating, this.securitiesRiskRating, this.cryptoSupportedStates});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CountryInfo {\n");
        sb.append("    fullName: ").append(this.toIndentedString(this.fullName)).append("\n");
        sb.append("    cryptoRiskRating: ").append(this.toIndentedString((Object)this.cryptoRiskRating)).append("\n");
        sb.append("    securitiesRiskRating: ").append(this.toIndentedString((Object)this.securitiesRiskRating)).append("\n");
        sb.append("    cryptoSupportedStates: ").append(this.toIndentedString(this.cryptoSupportedStates)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in CountryInfo is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CountryInfo` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_FULL_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `full_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FULL_NAME).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_CRYPTO_RISK_RATING).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `crypto_risk_rating` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CRYPTO_RISK_RATING).toString()));
        }
        CryptoRiskRatingEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_CRYPTO_RISK_RATING));
        if (!jsonObj.get(SERIALIZED_NAME_SECURITIES_RISK_RATING).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `securities_risk_rating` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SECURITIES_RISK_RATING).toString()));
        }
        SecuritiesRiskRatingEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SECURITIES_RISK_RATING));
        if (jsonObj.get(SERIALIZED_NAME_CRYPTO_SUPPORTED_STATES) != null && !jsonObj.get(SERIALIZED_NAME_CRYPTO_SUPPORTED_STATES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CRYPTO_SUPPORTED_STATES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `crypto_supported_states` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CRYPTO_SUPPORTED_STATES).toString()));
        }
    }

    public static CountryInfo fromJson(String jsonString) throws IOException {
        return (CountryInfo)JSON.getGson().fromJson(jsonString, CountryInfo.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_FULL_NAME);
        openapiFields.add(SERIALIZED_NAME_CRYPTO_RISK_RATING);
        openapiFields.add(SERIALIZED_NAME_SECURITIES_RISK_RATING);
        openapiFields.add(SERIALIZED_NAME_CRYPTO_SUPPORTED_STATES);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_FULL_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_CRYPTO_RISK_RATING);
        openapiRequiredFields.add(SERIALIZED_NAME_SECURITIES_RISK_RATING);
        validate = false;
        isValid = jsonElement -> true;
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CryptoRiskRatingEnum {
        LOW("low"),
        MEDIUM("medium"),
        HIGH("high"),
        PROHIBITED("prohibited");

        private String value;
        public static boolean validate;
        public static Predicate<JsonElement> isValid;

        private CryptoRiskRatingEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CryptoRiskRatingEnum fromValue(String value) {
            for (CryptoRiskRatingEnum b : CryptoRiskRatingEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            if (!isValid.test(jsonElement)) {
                throw new RuntimeException();
            }
            if (!validate) {
                return;
            }
            String value = jsonElement.getAsString();
            CryptoRiskRatingEnum.fromValue(value);
        }

        static {
            validate = false;
            isValid = jsonElement -> true;
        }

        public static class Adapter
        extends TypeAdapter<CryptoRiskRatingEnum> {
            public void write(JsonWriter jsonWriter, CryptoRiskRatingEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CryptoRiskRatingEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CryptoRiskRatingEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SecuritiesRiskRatingEnum {
        LOW("low"),
        MEDIUM("medium"),
        HIGH("high"),
        PROHIBITED("prohibited");

        private String value;
        public static boolean validate;
        public static Predicate<JsonElement> isValid;

        private SecuritiesRiskRatingEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SecuritiesRiskRatingEnum fromValue(String value) {
            for (SecuritiesRiskRatingEnum b : SecuritiesRiskRatingEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            if (!isValid.test(jsonElement)) {
                throw new RuntimeException();
            }
            if (!validate) {
                return;
            }
            String value = jsonElement.getAsString();
            SecuritiesRiskRatingEnum.fromValue(value);
        }

        static {
            validate = false;
            isValid = jsonElement -> true;
        }

        public static class Adapter
        extends TypeAdapter<SecuritiesRiskRatingEnum> {
            public void write(JsonWriter jsonWriter, SecuritiesRiskRatingEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SecuritiesRiskRatingEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SecuritiesRiskRatingEnum.fromValue(value);
            }
        }
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CountryInfo.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CountryInfo.class));
            return new TypeAdapter<CountryInfo>(){

                public void write(JsonWriter out, CountryInfo value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CountryInfo read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    CountryInfo.validateJsonElement(jsonElement);
                    return (CountryInfo)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

