/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.broker.JSON;

public class CreateBankRequest {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_BANK_CODE = "bank_code";
    @SerializedName(value="bank_code")
    private String bankCode;
    public static final String SERIALIZED_NAME_BANK_CODE_TYPE = "bank_code_type";
    @SerializedName(value="bank_code_type")
    private BankCodeTypeEnum bankCodeType;
    public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "account_number";
    @SerializedName(value="account_number")
    private String accountNumber;
    public static final String SERIALIZED_NAME_COUNTRY = "country";
    @SerializedName(value="country")
    private String country;
    public static final String SERIALIZED_NAME_STATE_PROVINCE = "state_province";
    @SerializedName(value="state_province")
    private String stateProvince;
    public static final String SERIALIZED_NAME_POSTAL_CODE = "postal_code";
    @SerializedName(value="postal_code")
    private String postalCode;
    public static final String SERIALIZED_NAME_CITY = "city";
    @SerializedName(value="city")
    private String city;
    public static final String SERIALIZED_NAME_STREET_ADDRESS = "street_address";
    @SerializedName(value="street_address")
    private String streetAddress;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public CreateBankRequest name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateBankRequest bankCode(String bankCode) {
        this.bankCode = bankCode;
        return this;
    }

    @Nonnull
    public String getBankCode() {
        return this.bankCode;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public CreateBankRequest bankCodeType(BankCodeTypeEnum bankCodeType) {
        this.bankCodeType = bankCodeType;
        return this;
    }

    @Nonnull
    public BankCodeTypeEnum getBankCodeType() {
        return this.bankCodeType;
    }

    public void setBankCodeType(BankCodeTypeEnum bankCodeType) {
        this.bankCodeType = bankCodeType;
    }

    public CreateBankRequest accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @Nonnull
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public CreateBankRequest country(String country) {
        this.country = country;
        return this;
    }

    @Nullable
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public CreateBankRequest stateProvince(String stateProvince) {
        this.stateProvince = stateProvince;
        return this;
    }

    @Nullable
    public String getStateProvince() {
        return this.stateProvince;
    }

    public void setStateProvince(String stateProvince) {
        this.stateProvince = stateProvince;
    }

    public CreateBankRequest postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @Nullable
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public CreateBankRequest city(String city) {
        this.city = city;
        return this;
    }

    @Nullable
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public CreateBankRequest streetAddress(String streetAddress) {
        this.streetAddress = streetAddress;
        return this;
    }

    @Nullable
    public String getStreetAddress() {
        return this.streetAddress;
    }

    public void setStreetAddress(String streetAddress) {
        this.streetAddress = streetAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateBankRequest createBankRequest = (CreateBankRequest)o;
        return Objects.equals(this.name, createBankRequest.name) && Objects.equals(this.bankCode, createBankRequest.bankCode) && Objects.equals((Object)this.bankCodeType, (Object)createBankRequest.bankCodeType) && Objects.equals(this.accountNumber, createBankRequest.accountNumber) && Objects.equals(this.country, createBankRequest.country) && Objects.equals(this.stateProvince, createBankRequest.stateProvince) && Objects.equals(this.postalCode, createBankRequest.postalCode) && Objects.equals(this.city, createBankRequest.city) && Objects.equals(this.streetAddress, createBankRequest.streetAddress);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.bankCode, this.bankCodeType, this.accountNumber, this.country, this.stateProvince, this.postalCode, this.city, this.streetAddress});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateBankRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    bankCode: ").append(this.toIndentedString(this.bankCode)).append("\n");
        sb.append("    bankCodeType: ").append(this.toIndentedString((Object)this.bankCodeType)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    stateProvince: ").append(this.toIndentedString(this.stateProvince)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    streetAddress: ").append(this.toIndentedString(this.streetAddress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in CreateBankRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CreateBankRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_BANK_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `bank_code` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BANK_CODE).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_BANK_CODE_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `bank_code_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BANK_CODE_TYPE).toString()));
        }
        BankCodeTypeEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_BANK_CODE_TYPE));
        if (!jsonObj.get(SERIALIZED_NAME_ACCOUNT_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `account_number` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COUNTRY) != null && !jsonObj.get(SERIALIZED_NAME_COUNTRY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_COUNTRY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `country` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COUNTRY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATE_PROVINCE) != null && !jsonObj.get(SERIALIZED_NAME_STATE_PROVINCE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_STATE_PROVINCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `state_province` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATE_PROVINCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_POSTAL_CODE) != null && !jsonObj.get(SERIALIZED_NAME_POSTAL_CODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_POSTAL_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `postal_code` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_POSTAL_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CITY) != null && !jsonObj.get(SERIALIZED_NAME_CITY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CITY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `city` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CITY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STREET_ADDRESS) != null && !jsonObj.get(SERIALIZED_NAME_STREET_ADDRESS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_STREET_ADDRESS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `street_address` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STREET_ADDRESS).toString()));
        }
    }

    public static CreateBankRequest fromJson(String jsonString) throws IOException {
        return (CreateBankRequest)JSON.getGson().fromJson(jsonString, CreateBankRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_BANK_CODE);
        openapiFields.add(SERIALIZED_NAME_BANK_CODE_TYPE);
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_NUMBER);
        openapiFields.add(SERIALIZED_NAME_COUNTRY);
        openapiFields.add(SERIALIZED_NAME_STATE_PROVINCE);
        openapiFields.add(SERIALIZED_NAME_POSTAL_CODE);
        openapiFields.add(SERIALIZED_NAME_CITY);
        openapiFields.add(SERIALIZED_NAME_STREET_ADDRESS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_BANK_CODE);
        openapiRequiredFields.add(SERIALIZED_NAME_BANK_CODE_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_ACCOUNT_NUMBER);
        validate = false;
        isValid = jsonElement -> true;
    }

    @JsonAdapter(value=Adapter.class)
    public static enum BankCodeTypeEnum {
        ABA("ABA"),
        BIC("BIC");

        private String value;
        public static boolean validate;
        public static Predicate<JsonElement> isValid;

        private BankCodeTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static BankCodeTypeEnum fromValue(String value) {
            for (BankCodeTypeEnum b : BankCodeTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            if (!isValid.test(jsonElement)) {
                throw new RuntimeException();
            }
            if (!validate) {
                return;
            }
            String value = jsonElement.getAsString();
            BankCodeTypeEnum.fromValue(value);
        }

        static {
            validate = false;
            isValid = jsonElement -> true;
        }

        public static class Adapter
        extends TypeAdapter<BankCodeTypeEnum> {
            public void write(JsonWriter jsonWriter, BankCodeTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public BankCodeTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return BankCodeTypeEnum.fromValue(value);
            }
        }
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CreateBankRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CreateBankRequest.class));
            return new TypeAdapter<CreateBankRequest>(){

                public void write(JsonWriter out, CreateBankRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CreateBankRequest read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    CreateBankRequest.validateJsonElement(jsonElement);
                    return (CreateBankRequest)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

