/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.broker.JSON;
import net.jacobpeterson.alpaca.openapi.broker.model.TransferDirection;
import net.jacobpeterson.alpaca.openapi.broker.model.TransferTiming;
import net.jacobpeterson.alpaca.openapi.broker.model.TransferType;
import org.openapitools.jackson.nullable.JsonNullable;

public class CreateTransferRequest {
    public static final String SERIALIZED_NAME_TRANSFER_TYPE = "transfer_type";
    @SerializedName(value="transfer_type")
    private TransferType transferType;
    public static final String SERIALIZED_NAME_RELATIONSHIP_ID = "relationship_id";
    @SerializedName(value="relationship_id")
    private UUID relationshipId;
    public static final String SERIALIZED_NAME_BANK_ID = "bank_id";
    @SerializedName(value="bank_id")
    private UUID bankId;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private BigDecimal amount;
    public static final String SERIALIZED_NAME_DIRECTION = "direction";
    @SerializedName(value="direction")
    private TransferDirection direction;
    public static final String SERIALIZED_NAME_TIMING = "timing";
    @SerializedName(value="timing")
    private TransferTiming timing;
    public static final String SERIALIZED_NAME_ADDITIONAL_INFORMATION = "additional_information";
    @SerializedName(value="additional_information")
    private String additionalInformation;
    public static final String SERIALIZED_NAME_FEE_PAYMENT_METHOD = "fee_payment_method";
    @SerializedName(value="fee_payment_method")
    private String feePaymentMethod;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public CreateTransferRequest transferType(TransferType transferType) {
        this.transferType = transferType;
        return this;
    }

    @Nonnull
    public TransferType getTransferType() {
        return this.transferType;
    }

    public void setTransferType(TransferType transferType) {
        this.transferType = transferType;
    }

    public CreateTransferRequest relationshipId(UUID relationshipId) {
        this.relationshipId = relationshipId;
        return this;
    }

    @Nullable
    public UUID getRelationshipId() {
        return this.relationshipId;
    }

    public void setRelationshipId(UUID relationshipId) {
        this.relationshipId = relationshipId;
    }

    public CreateTransferRequest bankId(UUID bankId) {
        this.bankId = bankId;
        return this;
    }

    @Nullable
    public UUID getBankId() {
        return this.bankId;
    }

    public void setBankId(UUID bankId) {
        this.bankId = bankId;
    }

    public CreateTransferRequest amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Nonnull
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public CreateTransferRequest direction(TransferDirection direction) {
        this.direction = direction;
        return this;
    }

    @Nonnull
    public TransferDirection getDirection() {
        return this.direction;
    }

    public void setDirection(TransferDirection direction) {
        this.direction = direction;
    }

    public CreateTransferRequest timing(TransferTiming timing) {
        this.timing = timing;
        return this;
    }

    @Nonnull
    public TransferTiming getTiming() {
        return this.timing;
    }

    public void setTiming(TransferTiming timing) {
        this.timing = timing;
    }

    public CreateTransferRequest additionalInformation(String additionalInformation) {
        this.additionalInformation = additionalInformation;
        return this;
    }

    @Nullable
    public String getAdditionalInformation() {
        return this.additionalInformation;
    }

    public void setAdditionalInformation(String additionalInformation) {
        this.additionalInformation = additionalInformation;
    }

    public CreateTransferRequest feePaymentMethod(String feePaymentMethod) {
        this.feePaymentMethod = feePaymentMethod;
        return this;
    }

    @Nullable
    public String getFeePaymentMethod() {
        return this.feePaymentMethod;
    }

    public void setFeePaymentMethod(String feePaymentMethod) {
        this.feePaymentMethod = feePaymentMethod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateTransferRequest createTransferRequest = (CreateTransferRequest)o;
        return Objects.equals((Object)this.transferType, (Object)createTransferRequest.transferType) && Objects.equals(this.relationshipId, createTransferRequest.relationshipId) && Objects.equals(this.bankId, createTransferRequest.bankId) && Objects.equals(this.amount, createTransferRequest.amount) && Objects.equals((Object)this.direction, (Object)createTransferRequest.direction) && Objects.equals((Object)this.timing, (Object)createTransferRequest.timing) && Objects.equals(this.additionalInformation, createTransferRequest.additionalInformation) && Objects.equals(this.feePaymentMethod, createTransferRequest.feePaymentMethod);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.transferType, this.relationshipId, this.bankId, this.amount, this.direction, this.timing, this.additionalInformation, this.feePaymentMethod});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateTransferRequest {\n");
        sb.append("    transferType: ").append(this.toIndentedString((Object)this.transferType)).append("\n");
        sb.append("    relationshipId: ").append(this.toIndentedString(this.relationshipId)).append("\n");
        sb.append("    bankId: ").append(this.toIndentedString(this.bankId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    timing: ").append(this.toIndentedString((Object)this.timing)).append("\n");
        sb.append("    additionalInformation: ").append(this.toIndentedString(this.additionalInformation)).append("\n");
        sb.append("    feePaymentMethod: ").append(this.toIndentedString(this.feePaymentMethod)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in CreateTransferRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CreateTransferRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        TransferType.validateJsonElement(jsonObj.get(SERIALIZED_NAME_TRANSFER_TYPE));
        if (jsonObj.get(SERIALIZED_NAME_RELATIONSHIP_ID) != null && !jsonObj.get(SERIALIZED_NAME_RELATIONSHIP_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RELATIONSHIP_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `relationship_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RELATIONSHIP_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BANK_ID) != null && !jsonObj.get(SERIALIZED_NAME_BANK_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_BANK_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `bank_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BANK_ID).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_AMOUNT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `amount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AMOUNT).toString()));
        }
        TransferDirection.validateJsonElement(jsonObj.get(SERIALIZED_NAME_DIRECTION));
        TransferTiming.validateJsonElement(jsonObj.get(SERIALIZED_NAME_TIMING));
        if (jsonObj.get(SERIALIZED_NAME_ADDITIONAL_INFORMATION) != null && !jsonObj.get(SERIALIZED_NAME_ADDITIONAL_INFORMATION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ADDITIONAL_INFORMATION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `additional_information` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ADDITIONAL_INFORMATION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FEE_PAYMENT_METHOD) != null && !jsonObj.get(SERIALIZED_NAME_FEE_PAYMENT_METHOD).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_FEE_PAYMENT_METHOD).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `fee_payment_method` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FEE_PAYMENT_METHOD).toString()));
        }
    }

    public static CreateTransferRequest fromJson(String jsonString) throws IOException {
        return (CreateTransferRequest)JSON.getGson().fromJson(jsonString, CreateTransferRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_TRANSFER_TYPE);
        openapiFields.add(SERIALIZED_NAME_RELATIONSHIP_ID);
        openapiFields.add(SERIALIZED_NAME_BANK_ID);
        openapiFields.add(SERIALIZED_NAME_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_DIRECTION);
        openapiFields.add(SERIALIZED_NAME_TIMING);
        openapiFields.add(SERIALIZED_NAME_ADDITIONAL_INFORMATION);
        openapiFields.add(SERIALIZED_NAME_FEE_PAYMENT_METHOD);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_TRANSFER_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_AMOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_DIRECTION);
        openapiRequiredFields.add(SERIALIZED_NAME_TIMING);
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CreateTransferRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CreateTransferRequest.class));
            return new TypeAdapter<CreateTransferRequest>(){

                public void write(JsonWriter out, CreateTransferRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CreateTransferRequest read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    CreateTransferRequest.validateJsonElement(jsonElement);
                    return (CreateTransferRequest)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

