/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.broker.JSON;
import net.jacobpeterson.alpaca.openapi.broker.model.DocumentType;

public class DocumentInner {
    public static final String SERIALIZED_NAME_DOCUMENT_ID = "document_id";
    @SerializedName(value="document_id")
    private UUID documentId;
    public static final String SERIALIZED_NAME_DOCUMENT_TYPE = "document_type";
    @SerializedName(value="document_type")
    private DocumentType documentType;
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_MIME_TYPE = "mime_type";
    @SerializedName(value="mime_type")
    private String mimeType;
    public static final String SERIALIZED_NAME_CONTENT = "content";
    @SerializedName(value="content")
    private String content;
    public static final String SERIALIZED_NAME_DOCUMENT_SUB_TYPE = "document_sub_type";
    @SerializedName(value="document_sub_type")
    private String documentSubType;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public DocumentInner documentId(UUID documentId) {
        this.documentId = documentId;
        return this;
    }

    @Nonnull
    public UUID getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(UUID documentId) {
        this.documentId = documentId;
    }

    public DocumentInner documentType(DocumentType documentType) {
        this.documentType = documentType;
        return this;
    }

    @Nonnull
    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(DocumentType documentType) {
        this.documentType = documentType;
    }

    public DocumentInner createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public DocumentInner mimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    @Nullable
    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public DocumentInner content(String content) {
        this.content = content;
        return this;
    }

    @Nullable
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public DocumentInner documentSubType(String documentSubType) {
        this.documentSubType = documentSubType;
        return this;
    }

    @Nullable
    public String getDocumentSubType() {
        return this.documentSubType;
    }

    public void setDocumentSubType(String documentSubType) {
        this.documentSubType = documentSubType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentInner documentInner = (DocumentInner)o;
        return Objects.equals(this.documentId, documentInner.documentId) && Objects.equals((Object)this.documentType, (Object)documentInner.documentType) && Objects.equals(this.createdAt, documentInner.createdAt) && Objects.equals(this.mimeType, documentInner.mimeType) && Objects.equals(this.content, documentInner.content) && Objects.equals(this.documentSubType, documentInner.documentSubType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.documentId, this.documentType, this.createdAt, this.mimeType, this.content, this.documentSubType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentInner {\n");
        sb.append("    documentId: ").append(this.toIndentedString(this.documentId)).append("\n");
        sb.append("    documentType: ").append(this.toIndentedString((Object)this.documentType)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    mimeType: ").append(this.toIndentedString(this.mimeType)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    documentSubType: ").append(this.toIndentedString(this.documentSubType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in DocumentInner is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `DocumentInner` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_DOCUMENT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `document_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DOCUMENT_ID).toString()));
        }
        DocumentType.validateJsonElement(jsonObj.get(SERIALIZED_NAME_DOCUMENT_TYPE));
        if (jsonObj.get(SERIALIZED_NAME_MIME_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_MIME_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MIME_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `mime_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MIME_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONTENT) != null && !jsonObj.get(SERIALIZED_NAME_CONTENT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CONTENT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `content` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTENT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DOCUMENT_SUB_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_DOCUMENT_SUB_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DOCUMENT_SUB_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `document_sub_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DOCUMENT_SUB_TYPE).toString()));
        }
    }

    public static DocumentInner fromJson(String jsonString) throws IOException {
        return (DocumentInner)JSON.getGson().fromJson(jsonString, DocumentInner.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DOCUMENT_ID);
        openapiFields.add(SERIALIZED_NAME_DOCUMENT_TYPE);
        openapiFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiFields.add(SERIALIZED_NAME_MIME_TYPE);
        openapiFields.add(SERIALIZED_NAME_CONTENT);
        openapiFields.add(SERIALIZED_NAME_DOCUMENT_SUB_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_DOCUMENT_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_DOCUMENT_TYPE);
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!DocumentInner.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(DocumentInner.class));
            return new TypeAdapter<DocumentInner>(){

                public void write(JsonWriter out, DocumentInner value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public DocumentInner read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    DocumentInner.validateJsonElement(jsonElement);
                    return (DocumentInner)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

