/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.function.Predicate;

@JsonAdapter(value=Adapter.class)
public enum DocumentType {
    IDENTITY_VERIFICATION("identity_verification"),
    ADDRESS_VERIFICATION("address_verification"),
    DATE_OF_BIRTH_VERIFICATION("date_of_birth_verification"),
    TAX_ID_VERIFICATION("tax_id_verification"),
    ACCOUNT_APPROVAL_LETTER("account_approval_letter"),
    CIP_RESULT("cip_result"),
    W8BEN("w8ben"),
    W9("w9"),
    LIMITED_TRADING_AUTHORIZATION("limited_trading_authorization");

    private String value;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    private DocumentType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DocumentType fromValue(String value) {
        for (DocumentType b : DocumentType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        return null;
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        String value = jsonElement.getAsString();
        DocumentType.fromValue(value);
    }

    static {
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class Adapter
    extends TypeAdapter<DocumentType> {
        public void write(JsonWriter jsonWriter, DocumentType enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public DocumentType read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return DocumentType.fromValue(value);
        }
    }
}

