/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.broker.JSON;
import net.jacobpeterson.alpaca.openapi.broker.model.DocumentType;

public class DocumentUpload {
    public static final String SERIALIZED_NAME_DOCUMENT_TYPE = "document_type";
    @SerializedName(value="document_type")
    private DocumentType documentType;
    public static final String SERIALIZED_NAME_DOCUMENT_SUB_TYPE = "document_sub_type";
    @SerializedName(value="document_sub_type")
    private String documentSubType;
    public static final String SERIALIZED_NAME_CONTENT = "content";
    @SerializedName(value="content")
    private String content;
    public static final String SERIALIZED_NAME_MIME_TYPE = "mime_type";
    @SerializedName(value="mime_type")
    private String mimeType;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public DocumentUpload documentType(DocumentType documentType) {
        this.documentType = documentType;
        return this;
    }

    @Nonnull
    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(DocumentType documentType) {
        this.documentType = documentType;
    }

    public DocumentUpload documentSubType(String documentSubType) {
        this.documentSubType = documentSubType;
        return this;
    }

    @Nullable
    public String getDocumentSubType() {
        return this.documentSubType;
    }

    public void setDocumentSubType(String documentSubType) {
        this.documentSubType = documentSubType;
    }

    public DocumentUpload content(String content) {
        this.content = content;
        return this;
    }

    @Nonnull
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public DocumentUpload mimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    @Nonnull
    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentUpload documentUpload = (DocumentUpload)o;
        return Objects.equals((Object)this.documentType, (Object)documentUpload.documentType) && Objects.equals(this.documentSubType, documentUpload.documentSubType) && Objects.equals(this.content, documentUpload.content) && Objects.equals(this.mimeType, documentUpload.mimeType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.documentType, this.documentSubType, this.content, this.mimeType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentUpload {\n");
        sb.append("    documentType: ").append(this.toIndentedString((Object)this.documentType)).append("\n");
        sb.append("    documentSubType: ").append(this.toIndentedString(this.documentSubType)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    mimeType: ").append(this.toIndentedString(this.mimeType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in DocumentUpload is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `DocumentUpload` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        DocumentType.validateJsonElement(jsonObj.get(SERIALIZED_NAME_DOCUMENT_TYPE));
        if (jsonObj.get(SERIALIZED_NAME_DOCUMENT_SUB_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_DOCUMENT_SUB_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DOCUMENT_SUB_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `document_sub_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DOCUMENT_SUB_TYPE).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_CONTENT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `content` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTENT).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_MIME_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `mime_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MIME_TYPE).toString()));
        }
    }

    public static DocumentUpload fromJson(String jsonString) throws IOException {
        return (DocumentUpload)JSON.getGson().fromJson(jsonString, DocumentUpload.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DOCUMENT_TYPE);
        openapiFields.add(SERIALIZED_NAME_DOCUMENT_SUB_TYPE);
        openapiFields.add(SERIALIZED_NAME_CONTENT);
        openapiFields.add(SERIALIZED_NAME_MIME_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_DOCUMENT_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_CONTENT);
        openapiRequiredFields.add(SERIALIZED_NAME_MIME_TYPE);
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!DocumentUpload.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(DocumentUpload.class));
            return new TypeAdapter<DocumentUpload>(){

                public void write(JsonWriter out, DocumentUpload value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public DocumentUpload read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    DocumentUpload.validateJsonElement(jsonElement);
                    return (DocumentUpload)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

