/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.broker.JSON;
import net.jacobpeterson.alpaca.openapi.broker.model.DocumentType;
import net.jacobpeterson.alpaca.openapi.broker.model.W8benDocument;

public class DocumentUploadRequest {
    public static final String SERIALIZED_NAME_DOCUMENT_TYPE = "document_type";
    @SerializedName(value="document_type")
    private DocumentType documentType;
    public static final String SERIALIZED_NAME_DOCUMENT_SUB_TYPE = "document_sub_type";
    @SerializedName(value="document_sub_type")
    private String documentSubType;
    public static final String SERIALIZED_NAME_CONTENT = "content";
    @SerializedName(value="content")
    private String content;
    public static final String SERIALIZED_NAME_CONTENT_DATA = "content_data";
    @SerializedName(value="content_data")
    private W8benDocument contentData;
    public static final String SERIALIZED_NAME_MIME_TYPE = "mime_type";
    @SerializedName(value="mime_type")
    private String mimeType;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public DocumentUploadRequest documentType(DocumentType documentType) {
        this.documentType = documentType;
        return this;
    }

    @Nonnull
    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(DocumentType documentType) {
        this.documentType = documentType;
    }

    public DocumentUploadRequest documentSubType(String documentSubType) {
        this.documentSubType = documentSubType;
        return this;
    }

    @Nullable
    public String getDocumentSubType() {
        return this.documentSubType;
    }

    public void setDocumentSubType(String documentSubType) {
        this.documentSubType = documentSubType;
    }

    public DocumentUploadRequest content(String content) {
        this.content = content;
        return this;
    }

    @Nonnull
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public DocumentUploadRequest contentData(W8benDocument contentData) {
        this.contentData = contentData;
        return this;
    }

    @Nullable
    public W8benDocument getContentData() {
        return this.contentData;
    }

    public void setContentData(W8benDocument contentData) {
        this.contentData = contentData;
    }

    public DocumentUploadRequest mimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    @Nullable
    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentUploadRequest documentUploadRequest = (DocumentUploadRequest)o;
        return Objects.equals((Object)this.documentType, (Object)documentUploadRequest.documentType) && Objects.equals(this.documentSubType, documentUploadRequest.documentSubType) && Objects.equals(this.content, documentUploadRequest.content) && Objects.equals(this.contentData, documentUploadRequest.contentData) && Objects.equals(this.mimeType, documentUploadRequest.mimeType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.documentType, this.documentSubType, this.content, this.contentData, this.mimeType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentUploadRequest {\n");
        sb.append("    documentType: ").append(this.toIndentedString((Object)this.documentType)).append("\n");
        sb.append("    documentSubType: ").append(this.toIndentedString(this.documentSubType)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    contentData: ").append(this.toIndentedString(this.contentData)).append("\n");
        sb.append("    mimeType: ").append(this.toIndentedString(this.mimeType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in DocumentUploadRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `DocumentUploadRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        DocumentType.validateJsonElement(jsonObj.get(SERIALIZED_NAME_DOCUMENT_TYPE));
        if (jsonObj.get(SERIALIZED_NAME_DOCUMENT_SUB_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_DOCUMENT_SUB_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DOCUMENT_SUB_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `document_sub_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DOCUMENT_SUB_TYPE).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_CONTENT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `content` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTENT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONTENT_DATA) != null && !jsonObj.get(SERIALIZED_NAME_CONTENT_DATA).isJsonNull()) {
            W8benDocument.validateJsonElement(jsonObj.get(SERIALIZED_NAME_CONTENT_DATA));
        }
        if (jsonObj.get(SERIALIZED_NAME_MIME_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_MIME_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MIME_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `mime_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MIME_TYPE).toString()));
        }
    }

    public static DocumentUploadRequest fromJson(String jsonString) throws IOException {
        return (DocumentUploadRequest)JSON.getGson().fromJson(jsonString, DocumentUploadRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DOCUMENT_TYPE);
        openapiFields.add(SERIALIZED_NAME_DOCUMENT_SUB_TYPE);
        openapiFields.add(SERIALIZED_NAME_CONTENT);
        openapiFields.add(SERIALIZED_NAME_CONTENT_DATA);
        openapiFields.add(SERIALIZED_NAME_MIME_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_DOCUMENT_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_CONTENT);
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!DocumentUploadRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(DocumentUploadRequest.class));
            return new TypeAdapter<DocumentUploadRequest>(){

                public void write(JsonWriter out, DocumentUploadRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public DocumentUploadRequest read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    DocumentUploadRequest.validateJsonElement(jsonElement);
                    return (DocumentUploadRequest)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

