/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.broker.JSON;
import net.jacobpeterson.alpaca.openapi.broker.model.FundingWalletTransferDirection;
import net.jacobpeterson.alpaca.openapi.broker.model.FundingWalletTransferStatus;
import net.jacobpeterson.alpaca.openapi.broker.model.TransferFee;
import net.jacobpeterson.alpaca.openapi.broker.model.Usd;

public class FundingWalletTransfer {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private UUID id;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private UUID accountId;
    public static final String SERIALIZED_NAME_FEES = "fees";
    @SerializedName(value="fees")
    private List<TransferFee> fees;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private BigDecimal amount;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_DIRECTION = "direction";
    @SerializedName(value="direction")
    private FundingWalletTransferDirection direction;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private FundingWalletTransferStatus status;
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_UPDATED_AT = "updated_at";
    @SerializedName(value="updated_at")
    private OffsetDateTime updatedAt;
    public static final String SERIALIZED_NAME_USD = "usd";
    @SerializedName(value="usd")
    private Usd usd;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public FundingWalletTransfer id(UUID id) {
        this.id = id;
        return this;
    }

    @Nullable
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public FundingWalletTransfer accountId(UUID accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    public UUID getAccountId() {
        return this.accountId;
    }

    public void setAccountId(UUID accountId) {
        this.accountId = accountId;
    }

    public FundingWalletTransfer fees(List<TransferFee> fees) {
        this.fees = fees;
        return this;
    }

    public FundingWalletTransfer addFeesItem(TransferFee feesItem) {
        if (this.fees == null) {
            this.fees = new ArrayList<TransferFee>();
        }
        this.fees.add(feesItem);
        return this;
    }

    @Nullable
    public List<TransferFee> getFees() {
        return this.fees;
    }

    public void setFees(List<TransferFee> fees) {
        this.fees = fees;
    }

    public FundingWalletTransfer amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public FundingWalletTransfer currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public FundingWalletTransfer direction(FundingWalletTransferDirection direction) {
        this.direction = direction;
        return this;
    }

    @Nullable
    public FundingWalletTransferDirection getDirection() {
        return this.direction;
    }

    public void setDirection(FundingWalletTransferDirection direction) {
        this.direction = direction;
    }

    public FundingWalletTransfer status(FundingWalletTransferStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    public FundingWalletTransferStatus getStatus() {
        return this.status;
    }

    public void setStatus(FundingWalletTransferStatus status) {
        this.status = status;
    }

    public FundingWalletTransfer createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public FundingWalletTransfer updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public FundingWalletTransfer usd(Usd usd) {
        this.usd = usd;
        return this;
    }

    @Nullable
    public Usd getUsd() {
        return this.usd;
    }

    public void setUsd(Usd usd) {
        this.usd = usd;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FundingWalletTransfer fundingWalletTransfer = (FundingWalletTransfer)o;
        return Objects.equals(this.id, fundingWalletTransfer.id) && Objects.equals(this.accountId, fundingWalletTransfer.accountId) && Objects.equals(this.fees, fundingWalletTransfer.fees) && Objects.equals(this.amount, fundingWalletTransfer.amount) && Objects.equals(this.currency, fundingWalletTransfer.currency) && Objects.equals((Object)this.direction, (Object)fundingWalletTransfer.direction) && Objects.equals((Object)this.status, (Object)fundingWalletTransfer.status) && Objects.equals(this.createdAt, fundingWalletTransfer.createdAt) && Objects.equals(this.updatedAt, fundingWalletTransfer.updatedAt) && Objects.equals(this.usd, fundingWalletTransfer.usd);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.accountId, this.fees, this.amount, this.currency, this.direction, this.status, this.createdAt, this.updatedAt, this.usd});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FundingWalletTransfer {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    fees: ").append(this.toIndentedString(this.fees)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    usd: ").append(this.toIndentedString(this.usd)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayfees;
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in FundingWalletTransfer is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `FundingWalletTransfer` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID) != null && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `account_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FEES) != null && !jsonObj.get(SERIALIZED_NAME_FEES).isJsonNull() && (jsonArrayfees = jsonObj.getAsJsonArray(SERIALIZED_NAME_FEES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_FEES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `fees` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FEES).toString()));
            }
            for (int i = 0; i < jsonArrayfees.size(); ++i) {
                TransferFee.validateJsonElement(jsonArrayfees.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_AMOUNT) != null && !jsonObj.get(SERIALIZED_NAME_AMOUNT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_AMOUNT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `amount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AMOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CURRENCY) != null && !jsonObj.get(SERIALIZED_NAME_CURRENCY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CURRENCY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CURRENCY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DIRECTION) != null && !jsonObj.get(SERIALIZED_NAME_DIRECTION).isJsonNull()) {
            FundingWalletTransferDirection.validateJsonElement(jsonObj.get(SERIALIZED_NAME_DIRECTION));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonNull()) {
            FundingWalletTransferStatus.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STATUS));
        }
        if (jsonObj.get(SERIALIZED_NAME_USD) != null && !jsonObj.get(SERIALIZED_NAME_USD).isJsonNull()) {
            Usd.validateJsonElement(jsonObj.get(SERIALIZED_NAME_USD));
        }
    }

    public static FundingWalletTransfer fromJson(String jsonString) throws IOException {
        return (FundingWalletTransfer)JSON.getGson().fromJson(jsonString, FundingWalletTransfer.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_ID);
        openapiFields.add(SERIALIZED_NAME_FEES);
        openapiFields.add(SERIALIZED_NAME_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_CURRENCY);
        openapiFields.add(SERIALIZED_NAME_DIRECTION);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiFields.add(SERIALIZED_NAME_UPDATED_AT);
        openapiFields.add(SERIALIZED_NAME_USD);
        openapiRequiredFields = new HashSet();
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!FundingWalletTransfer.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(FundingWalletTransfer.class));
            return new TypeAdapter<FundingWalletTransfer>(){

                public void write(JsonWriter out, FundingWalletTransfer value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public FundingWalletTransfer read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    FundingWalletTransfer.validateJsonElement(jsonElement);
                    return (FundingWalletTransfer)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

