/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.broker.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.broker.JSON;
import net.jacobpeterson.alpaca.openapi.broker.model.TaxIdType;

public class Identity {
    public static final String SERIALIZED_NAME_GIVEN_NAME = "given_name";
    @SerializedName(value="given_name")
    private String givenName;
    public static final String SERIALIZED_NAME_FAMILY_NAME = "family_name";
    @SerializedName(value="family_name")
    private String familyName;
    public static final String SERIALIZED_NAME_MIDDLE_NAME = "middle_name";
    @SerializedName(value="middle_name")
    private String middleName;
    public static final String SERIALIZED_NAME_DATE_OF_BIRTH = "date_of_birth";
    @SerializedName(value="date_of_birth")
    private LocalDate dateOfBirth;
    public static final String SERIALIZED_NAME_TAX_ID = "tax_id";
    @SerializedName(value="tax_id")
    private String taxId;
    public static final String SERIALIZED_NAME_TAX_ID_TYPE = "tax_id_type";
    @SerializedName(value="tax_id_type")
    private TaxIdType taxIdType;
    public static final String SERIALIZED_NAME_COUNTRY_OF_CITIZENSHIP = "country_of_citizenship";
    @SerializedName(value="country_of_citizenship")
    private String countryOfCitizenship;
    public static final String SERIALIZED_NAME_COUNTRY_OF_BIRTH = "country_of_birth";
    @SerializedName(value="country_of_birth")
    private String countryOfBirth;
    public static final String SERIALIZED_NAME_COUNTRY_OF_TAX_RESIDENCE = "country_of_tax_residence";
    @SerializedName(value="country_of_tax_residence")
    private String countryOfTaxResidence;
    public static final String SERIALIZED_NAME_FUNDING_SOURCE = "funding_source";
    @SerializedName(value="funding_source")
    private List<FundingSourceEnum> fundingSource = new ArrayList<FundingSourceEnum>();
    public static final String SERIALIZED_NAME_LIQUIDITY_NEEDS = "liquidity_needs";
    @SerializedName(value="liquidity_needs")
    private LiquidityNeedsEnum liquidityNeeds;
    public static final String SERIALIZED_NAME_INVESTMENT_EXPERIENCE_WITH_STOCKS = "investment_experience_with_stocks";
    @SerializedName(value="investment_experience_with_stocks")
    private InvestmentExperienceWithStocksEnum investmentExperienceWithStocks;
    public static final String SERIALIZED_NAME_INVESTMENT_EXPERIENCE_WITH_OPTIONS = "investment_experience_with_options";
    @SerializedName(value="investment_experience_with_options")
    private InvestmentExperienceWithOptionsEnum investmentExperienceWithOptions;
    public static final String SERIALIZED_NAME_RISK_TOLERANCE = "risk_tolerance";
    @SerializedName(value="risk_tolerance")
    private RiskToleranceEnum riskTolerance;
    public static final String SERIALIZED_NAME_INVESTMENT_OBJECTIVE = "investment_objective";
    @SerializedName(value="investment_objective")
    private InvestmentObjectiveEnum investmentObjective;
    public static final String SERIALIZED_NAME_INVESTMENT_TIME_HORIZON = "investment_time_horizon";
    @SerializedName(value="investment_time_horizon")
    private InvestmentTimeHorizonEnum investmentTimeHorizon;
    public static final String SERIALIZED_NAME_ANNUAL_INCOME_MIN = "annual_income_min";
    @SerializedName(value="annual_income_min")
    private BigDecimal annualIncomeMin;
    public static final String SERIALIZED_NAME_ANNUAL_INCOME_MAX = "annual_income_max";
    @SerializedName(value="annual_income_max")
    private BigDecimal annualIncomeMax;
    public static final String SERIALIZED_NAME_LIQUID_NET_WORTH_MIN = "liquid_net_worth_min";
    @SerializedName(value="liquid_net_worth_min")
    private BigDecimal liquidNetWorthMin;
    public static final String SERIALIZED_NAME_LIQUID_NET_WORTH_MAX = "liquid_net_worth_max";
    @SerializedName(value="liquid_net_worth_max")
    private BigDecimal liquidNetWorthMax;
    public static final String SERIALIZED_NAME_TOTAL_NET_WORTH_MIN = "total_net_worth_min";
    @SerializedName(value="total_net_worth_min")
    private BigDecimal totalNetWorthMin;
    public static final String SERIALIZED_NAME_TOTAL_NET_WORTH_MAX = "total_net_worth_max";
    @SerializedName(value="total_net_worth_max")
    private BigDecimal totalNetWorthMax;
    public static final String SERIALIZED_NAME_VISA_TYPE = "visa_type";
    @SerializedName(value="visa_type")
    private String visaType;
    public static final String SERIALIZED_NAME_VISA_EXPIRATION_DATE = "visa_expiration_date";
    @SerializedName(value="visa_expiration_date")
    private LocalDate visaExpirationDate;
    public static final String SERIALIZED_NAME_DATE_OF_DEPARTURE_FROM_USA = "date_of_departure_from_usa";
    @SerializedName(value="date_of_departure_from_usa")
    private LocalDate dateOfDepartureFromUsa;
    public static final String SERIALIZED_NAME_PERMANENT_RESIDENT = "permanent_resident";
    @SerializedName(value="permanent_resident")
    private Boolean permanentResident;
    public static final String SERIALIZED_NAME_EXTRA = "extra";
    @SerializedName(value="extra")
    private Object extra;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public Identity givenName(String givenName) {
        this.givenName = givenName;
        return this;
    }

    @Nonnull
    public String getGivenName() {
        return this.givenName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public Identity familyName(String familyName) {
        this.familyName = familyName;
        return this;
    }

    @Nonnull
    public String getFamilyName() {
        return this.familyName;
    }

    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    public Identity middleName(String middleName) {
        this.middleName = middleName;
        return this;
    }

    @Nullable
    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public Identity dateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        return this;
    }

    @Nonnull
    public LocalDate getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public Identity taxId(String taxId) {
        this.taxId = taxId;
        return this;
    }

    @Nullable
    public String getTaxId() {
        return this.taxId;
    }

    public void setTaxId(String taxId) {
        this.taxId = taxId;
    }

    public Identity taxIdType(TaxIdType taxIdType) {
        this.taxIdType = taxIdType;
        return this;
    }

    @Nonnull
    public TaxIdType getTaxIdType() {
        return this.taxIdType;
    }

    public void setTaxIdType(TaxIdType taxIdType) {
        this.taxIdType = taxIdType;
    }

    public Identity countryOfCitizenship(String countryOfCitizenship) {
        this.countryOfCitizenship = countryOfCitizenship;
        return this;
    }

    @Nullable
    public String getCountryOfCitizenship() {
        return this.countryOfCitizenship;
    }

    public void setCountryOfCitizenship(String countryOfCitizenship) {
        this.countryOfCitizenship = countryOfCitizenship;
    }

    public Identity countryOfBirth(String countryOfBirth) {
        this.countryOfBirth = countryOfBirth;
        return this;
    }

    @Nullable
    public String getCountryOfBirth() {
        return this.countryOfBirth;
    }

    public void setCountryOfBirth(String countryOfBirth) {
        this.countryOfBirth = countryOfBirth;
    }

    public Identity countryOfTaxResidence(String countryOfTaxResidence) {
        this.countryOfTaxResidence = countryOfTaxResidence;
        return this;
    }

    @Nonnull
    public String getCountryOfTaxResidence() {
        return this.countryOfTaxResidence;
    }

    public void setCountryOfTaxResidence(String countryOfTaxResidence) {
        this.countryOfTaxResidence = countryOfTaxResidence;
    }

    public Identity fundingSource(List<FundingSourceEnum> fundingSource) {
        this.fundingSource = fundingSource;
        return this;
    }

    public Identity addFundingSourceItem(FundingSourceEnum fundingSourceItem) {
        if (this.fundingSource == null) {
            this.fundingSource = new ArrayList<FundingSourceEnum>();
        }
        this.fundingSource.add(fundingSourceItem);
        return this;
    }

    @Nonnull
    public List<FundingSourceEnum> getFundingSource() {
        return this.fundingSource;
    }

    public void setFundingSource(List<FundingSourceEnum> fundingSource) {
        this.fundingSource = fundingSource;
    }

    public Identity liquidityNeeds(LiquidityNeedsEnum liquidityNeeds) {
        this.liquidityNeeds = liquidityNeeds;
        return this;
    }

    @Nullable
    public LiquidityNeedsEnum getLiquidityNeeds() {
        return this.liquidityNeeds;
    }

    public void setLiquidityNeeds(LiquidityNeedsEnum liquidityNeeds) {
        this.liquidityNeeds = liquidityNeeds;
    }

    public Identity investmentExperienceWithStocks(InvestmentExperienceWithStocksEnum investmentExperienceWithStocks) {
        this.investmentExperienceWithStocks = investmentExperienceWithStocks;
        return this;
    }

    @Nullable
    public InvestmentExperienceWithStocksEnum getInvestmentExperienceWithStocks() {
        return this.investmentExperienceWithStocks;
    }

    public void setInvestmentExperienceWithStocks(InvestmentExperienceWithStocksEnum investmentExperienceWithStocks) {
        this.investmentExperienceWithStocks = investmentExperienceWithStocks;
    }

    public Identity investmentExperienceWithOptions(InvestmentExperienceWithOptionsEnum investmentExperienceWithOptions) {
        this.investmentExperienceWithOptions = investmentExperienceWithOptions;
        return this;
    }

    @Nullable
    public InvestmentExperienceWithOptionsEnum getInvestmentExperienceWithOptions() {
        return this.investmentExperienceWithOptions;
    }

    public void setInvestmentExperienceWithOptions(InvestmentExperienceWithOptionsEnum investmentExperienceWithOptions) {
        this.investmentExperienceWithOptions = investmentExperienceWithOptions;
    }

    public Identity riskTolerance(RiskToleranceEnum riskTolerance) {
        this.riskTolerance = riskTolerance;
        return this;
    }

    @Nullable
    public RiskToleranceEnum getRiskTolerance() {
        return this.riskTolerance;
    }

    public void setRiskTolerance(RiskToleranceEnum riskTolerance) {
        this.riskTolerance = riskTolerance;
    }

    public Identity investmentObjective(InvestmentObjectiveEnum investmentObjective) {
        this.investmentObjective = investmentObjective;
        return this;
    }

    @Nullable
    public InvestmentObjectiveEnum getInvestmentObjective() {
        return this.investmentObjective;
    }

    public void setInvestmentObjective(InvestmentObjectiveEnum investmentObjective) {
        this.investmentObjective = investmentObjective;
    }

    public Identity investmentTimeHorizon(InvestmentTimeHorizonEnum investmentTimeHorizon) {
        this.investmentTimeHorizon = investmentTimeHorizon;
        return this;
    }

    @Nullable
    public InvestmentTimeHorizonEnum getInvestmentTimeHorizon() {
        return this.investmentTimeHorizon;
    }

    public void setInvestmentTimeHorizon(InvestmentTimeHorizonEnum investmentTimeHorizon) {
        this.investmentTimeHorizon = investmentTimeHorizon;
    }

    public Identity annualIncomeMin(BigDecimal annualIncomeMin) {
        this.annualIncomeMin = annualIncomeMin;
        return this;
    }

    @Nullable
    public BigDecimal getAnnualIncomeMin() {
        return this.annualIncomeMin;
    }

    public void setAnnualIncomeMin(BigDecimal annualIncomeMin) {
        this.annualIncomeMin = annualIncomeMin;
    }

    public Identity annualIncomeMax(BigDecimal annualIncomeMax) {
        this.annualIncomeMax = annualIncomeMax;
        return this;
    }

    @Nullable
    public BigDecimal getAnnualIncomeMax() {
        return this.annualIncomeMax;
    }

    public void setAnnualIncomeMax(BigDecimal annualIncomeMax) {
        this.annualIncomeMax = annualIncomeMax;
    }

    public Identity liquidNetWorthMin(BigDecimal liquidNetWorthMin) {
        this.liquidNetWorthMin = liquidNetWorthMin;
        return this;
    }

    @Nullable
    public BigDecimal getLiquidNetWorthMin() {
        return this.liquidNetWorthMin;
    }

    public void setLiquidNetWorthMin(BigDecimal liquidNetWorthMin) {
        this.liquidNetWorthMin = liquidNetWorthMin;
    }

    public Identity liquidNetWorthMax(BigDecimal liquidNetWorthMax) {
        this.liquidNetWorthMax = liquidNetWorthMax;
        return this;
    }

    @Nullable
    public BigDecimal getLiquidNetWorthMax() {
        return this.liquidNetWorthMax;
    }

    public void setLiquidNetWorthMax(BigDecimal liquidNetWorthMax) {
        this.liquidNetWorthMax = liquidNetWorthMax;
    }

    public Identity totalNetWorthMin(BigDecimal totalNetWorthMin) {
        this.totalNetWorthMin = totalNetWorthMin;
        return this;
    }

    @Nullable
    public BigDecimal getTotalNetWorthMin() {
        return this.totalNetWorthMin;
    }

    public void setTotalNetWorthMin(BigDecimal totalNetWorthMin) {
        this.totalNetWorthMin = totalNetWorthMin;
    }

    public Identity totalNetWorthMax(BigDecimal totalNetWorthMax) {
        this.totalNetWorthMax = totalNetWorthMax;
        return this;
    }

    @Nullable
    public BigDecimal getTotalNetWorthMax() {
        return this.totalNetWorthMax;
    }

    public void setTotalNetWorthMax(BigDecimal totalNetWorthMax) {
        this.totalNetWorthMax = totalNetWorthMax;
    }

    public Identity visaType(String visaType) {
        this.visaType = visaType;
        return this;
    }

    @Nullable
    public String getVisaType() {
        return this.visaType;
    }

    public void setVisaType(String visaType) {
        this.visaType = visaType;
    }

    public Identity visaExpirationDate(LocalDate visaExpirationDate) {
        this.visaExpirationDate = visaExpirationDate;
        return this;
    }

    @Nullable
    public LocalDate getVisaExpirationDate() {
        return this.visaExpirationDate;
    }

    public void setVisaExpirationDate(LocalDate visaExpirationDate) {
        this.visaExpirationDate = visaExpirationDate;
    }

    public Identity dateOfDepartureFromUsa(LocalDate dateOfDepartureFromUsa) {
        this.dateOfDepartureFromUsa = dateOfDepartureFromUsa;
        return this;
    }

    @Nullable
    public LocalDate getDateOfDepartureFromUsa() {
        return this.dateOfDepartureFromUsa;
    }

    public void setDateOfDepartureFromUsa(LocalDate dateOfDepartureFromUsa) {
        this.dateOfDepartureFromUsa = dateOfDepartureFromUsa;
    }

    public Identity permanentResident(Boolean permanentResident) {
        this.permanentResident = permanentResident;
        return this;
    }

    @Nullable
    public Boolean getPermanentResident() {
        return this.permanentResident;
    }

    public void setPermanentResident(Boolean permanentResident) {
        this.permanentResident = permanentResident;
    }

    public Identity extra(Object extra) {
        this.extra = extra;
        return this;
    }

    @Nullable
    public Object getExtra() {
        return this.extra;
    }

    public void setExtra(Object extra) {
        this.extra = extra;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Identity identity = (Identity)o;
        return Objects.equals(this.givenName, identity.givenName) && Objects.equals(this.familyName, identity.familyName) && Objects.equals(this.middleName, identity.middleName) && Objects.equals(this.dateOfBirth, identity.dateOfBirth) && Objects.equals(this.taxId, identity.taxId) && Objects.equals((Object)this.taxIdType, (Object)identity.taxIdType) && Objects.equals(this.countryOfCitizenship, identity.countryOfCitizenship) && Objects.equals(this.countryOfBirth, identity.countryOfBirth) && Objects.equals(this.countryOfTaxResidence, identity.countryOfTaxResidence) && Objects.equals(this.fundingSource, identity.fundingSource) && Objects.equals((Object)this.liquidityNeeds, (Object)identity.liquidityNeeds) && Objects.equals((Object)this.investmentExperienceWithStocks, (Object)identity.investmentExperienceWithStocks) && Objects.equals((Object)this.investmentExperienceWithOptions, (Object)identity.investmentExperienceWithOptions) && Objects.equals((Object)this.riskTolerance, (Object)identity.riskTolerance) && Objects.equals((Object)this.investmentObjective, (Object)identity.investmentObjective) && Objects.equals((Object)this.investmentTimeHorizon, (Object)identity.investmentTimeHorizon) && Objects.equals(this.annualIncomeMin, identity.annualIncomeMin) && Objects.equals(this.annualIncomeMax, identity.annualIncomeMax) && Objects.equals(this.liquidNetWorthMin, identity.liquidNetWorthMin) && Objects.equals(this.liquidNetWorthMax, identity.liquidNetWorthMax) && Objects.equals(this.totalNetWorthMin, identity.totalNetWorthMin) && Objects.equals(this.totalNetWorthMax, identity.totalNetWorthMax) && Objects.equals(this.visaType, identity.visaType) && Objects.equals(this.visaExpirationDate, identity.visaExpirationDate) && Objects.equals(this.dateOfDepartureFromUsa, identity.dateOfDepartureFromUsa) && Objects.equals(this.permanentResident, identity.permanentResident) && Objects.equals(this.extra, identity.extra);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.givenName, this.familyName, this.middleName, this.dateOfBirth, this.taxId, this.taxIdType, this.countryOfCitizenship, this.countryOfBirth, this.countryOfTaxResidence, this.fundingSource, this.liquidityNeeds, this.investmentExperienceWithStocks, this.investmentExperienceWithOptions, this.riskTolerance, this.investmentObjective, this.investmentTimeHorizon, this.annualIncomeMin, this.annualIncomeMax, this.liquidNetWorthMin, this.liquidNetWorthMax, this.totalNetWorthMin, this.totalNetWorthMax, this.visaType, this.visaExpirationDate, this.dateOfDepartureFromUsa, this.permanentResident, this.extra});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Identity {\n");
        sb.append("    givenName: ").append(this.toIndentedString(this.givenName)).append("\n");
        sb.append("    familyName: ").append(this.toIndentedString(this.familyName)).append("\n");
        sb.append("    middleName: ").append(this.toIndentedString(this.middleName)).append("\n");
        sb.append("    dateOfBirth: ").append(this.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("    taxId: ").append(this.toIndentedString(this.taxId)).append("\n");
        sb.append("    taxIdType: ").append(this.toIndentedString((Object)this.taxIdType)).append("\n");
        sb.append("    countryOfCitizenship: ").append(this.toIndentedString(this.countryOfCitizenship)).append("\n");
        sb.append("    countryOfBirth: ").append(this.toIndentedString(this.countryOfBirth)).append("\n");
        sb.append("    countryOfTaxResidence: ").append(this.toIndentedString(this.countryOfTaxResidence)).append("\n");
        sb.append("    fundingSource: ").append(this.toIndentedString(this.fundingSource)).append("\n");
        sb.append("    liquidityNeeds: ").append(this.toIndentedString((Object)this.liquidityNeeds)).append("\n");
        sb.append("    investmentExperienceWithStocks: ").append(this.toIndentedString((Object)this.investmentExperienceWithStocks)).append("\n");
        sb.append("    investmentExperienceWithOptions: ").append(this.toIndentedString((Object)this.investmentExperienceWithOptions)).append("\n");
        sb.append("    riskTolerance: ").append(this.toIndentedString((Object)this.riskTolerance)).append("\n");
        sb.append("    investmentObjective: ").append(this.toIndentedString((Object)this.investmentObjective)).append("\n");
        sb.append("    investmentTimeHorizon: ").append(this.toIndentedString((Object)this.investmentTimeHorizon)).append("\n");
        sb.append("    annualIncomeMin: ").append(this.toIndentedString(this.annualIncomeMin)).append("\n");
        sb.append("    annualIncomeMax: ").append(this.toIndentedString(this.annualIncomeMax)).append("\n");
        sb.append("    liquidNetWorthMin: ").append(this.toIndentedString(this.liquidNetWorthMin)).append("\n");
        sb.append("    liquidNetWorthMax: ").append(this.toIndentedString(this.liquidNetWorthMax)).append("\n");
        sb.append("    totalNetWorthMin: ").append(this.toIndentedString(this.totalNetWorthMin)).append("\n");
        sb.append("    totalNetWorthMax: ").append(this.toIndentedString(this.totalNetWorthMax)).append("\n");
        sb.append("    visaType: ").append(this.toIndentedString(this.visaType)).append("\n");
        sb.append("    visaExpirationDate: ").append(this.toIndentedString(this.visaExpirationDate)).append("\n");
        sb.append("    dateOfDepartureFromUsa: ").append(this.toIndentedString(this.dateOfDepartureFromUsa)).append("\n");
        sb.append("    permanentResident: ").append(this.toIndentedString(this.permanentResident)).append("\n");
        sb.append("    extra: ").append(this.toIndentedString(this.extra)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in Identity is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Identity` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_GIVEN_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `given_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GIVEN_NAME).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_FAMILY_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `family_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FAMILY_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MIDDLE_NAME) != null && !jsonObj.get(SERIALIZED_NAME_MIDDLE_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MIDDLE_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `middle_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MIDDLE_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TAX_ID) != null && !jsonObj.get(SERIALIZED_NAME_TAX_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TAX_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `tax_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAX_ID).toString()));
        }
        TaxIdType.validateJsonElement(jsonObj.get(SERIALIZED_NAME_TAX_ID_TYPE));
        if (jsonObj.get(SERIALIZED_NAME_COUNTRY_OF_CITIZENSHIP) != null && !jsonObj.get(SERIALIZED_NAME_COUNTRY_OF_CITIZENSHIP).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_COUNTRY_OF_CITIZENSHIP).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `country_of_citizenship` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COUNTRY_OF_CITIZENSHIP).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COUNTRY_OF_BIRTH) != null && !jsonObj.get(SERIALIZED_NAME_COUNTRY_OF_BIRTH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_COUNTRY_OF_BIRTH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `country_of_birth` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COUNTRY_OF_BIRTH).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_COUNTRY_OF_TAX_RESIDENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `country_of_tax_residence` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COUNTRY_OF_TAX_RESIDENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FUNDING_SOURCE) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_FUNDING_SOURCE).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `funding_source` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FUNDING_SOURCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LIQUIDITY_NEEDS) != null && !jsonObj.get(SERIALIZED_NAME_LIQUIDITY_NEEDS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LIQUIDITY_NEEDS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `liquidity_needs` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LIQUIDITY_NEEDS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LIQUIDITY_NEEDS) != null && !jsonObj.get(SERIALIZED_NAME_LIQUIDITY_NEEDS).isJsonNull()) {
            LiquidityNeedsEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_LIQUIDITY_NEEDS));
        }
        if (jsonObj.get(SERIALIZED_NAME_INVESTMENT_EXPERIENCE_WITH_STOCKS) != null && !jsonObj.get(SERIALIZED_NAME_INVESTMENT_EXPERIENCE_WITH_STOCKS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_INVESTMENT_EXPERIENCE_WITH_STOCKS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `investment_experience_with_stocks` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INVESTMENT_EXPERIENCE_WITH_STOCKS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INVESTMENT_EXPERIENCE_WITH_STOCKS) != null && !jsonObj.get(SERIALIZED_NAME_INVESTMENT_EXPERIENCE_WITH_STOCKS).isJsonNull()) {
            InvestmentExperienceWithStocksEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_INVESTMENT_EXPERIENCE_WITH_STOCKS));
        }
        if (jsonObj.get(SERIALIZED_NAME_INVESTMENT_EXPERIENCE_WITH_OPTIONS) != null && !jsonObj.get(SERIALIZED_NAME_INVESTMENT_EXPERIENCE_WITH_OPTIONS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_INVESTMENT_EXPERIENCE_WITH_OPTIONS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `investment_experience_with_options` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INVESTMENT_EXPERIENCE_WITH_OPTIONS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INVESTMENT_EXPERIENCE_WITH_OPTIONS) != null && !jsonObj.get(SERIALIZED_NAME_INVESTMENT_EXPERIENCE_WITH_OPTIONS).isJsonNull()) {
            InvestmentExperienceWithOptionsEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_INVESTMENT_EXPERIENCE_WITH_OPTIONS));
        }
        if (jsonObj.get(SERIALIZED_NAME_RISK_TOLERANCE) != null && !jsonObj.get(SERIALIZED_NAME_RISK_TOLERANCE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RISK_TOLERANCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `risk_tolerance` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RISK_TOLERANCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RISK_TOLERANCE) != null && !jsonObj.get(SERIALIZED_NAME_RISK_TOLERANCE).isJsonNull()) {
            RiskToleranceEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_RISK_TOLERANCE));
        }
        if (jsonObj.get(SERIALIZED_NAME_INVESTMENT_OBJECTIVE) != null && !jsonObj.get(SERIALIZED_NAME_INVESTMENT_OBJECTIVE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_INVESTMENT_OBJECTIVE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `investment_objective` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INVESTMENT_OBJECTIVE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INVESTMENT_OBJECTIVE) != null && !jsonObj.get(SERIALIZED_NAME_INVESTMENT_OBJECTIVE).isJsonNull()) {
            InvestmentObjectiveEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_INVESTMENT_OBJECTIVE));
        }
        if (jsonObj.get(SERIALIZED_NAME_INVESTMENT_TIME_HORIZON) != null && !jsonObj.get(SERIALIZED_NAME_INVESTMENT_TIME_HORIZON).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_INVESTMENT_TIME_HORIZON).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `investment_time_horizon` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INVESTMENT_TIME_HORIZON).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INVESTMENT_TIME_HORIZON) != null && !jsonObj.get(SERIALIZED_NAME_INVESTMENT_TIME_HORIZON).isJsonNull()) {
            InvestmentTimeHorizonEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_INVESTMENT_TIME_HORIZON));
        }
        if (jsonObj.get(SERIALIZED_NAME_VISA_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_VISA_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VISA_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `visa_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VISA_TYPE).toString()));
        }
    }

    public static Identity fromJson(String jsonString) throws IOException {
        return (Identity)JSON.getGson().fromJson(jsonString, Identity.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_GIVEN_NAME);
        openapiFields.add(SERIALIZED_NAME_FAMILY_NAME);
        openapiFields.add(SERIALIZED_NAME_MIDDLE_NAME);
        openapiFields.add(SERIALIZED_NAME_DATE_OF_BIRTH);
        openapiFields.add(SERIALIZED_NAME_TAX_ID);
        openapiFields.add(SERIALIZED_NAME_TAX_ID_TYPE);
        openapiFields.add(SERIALIZED_NAME_COUNTRY_OF_CITIZENSHIP);
        openapiFields.add(SERIALIZED_NAME_COUNTRY_OF_BIRTH);
        openapiFields.add(SERIALIZED_NAME_COUNTRY_OF_TAX_RESIDENCE);
        openapiFields.add(SERIALIZED_NAME_FUNDING_SOURCE);
        openapiFields.add(SERIALIZED_NAME_LIQUIDITY_NEEDS);
        openapiFields.add(SERIALIZED_NAME_INVESTMENT_EXPERIENCE_WITH_STOCKS);
        openapiFields.add(SERIALIZED_NAME_INVESTMENT_EXPERIENCE_WITH_OPTIONS);
        openapiFields.add(SERIALIZED_NAME_RISK_TOLERANCE);
        openapiFields.add(SERIALIZED_NAME_INVESTMENT_OBJECTIVE);
        openapiFields.add(SERIALIZED_NAME_INVESTMENT_TIME_HORIZON);
        openapiFields.add(SERIALIZED_NAME_ANNUAL_INCOME_MIN);
        openapiFields.add(SERIALIZED_NAME_ANNUAL_INCOME_MAX);
        openapiFields.add(SERIALIZED_NAME_LIQUID_NET_WORTH_MIN);
        openapiFields.add(SERIALIZED_NAME_LIQUID_NET_WORTH_MAX);
        openapiFields.add(SERIALIZED_NAME_TOTAL_NET_WORTH_MIN);
        openapiFields.add(SERIALIZED_NAME_TOTAL_NET_WORTH_MAX);
        openapiFields.add(SERIALIZED_NAME_VISA_TYPE);
        openapiFields.add(SERIALIZED_NAME_VISA_EXPIRATION_DATE);
        openapiFields.add(SERIALIZED_NAME_DATE_OF_DEPARTURE_FROM_USA);
        openapiFields.add(SERIALIZED_NAME_PERMANENT_RESIDENT);
        openapiFields.add(SERIALIZED_NAME_EXTRA);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_GIVEN_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_FAMILY_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_DATE_OF_BIRTH);
        openapiRequiredFields.add(SERIALIZED_NAME_TAX_ID_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_COUNTRY_OF_TAX_RESIDENCE);
        openapiRequiredFields.add(SERIALIZED_NAME_FUNDING_SOURCE);
        validate = false;
        isValid = jsonElement -> true;
    }

    @JsonAdapter(value=Adapter.class)
    public static enum LiquidityNeedsEnum {
        VERY_IMPORTANT("very_important"),
        IMPORTANT("important"),
        SOMEWHAT_IMPORTANT("somewhat_important"),
        DOES_NOT_MATTER("does_not_matter");

        private String value;
        public static boolean validate;
        public static Predicate<JsonElement> isValid;

        private LiquidityNeedsEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static LiquidityNeedsEnum fromValue(String value) {
            for (LiquidityNeedsEnum b : LiquidityNeedsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            if (!isValid.test(jsonElement)) {
                throw new RuntimeException();
            }
            if (!validate) {
                return;
            }
            String value = jsonElement.getAsString();
            LiquidityNeedsEnum.fromValue(value);
        }

        static {
            validate = false;
            isValid = jsonElement -> true;
        }

        public static class Adapter
        extends TypeAdapter<LiquidityNeedsEnum> {
            public void write(JsonWriter jsonWriter, LiquidityNeedsEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public LiquidityNeedsEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return LiquidityNeedsEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum InvestmentExperienceWithStocksEnum {
        NONE("none"),
        _1_TO_5_YEARS("1_to_5_years"),
        OVER_5_YEARS("over_5_years");

        private String value;
        public static boolean validate;
        public static Predicate<JsonElement> isValid;

        private InvestmentExperienceWithStocksEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static InvestmentExperienceWithStocksEnum fromValue(String value) {
            for (InvestmentExperienceWithStocksEnum b : InvestmentExperienceWithStocksEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            if (!isValid.test(jsonElement)) {
                throw new RuntimeException();
            }
            if (!validate) {
                return;
            }
            String value = jsonElement.getAsString();
            InvestmentExperienceWithStocksEnum.fromValue(value);
        }

        static {
            validate = false;
            isValid = jsonElement -> true;
        }

        public static class Adapter
        extends TypeAdapter<InvestmentExperienceWithStocksEnum> {
            public void write(JsonWriter jsonWriter, InvestmentExperienceWithStocksEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public InvestmentExperienceWithStocksEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return InvestmentExperienceWithStocksEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum InvestmentExperienceWithOptionsEnum {
        NONE("none"),
        _1_TO_5_YEARS("1_to_5_years"),
        OVER_5_YEARS("over_5_years");

        private String value;
        public static boolean validate;
        public static Predicate<JsonElement> isValid;

        private InvestmentExperienceWithOptionsEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static InvestmentExperienceWithOptionsEnum fromValue(String value) {
            for (InvestmentExperienceWithOptionsEnum b : InvestmentExperienceWithOptionsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            if (!isValid.test(jsonElement)) {
                throw new RuntimeException();
            }
            if (!validate) {
                return;
            }
            String value = jsonElement.getAsString();
            InvestmentExperienceWithOptionsEnum.fromValue(value);
        }

        static {
            validate = false;
            isValid = jsonElement -> true;
        }

        public static class Adapter
        extends TypeAdapter<InvestmentExperienceWithOptionsEnum> {
            public void write(JsonWriter jsonWriter, InvestmentExperienceWithOptionsEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public InvestmentExperienceWithOptionsEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return InvestmentExperienceWithOptionsEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RiskToleranceEnum {
        CONSERVATIVE("conservative"),
        MODERATE("moderate"),
        SIGNIFICANT_RISK("significant_risk");

        private String value;
        public static boolean validate;
        public static Predicate<JsonElement> isValid;

        private RiskToleranceEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RiskToleranceEnum fromValue(String value) {
            for (RiskToleranceEnum b : RiskToleranceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            if (!isValid.test(jsonElement)) {
                throw new RuntimeException();
            }
            if (!validate) {
                return;
            }
            String value = jsonElement.getAsString();
            RiskToleranceEnum.fromValue(value);
        }

        static {
            validate = false;
            isValid = jsonElement -> true;
        }

        public static class Adapter
        extends TypeAdapter<RiskToleranceEnum> {
            public void write(JsonWriter jsonWriter, RiskToleranceEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RiskToleranceEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RiskToleranceEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum InvestmentObjectiveEnum {
        GENERATE_INCOME("generate_income"),
        PARTIALLY_FUND_RETIREMENT("partially_fund_retirement"),
        WHOLLY_FUND_RETIREMENT("wholly_fund_retirement"),
        STEADILY_ACCUMULATE_WEALTH("steadily_accumulate_wealth"),
        PRESERVE_WEALTH("preserve_wealth"),
        PAY_FOR_LARGE_PURCHASE("pay_for_large_purchase"),
        MARKET_SPECULATION("market_speculation");

        private String value;
        public static boolean validate;
        public static Predicate<JsonElement> isValid;

        private InvestmentObjectiveEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static InvestmentObjectiveEnum fromValue(String value) {
            for (InvestmentObjectiveEnum b : InvestmentObjectiveEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            if (!isValid.test(jsonElement)) {
                throw new RuntimeException();
            }
            if (!validate) {
                return;
            }
            String value = jsonElement.getAsString();
            InvestmentObjectiveEnum.fromValue(value);
        }

        static {
            validate = false;
            isValid = jsonElement -> true;
        }

        public static class Adapter
        extends TypeAdapter<InvestmentObjectiveEnum> {
            public void write(JsonWriter jsonWriter, InvestmentObjectiveEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public InvestmentObjectiveEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return InvestmentObjectiveEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum InvestmentTimeHorizonEnum {
        LESS_THAN_1_YEAR("less_than_1_year"),
        _1_TO_2_YEARS("1_to_2_years"),
        _3_TO_5_YEARS("3_to_5_years"),
        _6_TO_10_YEARS("6_to_10_years"),
        MORE_THAN_10_YEARS("more_than_10_years");

        private String value;
        public static boolean validate;
        public static Predicate<JsonElement> isValid;

        private InvestmentTimeHorizonEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static InvestmentTimeHorizonEnum fromValue(String value) {
            for (InvestmentTimeHorizonEnum b : InvestmentTimeHorizonEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            if (!isValid.test(jsonElement)) {
                throw new RuntimeException();
            }
            if (!validate) {
                return;
            }
            String value = jsonElement.getAsString();
            InvestmentTimeHorizonEnum.fromValue(value);
        }

        static {
            validate = false;
            isValid = jsonElement -> true;
        }

        public static class Adapter
        extends TypeAdapter<InvestmentTimeHorizonEnum> {
            public void write(JsonWriter jsonWriter, InvestmentTimeHorizonEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public InvestmentTimeHorizonEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return InvestmentTimeHorizonEnum.fromValue(value);
            }
        }
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Identity.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Identity.class));
            return new TypeAdapter<Identity>(){

                public void write(JsonWriter out, Identity value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Identity read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    Identity.validateJsonElement(jsonElement);
                    return (Identity)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FundingSourceEnum {
        EMPLOYMENT_INCOME("employment_income"),
        INVESTMENTS("investments"),
        INHERITANCE("inheritance"),
        BUSINESS_INCOME("business_income"),
        SAVINGS("savings"),
        FAMILY("family");

        private String value;
        public static boolean validate;
        public static Predicate<JsonElement> isValid;

        private FundingSourceEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FundingSourceEnum fromValue(String value) {
            for (FundingSourceEnum b : FundingSourceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            if (!isValid.test(jsonElement)) {
                throw new RuntimeException();
            }
            if (!validate) {
                return;
            }
            String value = jsonElement.getAsString();
            FundingSourceEnum.fromValue(value);
        }

        static {
            validate = false;
            isValid = jsonElement -> true;
        }

        public static class Adapter
        extends TypeAdapter<FundingSourceEnum> {
            public void write(JsonWriter jsonWriter, FundingSourceEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FundingSourceEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FundingSourceEnum.fromValue(value);
            }
        }
    }
}

